/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.snowflake;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.snowflake.GetSnowflakeIngestStatus;
import org.apache.nifi.processors.snowflake.SnowflakeConnectionProviderService;
import org.apache.nifi.processors.snowflake.SnowflakeConnectionWrapper;
import org.apache.nifi.processors.snowflake.StartSnowflakeIngest;
import org.apache.nifi.processors.snowflake.util.SnowflakeInternalStageType;
import org.apache.nifi.processors.snowflake.util.SnowflakeInternalStageTypeParameters;
import org.apache.nifi.processors.snowflake.util.SnowflakeProperties;

@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@WritesAttributes(value={@WritesAttribute(attribute="snowflake.staged.file.path", description="Staged file path")})
@Tags(value={"snowflake", "jdbc", "database", "connection", "snowpipe"})
@CapabilityDescription(value="Puts files into a Snowflake internal stage. The internal stage must be created in the Snowflake account beforehand. This processor can be connected to a StartSnowflakeIngest processor to ingest the file in the internal stage")
@SeeAlso(value={StartSnowflakeIngest.class, GetSnowflakeIngestStatus.class})
public class PutSnowflakeInternalStage
extends AbstractProcessor {
    public static final PropertyDescriptor SNOWFLAKE_CONNECTION_PROVIDER = new PropertyDescriptor.Builder().name("snowflake-connection-provider").displayName("Snowflake Connection Provider").description("Specifies the Controller Service to use for creating SQL connections to Snowflake.").identifiesControllerService(SnowflakeConnectionProviderService.class).required(true).build();
    public static final PropertyDescriptor INTERNAL_STAGE_TYPE = new PropertyDescriptor.Builder().name("internal-stage-type").displayName("Internal Stage Type").description("The type of internal stage to use").allowableValues(SnowflakeInternalStageType.class).required(true).build();
    public static final PropertyDescriptor DATABASE = new PropertyDescriptor.Builder().fromPropertyDescriptor(SnowflakeProperties.DATABASE).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).dependsOn(INTERNAL_STAGE_TYPE, (DescribedValue)SnowflakeInternalStageType.NAMED, new DescribedValue[]{SnowflakeInternalStageType.TABLE}).build();
    public static final PropertyDescriptor SCHEMA = new PropertyDescriptor.Builder().fromPropertyDescriptor(SnowflakeProperties.SCHEMA).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).dependsOn(INTERNAL_STAGE_TYPE, (DescribedValue)SnowflakeInternalStageType.NAMED, new DescribedValue[]{SnowflakeInternalStageType.TABLE}).build();
    public static final PropertyDescriptor TABLE = new PropertyDescriptor.Builder().name("table").displayName("Table").description("The name of the table in the Snowflake account.").addValidator(StandardValidators.NON_BLANK_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(true).dependsOn(INTERNAL_STAGE_TYPE, (DescribedValue)SnowflakeInternalStageType.TABLE, new DescribedValue[0]).build();
    public static final PropertyDescriptor INTERNAL_STAGE = new PropertyDescriptor.Builder().name("internal-stage").displayName("Stage").description("The name of the internal stage in the Snowflake account to put files into.").addValidator(StandardValidators.NON_BLANK_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(true).dependsOn(INTERNAL_STAGE_TYPE, (DescribedValue)SnowflakeInternalStageType.NAMED, new DescribedValue[0]).build();
    static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("For FlowFiles of successful PUT operation").build();
    static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("For FlowFiles of failed PUT operation").build();
    static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(SNOWFLAKE_CONNECTION_PROVIDER, INTERNAL_STAGE_TYPE, DATABASE, SCHEMA, TABLE, INTERNAL_STAGE);
    private static final Set<Relationship> RELATIONSHIPS = Set.of(REL_SUCCESS, REL_FAILURE);

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        SnowflakeInternalStageType internalStageType = (SnowflakeInternalStageType)context.getProperty(INTERNAL_STAGE_TYPE).asAllowableValue(SnowflakeInternalStageType.class);
        SnowflakeInternalStageTypeParameters parameters = this.getSnowflakeInternalStageTypeParameters(internalStageType, context, flowFile);
        String internalStageName = internalStageType.getStage(parameters);
        SnowflakeConnectionProviderService connectionProviderService = (SnowflakeConnectionProviderService)context.getProperty(SNOWFLAKE_CONNECTION_PROVIDER).asControllerService(SnowflakeConnectionProviderService.class);
        String stagedFileName = UUID.randomUUID().toString();
        try (InputStream inputStream = session.read(flowFile);
             SnowflakeConnectionWrapper snowflakeConnection = connectionProviderService.getSnowflakeConnection();){
            snowflakeConnection.unwrap().uploadStream(internalStageName, "", inputStream, stagedFileName, false);
        }
        catch (SQLException e) {
            this.getLogger().error("Failed to upload FlowFile content to internal Snowflake stage [{}]. Staged file path [{}]", new Object[]{internalStageName, stagedFileName, e});
            session.transfer(session.penalize(flowFile), REL_FAILURE);
            return;
        }
        catch (IOException e) {
            throw new ProcessException("Failed to read FlowFile content", (Throwable)e);
        }
        flowFile = session.putAttribute(flowFile, "snowflake.staged.file.path", stagedFileName);
        session.transfer(flowFile, REL_SUCCESS);
    }

    private SnowflakeInternalStageTypeParameters getSnowflakeInternalStageTypeParameters(SnowflakeInternalStageType stageType, ProcessContext context, FlowFile flowFile) {
        String database = context.getProperty(DATABASE).evaluateAttributeExpressions(flowFile).getValue();
        String schema = context.getProperty(SCHEMA).evaluateAttributeExpressions(flowFile).getValue();
        String table = stageType == SnowflakeInternalStageType.TABLE ? context.getProperty(TABLE).evaluateAttributeExpressions(flowFile).getValue() : null;
        String stageName = stageType == SnowflakeInternalStageType.NAMED ? context.getProperty(INTERNAL_STAGE).evaluateAttributeExpressions(flowFile).getValue() : null;
        return new SnowflakeInternalStageTypeParameters(database, schema, table, stageName);
    }
}

