/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.snowflake;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Set;
import net.snowflake.ingest.SimpleIngestManager;
import net.snowflake.ingest.connection.IngestResponseException;
import net.snowflake.ingest.utils.StagedFileWrapper;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.ReadsAttribute;
import org.apache.nifi.annotation.behavior.ReadsAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.snowflake.GetSnowflakeIngestStatus;
import org.apache.nifi.processors.snowflake.PutSnowflakeInternalStage;
import org.apache.nifi.processors.snowflake.SnowflakeIngestManagerProviderService;

@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@ReadsAttributes(value={@ReadsAttribute(attribute="snowflake.staged.file.path", description="Staged file path")})
@Tags(value={"snowflake", "snowpipe", "ingest"})
@CapabilityDescription(value="Ingests files from a Snowflake internal or external stage into a Snowflake table. The stage must be created in the Snowflake account beforehand. The result of the ingestion is not available immediately, so this processor can be connected to an GetSnowflakeIngestStatus processor to wait for the results")
@SeeAlso(value={PutSnowflakeInternalStage.class, GetSnowflakeIngestStatus.class})
public class StartSnowflakeIngest
extends AbstractProcessor {
    static final PropertyDescriptor INGEST_MANAGER_PROVIDER = new PropertyDescriptor.Builder().name("ingest-manager-provider").displayName("Ingest Manager Provider").description("Specifies the Controller Service to use for ingesting Snowflake staged files.").identifiesControllerService(SnowflakeIngestManagerProviderService.class).required(true).build();
    static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("For FlowFiles of successful ingest request").build();
    static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("For FlowFiles of failed ingest request").build();
    static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(INGEST_MANAGER_PROVIDER);
    private static final Set<Relationship> RELATIONSHIPS = Set.of(REL_SUCCESS, REL_FAILURE);

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        String stagedFilePath = flowFile.getAttribute("snowflake.staged.file.path");
        if (stagedFilePath == null) {
            this.getLogger().error("Missing required attribute [\"{}\"] for FlowFile", new Object[]{"snowflake.staged.file.path"});
            session.transfer(session.penalize(flowFile), REL_FAILURE);
            return;
        }
        SnowflakeIngestManagerProviderService ingestManagerProviderService = (SnowflakeIngestManagerProviderService)context.getProperty(INGEST_MANAGER_PROVIDER).asControllerService(SnowflakeIngestManagerProviderService.class);
        SimpleIngestManager snowflakeIngestManager = ingestManagerProviderService.getIngestManager();
        StagedFileWrapper stagedFile = new StagedFileWrapper(stagedFilePath);
        try {
            snowflakeIngestManager.ingestFile(stagedFile, null);
        }
        catch (IOException | URISyntaxException e) {
            throw new ProcessException(String.format("Failed to ingest Snowflake file [%s]", stagedFilePath), (Throwable)e);
        }
        catch (IngestResponseException e) {
            this.getLogger().error("Failed to ingest Snowflake file [{}]", new Object[]{stagedFilePath, e});
            session.transfer(session.penalize(flowFile), REL_FAILURE);
            return;
        }
        session.transfer(flowFile, REL_SUCCESS);
    }
}

