/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.smb.common;

import com.hierynomus.mssmb2.SMB2Dialect;
import com.hierynomus.smbj.SMBClient;
import com.hierynomus.smbj.SmbConfig;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.smb.common.SmbClient;
import org.apache.nifi.smb.common.SmbDialect;
import org.apache.nifi.smb.common.SmbProperties;

public final class SmbUtils {
    private SmbUtils() {
    }

    public static SMBClient buildSmbClient(PropertyContext context) {
        return SmbClient.create(SmbUtils.buildSmbConfig(context));
    }

    static SmbConfig buildSmbConfig(PropertyContext context) {
        SmbDialect dialect;
        SmbConfig.Builder configBuilder = SmbConfig.builder();
        if (context.getProperty(SmbProperties.SMB_DIALECT).isSet() && (dialect = SmbDialect.valueOf(context.getProperty(SmbProperties.SMB_DIALECT).getValue())) != SmbDialect.AUTO) {
            configBuilder.withDialects(new SMB2Dialect[]{dialect.getSmbjDialect()});
        }
        if (context.getProperty(SmbProperties.USE_ENCRYPTION).isSet()) {
            configBuilder.withEncryptData(context.getProperty(SmbProperties.USE_ENCRYPTION).asBoolean().booleanValue());
        }
        if (context.getProperty(SmbProperties.ENABLE_DFS).isSet()) {
            configBuilder.withDfsEnabled(context.getProperty(SmbProperties.ENABLE_DFS).asBoolean().booleanValue());
        }
        if (context.getProperty(SmbProperties.TIMEOUT).isSet()) {
            configBuilder.withTimeout(context.getProperty(SmbProperties.TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS).longValue(), TimeUnit.MILLISECONDS);
        }
        return configBuilder.build();
    }
}

