/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.slack.consume;

import com.slack.api.methods.response.users.UsersInfoResponse;
import com.slack.api.model.User;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processors.slack.consume.UserInfoClient;
import org.apache.nifi.processors.slack.util.SlackResponseUtil;

public class UserDetailsLookup {
    private final ConcurrentMap<String, User> userIdToInfoMapping = new ConcurrentHashMap<String, User>();
    private final UserInfoClient client;
    private final ComponentLog logger;

    public UserDetailsLookup(UserInfoClient client, ComponentLog logger) {
        this.client = client;
        this.logger = logger;
    }

    public User getUserDetails(String userId) {
        User cachedUserInfo = (User)this.userIdToInfoMapping.get(userId);
        if (cachedUserInfo != null) {
            return cachedUserInfo;
        }
        try {
            UsersInfoResponse response = this.client.fetchUserInfo(userId);
            if (response.isOk()) {
                User user = response.getUser();
                this.userIdToInfoMapping.put(userId, user);
                return user;
            }
            String errorMessage = SlackResponseUtil.getErrorMessage(response.getError(), response.getNeeded(), response.getProvided(), response.getWarning());
            this.logger.warn("Failed to retrieve user details for User ID {}: {}", new Object[]{userId, errorMessage});
            return null;
        }
        catch (Exception e) {
            if (SlackResponseUtil.isRateLimited(e)) {
                this.logger.warn("Failed to retrieve user details for User ID {} because the Rate Limit has been exceeded", new Object[]{userId});
            } else {
                this.logger.warn("Failed to retrieve user details for User ID {}: {}", new Object[]{userId, e.getMessage(), e});
            }
            return null;
        }
    }
}

