/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.slack.consume;

import org.apache.commons.lang3.StringUtils;

public class SlackTimestamp
implements Comparable<SlackTimestamp> {
    private final String value;
    private final String normalizedValue;

    public SlackTimestamp() {
        this(System.currentTimeMillis());
    }

    public SlackTimestamp(long timestamp) {
        long millis = timestamp % 1000L;
        long seconds = timestamp / 1000L;
        String paddedMillis = StringUtils.leftPad((String)Long.toString(millis), (int)3, (char)'0');
        this.value = seconds + "." + paddedMillis + "000";
        this.normalizedValue = this.value;
    }

    public SlackTimestamp(String value) {
        this.value = value;
        String[] splits = value.split("\\.");
        String paddedMicros = StringUtils.rightPad((String)splits[1], (int)6, (char)'0');
        this.normalizedValue = splits[0] + "." + paddedMicros;
    }

    @Override
    public int compareTo(SlackTimestamp other) {
        if (other == this) {
            return 0;
        }
        return this.normalizedValue.compareTo(other.normalizedValue);
    }

    public boolean before(SlackTimestamp other) {
        return this.compareTo(other) < 0;
    }

    public boolean beforeOrEqualTo(SlackTimestamp other) {
        return this.compareTo(other) <= 0;
    }

    public boolean after(SlackTimestamp other) {
        return this.compareTo(other) > 0;
    }

    public boolean afterOrEqualTo(SlackTimestamp other) {
        return this.compareTo(other) >= 0;
    }

    public String getRawValue() {
        return this.value;
    }

    public String toString() {
        return this.normalizedValue;
    }
}

