/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote;

import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.attribute.expression.language.EvaluationContext;
import org.apache.nifi.attribute.expression.language.PreparedQuery;
import org.apache.nifi.attribute.expression.language.Query;
import org.apache.nifi.attribute.expression.language.StandardEvaluationContext;
import org.apache.nifi.attribute.expression.language.exception.AttributeExpressionLanguageParsingException;
import org.apache.nifi.remote.PeerDescription;
import org.apache.nifi.remote.protocol.SiteToSiteTransportProtocol;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.util.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerDescriptionModifier {
    private static final Logger logger = LoggerFactory.getLogger(PeerDescriptionModifier.class);
    private Map<SiteToSiteTransportProtocol, List<Route>> routes;
    private static final String PROPERTY_PREFIX = "nifi.remote.route.";
    private static final Pattern PROPERTY_REGEX = Pattern.compile("^nifi\\.remote\\.route\\.(raw|http)\\.([^.]+)\\.(when|hostname|port|secure)$");

    public PeerDescriptionModifier(NiFiProperties properties) {
        Map routeDefinitions = properties.getPropertyKeys().stream().filter(propertyKey -> propertyKey.startsWith(PROPERTY_PREFIX)).map(propertyKey -> {
            Matcher matcher = PROPERTY_REGEX.matcher((CharSequence)propertyKey);
            if (!matcher.matches()) {
                throw new IllegalArgumentException(String.format("Found an invalid Site-to-Site route definition property '%s'. Routing property keys should be formatted as 'nifi.remote.route.{protocol}.{name}.{routingConfigName}'. Where {protocol} is 'raw' or 'http', and {routingConfigName} is 'when', 'hostname', 'port' or 'secure'.", propertyKey));
            }
            return matcher;
        }).collect(Collectors.groupingBy(matcher -> new Tuple((Object)matcher.group(1), (Object)matcher.group(2)), Collectors.mapping(matcher -> new Tuple((Object)matcher.group(3), (Object)matcher.group(0)), Collectors.toList())));
        this.routes = routeDefinitions.entrySet().stream().map(routeDefinition -> {
            Route route = new Route();
            Tuple protocolAndRoutingName = (Tuple)routeDefinition.getKey();
            route.protocol = SiteToSiteTransportProtocol.valueOf((String)((String)protocolAndRoutingName.getKey()).toUpperCase());
            route.name = (String)protocolAndRoutingName.getValue();
            ((List)routeDefinition.getValue()).forEach(routingConfigNameAndPropertyKey -> {
                String routingConfigName = (String)routingConfigNameAndPropertyKey.getKey();
                String propertyKey = (String)routingConfigNameAndPropertyKey.getValue();
                String routingConfigValue = properties.getProperty(propertyKey);
                try {
                    switch (routingConfigName) {
                        case "when": {
                            route.predicate = Query.prepare((String)routingConfigValue);
                            break;
                        }
                        case "hostname": {
                            route.hostname = Query.prepare((String)routingConfigValue);
                            break;
                        }
                        case "port": {
                            route.port = Query.prepare((String)routingConfigValue);
                            break;
                        }
                        case "secure": {
                            route.secure = Query.prepare((String)routingConfigValue);
                        }
                    }
                }
                catch (AttributeExpressionLanguageParsingException e) {
                    throw new IllegalArgumentException(String.format("Failed to parse NiFi expression language configured for Site-to-Site routing property at '%s' due to '%s'", propertyKey, e.getMessage()), e);
                }
            });
            return route;
        }).map(Route::validate).collect(Collectors.groupingBy(r -> r.protocol));
    }

    private void addVariables(Map<String, String> map, String prefix, PeerDescription peer) {
        map.put(String.format("%s.hostname", prefix), peer.getHostname());
        map.put(String.format("%s.port", prefix), String.valueOf(peer.getPort()));
        map.put(String.format("%s.secure", prefix), String.valueOf(peer.isSecure()));
    }

    public boolean isModificationNeeded(SiteToSiteTransportProtocol protocol) {
        return this.routes != null && this.routes.containsKey(protocol) && !this.routes.get(protocol).isEmpty();
    }

    public PeerDescription modify(PeerDescription source, PeerDescription target, SiteToSiteTransportProtocol protocol, RequestType requestType, Map<String, String> variables) {
        this.addVariables(variables, "s2s.source", source);
        this.addVariables(variables, "s2s.target", target);
        variables.put("s2s.protocol", protocol.name());
        variables.put("s2s.request", requestType.name());
        logger.debug("Modifying PeerDescription, variables={}", variables);
        return this.routes.get(protocol).stream().filter(r -> r.predicate == null || Boolean.valueOf(r.predicate.evaluateExpressions((EvaluationContext)new StandardEvaluationContext(variables), null)) != false).map(r -> {
            PeerDescription t = r.getTarget(variables);
            logger.debug("Route definition {} matched, {}", (Object)r.name, (Object)t);
            return t;
        }).findFirst().orElse(target);
    }

    public static enum RequestType {
        SiteToSiteDetail,
        Peers;

    }

    private static class Route {
        private String name;
        private SiteToSiteTransportProtocol protocol;
        private PreparedQuery predicate;
        private PreparedQuery hostname;
        private PreparedQuery port;
        private PreparedQuery secure;

        private Route() {
        }

        private Route validate() {
            if (this.hostname == null) {
                throw new IllegalArgumentException(String.format("Found an invalid Site-to-Site route definition [%s] 'hostname' is not specified.", this.name));
            }
            if (this.port == null) {
                throw new IllegalArgumentException(String.format("Found an invalid Site-to-Site route definition [%s] 'port' is not specified.", this.name));
            }
            return this;
        }

        private PeerDescription getTarget(Map<String, String> variables) {
            StandardEvaluationContext evaluationContext = new StandardEvaluationContext(variables);
            String targetHostName = this.hostname.evaluateExpressions((EvaluationContext)evaluationContext, null);
            if (StringUtils.isBlank((CharSequence)targetHostName)) {
                throw new IllegalStateException("Target hostname was not resolved for the route definition " + this.name);
            }
            String targetPortStr = this.port.evaluateExpressions((EvaluationContext)evaluationContext, null);
            if (StringUtils.isBlank((CharSequence)targetPortStr)) {
                throw new IllegalStateException("Target port was not resolved for the route definition " + this.name);
            }
            String targetIsSecure = this.secure == null ? null : this.secure.evaluateExpressions((EvaluationContext)evaluationContext, null);
            return new PeerDescription(targetHostName, Integer.valueOf(targetPortStr).intValue(), Boolean.valueOf(targetIsSecure).booleanValue());
        }
    }
}

