/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.nifi.remote.VersionNegotiator;
import org.apache.nifi.remote.codec.FlowFileCodec;
import org.apache.nifi.remote.protocol.ClientProtocol;
import org.apache.nifi.remote.protocol.ServerProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteResourceManager {
    private static final Map<String, Class<? extends FlowFileCodec>> codecClassMap;
    private static final Map<String, Class<? extends ServerProtocol>> desiredServerProtocolClassMap;
    private static final Map<String, Class<? extends ClientProtocol>> desiredClientProtocolClassMap;
    private static final Map<String, Set<Class<? extends ServerProtocol>>> serverProtocolClassMap;
    private static final Map<String, Set<Class<? extends ClientProtocol>>> clientProtocolClassMap;
    private static final Logger logger;

    public static boolean isCodecSupported(String codecName) {
        return codecClassMap.containsKey(codecName);
    }

    public static boolean isCodecSupported(String codecName, int version) {
        if (!RemoteResourceManager.isCodecSupported(codecName)) {
            return false;
        }
        FlowFileCodec codec = RemoteResourceManager.createCodec(codecName);
        VersionNegotiator negotiator = codec.getVersionNegotiator();
        return negotiator.isVersionSupported(version);
    }

    public static FlowFileCodec createCodec(String codecName, int version) {
        FlowFileCodec codec = RemoteResourceManager.createCodec(codecName);
        VersionNegotiator negotiator = codec.getVersionNegotiator();
        if (!negotiator.isVersionSupported(version)) {
            throw new IllegalArgumentException("FlowFile Codec " + codecName + " does not support version " + version);
        }
        negotiator.setVersion(version);
        return codec;
    }

    private static FlowFileCodec createCodec(String codecName) {
        Class<? extends FlowFileCodec> codecClass = codecClassMap.get(codecName);
        if (codecClass == null) {
            throw new IllegalArgumentException("Unknown Codec: " + codecName);
        }
        try {
            return codecClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate class " + codecClass.getName(), e);
        }
    }

    public static Set<String> getSupportedCodecNames() {
        return codecClassMap.keySet();
    }

    public static List<Integer> getSupportedVersions(String codecName) {
        FlowFileCodec codec = RemoteResourceManager.createCodec(codecName);
        return codec.getSupportedVersions();
    }

    public static Set<Class<? extends ClientProtocol>> getClientProtocolClasses(String protocolName) {
        Set<Class<? extends ClientProtocol>> classes = clientProtocolClassMap.get(protocolName);
        if (classes == null) {
            return new HashSet<Class<? extends ClientProtocol>>();
        }
        return new HashSet<Class<? extends ClientProtocol>>(classes);
    }

    public static Set<Class<? extends ServerProtocol>> getServerProtocolClasses(String protocolName) {
        Set<Class<? extends ServerProtocol>> classes = serverProtocolClassMap.get(protocolName);
        if (classes == null) {
            return new HashSet<Class<? extends ServerProtocol>>();
        }
        return new HashSet<Class<? extends ServerProtocol>>(classes);
    }

    public static void setServerProtocolImplementation(String protocolName, Class<? extends ServerProtocol> clazz) {
        desiredServerProtocolClassMap.put(protocolName, clazz);
    }

    public static void setClientProtocolImplementation(String protocolName, Class<? extends ClientProtocol> clazz) {
        desiredClientProtocolClassMap.put(protocolName, clazz);
    }

    public static ServerProtocol createServerProtocol(String protocolName) {
        Set<Class<? extends ServerProtocol>> classSet = RemoteResourceManager.getServerProtocolClasses(protocolName);
        if (classSet.isEmpty()) {
            throw new IllegalArgumentException("Unknkown Server Protocol: " + protocolName);
        }
        Class<? extends ServerProtocol> desiredClass = desiredServerProtocolClassMap.get(protocolName);
        if (desiredClass == null && classSet.size() > 1) {
            throw new IllegalStateException("Multiple implementations of Server Protocol " + protocolName + " were found and no preferred implementation has been specified");
        }
        if (desiredClass != null && !classSet.contains(desiredClass)) {
            throw new IllegalStateException("Desired implementation of Server Protocol " + protocolName + " is set to " + String.valueOf(desiredClass) + ", but that Protocol is not registered as a Server Protocol");
        }
        if (desiredClass == null) {
            desiredClass = classSet.iterator().next();
        }
        try {
            return desiredClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate class " + desiredClass.getName(), e);
        }
    }

    public static ClientProtocol createClientProtocol(String protocolName) {
        Set<Class<? extends ClientProtocol>> classSet = RemoteResourceManager.getClientProtocolClasses(protocolName);
        if (classSet.isEmpty()) {
            throw new IllegalArgumentException("Unknkown Client Protocol: " + protocolName);
        }
        Class<? extends ClientProtocol> desiredClass = desiredClientProtocolClassMap.get(protocolName);
        if (desiredClass == null && classSet.size() > 1) {
            throw new IllegalStateException("Multiple implementations of Client Protocol " + protocolName + " were found and no preferred implementation has been specified");
        }
        if (desiredClass != null && !classSet.contains(desiredClass)) {
            throw new IllegalStateException("Desired implementation of Client Protocol " + protocolName + " is set to " + String.valueOf(desiredClass) + ", but that Protocol is not registered as a Client Protocol");
        }
        if (desiredClass == null) {
            desiredClass = classSet.iterator().next();
        }
        try {
            return desiredClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate class " + desiredClass.getName(), e);
        }
    }

    static {
        desiredServerProtocolClassMap = new ConcurrentHashMap<String, Class<? extends ServerProtocol>>();
        desiredClientProtocolClassMap = new ConcurrentHashMap<String, Class<? extends ClientProtocol>>();
        logger = LoggerFactory.getLogger(RemoteResourceManager.class);
        HashMap<String, Class> codecMap = new HashMap<String, Class>();
        HashMap<String, HashSet<Class>> serverProtocolMap = new HashMap<String, HashSet<Class>>();
        HashMap<String, HashSet<Class>> clientProtocolMap = new HashMap<String, HashSet<Class>>();
        ClassLoader classLoader = RemoteResourceManager.class.getClassLoader();
        ServiceLoader<FlowFileCodec> flowFileCodecLoader = ServiceLoader.load(FlowFileCodec.class, classLoader);
        for (FlowFileCodec codec : flowFileCodecLoader) {
            Class clazz = codec.getClass();
            String codecName = codec.getResourceName();
            Class previousValue = codecMap.put(codecName, clazz);
            if (previousValue == null) continue;
            logger.warn("Multiple FlowFileCodec's found with name {}; choosing to use {} in place of {}", new Object[]{codecName, clazz.getName(), previousValue.getName()});
        }
        ServiceLoader<ServerProtocol> serverProtocolLoader = ServiceLoader.load(ServerProtocol.class, classLoader);
        for (ServerProtocol protocol : serverProtocolLoader) {
            Class clazz = protocol.getClass();
            String protocolName = protocol.getResourceName();
            HashSet<Class> classSet = (HashSet<Class>)serverProtocolMap.get(protocolName);
            if (classSet == null) {
                classSet = new HashSet<Class>();
                serverProtocolMap.put(protocolName, classSet);
            }
            classSet.add(clazz);
        }
        ServiceLoader<ClientProtocol> clientProtocolLoader = ServiceLoader.load(ClientProtocol.class, classLoader);
        for (ClientProtocol protocol : clientProtocolLoader) {
            Class clazz = protocol.getClass();
            String protocolName = protocol.getResourceName();
            HashSet<Class> classSet = (HashSet<Class>)clientProtocolMap.get(protocolName);
            if (classSet == null) {
                classSet = new HashSet<Class>();
                clientProtocolMap.put(protocolName, classSet);
            }
            classSet.add(clazz);
        }
        codecClassMap = Collections.unmodifiableMap(codecMap);
        clientProtocolClassMap = Collections.unmodifiableMap(clientProtocolMap);
        serverProtocolClassMap = Collections.unmodifiableMap(serverProtocolMap);
    }
}

