/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.reporting.s2s;

import java.io.Serializable;
import java.net.Proxy;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.events.EventReporter;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.proxy.ProxyConfiguration;
import org.apache.nifi.proxy.ProxyConfigurationService;
import org.apache.nifi.proxy.ProxySpec;
import org.apache.nifi.remote.client.SiteToSiteClient;
import org.apache.nifi.remote.protocol.SiteToSiteTransportProtocol;
import org.apache.nifi.remote.protocol.http.HttpProxy;
import org.apache.nifi.remote.util.SiteToSiteRestApiClient;
import org.apache.nifi.reporting.ReportingContext;
import org.apache.nifi.ssl.SSLContextProvider;

public class SiteToSiteUtils {
    public static final String OBSOLETE_PROXY_HOST = "s2s-http-proxy-hostname";
    public static final String OBSOLETE_PROXY_PORT = "s2s-http-proxy-port";
    public static final String OBSOLETE_PROXY_USERNAME = "s2s-http-proxy-username";
    public static final String OBSOLETE_PROXY_PASSWORD = "s2s-http-proxy-password";
    public static final PropertyDescriptor DESTINATION_URL = new PropertyDescriptor.Builder().name("Destination URL").displayName("Destination URL").description("The URL of the destination NiFi instance or, if clustered, a comma-separated list of address in the format of http(s)://host:port/nifi. This destination URL will only be used to initiate the Site-to-Site connection. The data sent by this reporting task will be load-balanced on all the nodes of the destination (if clustered).").required(true).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).addValidator((Validator)new NiFiUrlValidator()).build();
    public static final PropertyDescriptor PORT_NAME = new PropertyDescriptor.Builder().name("Input Port Name").displayName("Input Port Name").description("The name of the Input Port to deliver data to.").required(true).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor SSL_CONTEXT = new PropertyDescriptor.Builder().name("SSL Context Service").displayName("SSL Context Service").description("The SSL Context Service to use when communicating with the destination. If not specified, communications will not be secure.").required(false).identifiesControllerService(SSLContextProvider.class).build();
    public static final PropertyDescriptor INSTANCE_URL = new PropertyDescriptor.Builder().name("Instance URL").displayName("Instance URL").description("The URL of this instance to use in the Content URI of each event.").required(true).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).defaultValue("http://${hostname(true)}:8080/nifi").addValidator((Validator)new NiFiUrlValidator()).build();
    public static final PropertyDescriptor COMPRESS = new PropertyDescriptor.Builder().name("Compress Events").displayName("Compress Events").description("Indicates whether or not to compress the data being sent.").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("true").build();
    public static final PropertyDescriptor TIMEOUT = new PropertyDescriptor.Builder().name("Communications Timeout").displayName("Communications Timeout").description("Specifies how long to wait to a response from the destination before deciding that an error has occurred and canceling the transaction").required(true).defaultValue("30 secs").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).build();
    public static final PropertyDescriptor BATCH_SIZE = new PropertyDescriptor.Builder().name("Batch Size").displayName("Batch Size").description("Specifies how many records to send in a single batch, at most.").required(true).defaultValue("1000").addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).build();
    public static final PropertyDescriptor TRANSPORT_PROTOCOL = new PropertyDescriptor.Builder().name("s2s-transport-protocol").displayName("Transport Protocol").description("Specifies which transport protocol to use for Site-to-Site communication.").required(true).allowableValues((Enum[])SiteToSiteTransportProtocol.values()).defaultValue(SiteToSiteTransportProtocol.RAW.name()).build();
    public static final PropertyDescriptor PROXY_CONFIGURATION_SERVICE = new PropertyDescriptor.Builder().fromPropertyDescriptor(ProxyConfiguration.createProxyConfigPropertyDescriptor((ProxySpec[])new ProxySpec[]{ProxySpec.HTTP, ProxySpec.HTTP_AUTH})).dependsOn(TRANSPORT_PROTOCOL, SiteToSiteTransportProtocol.HTTP.name(), new String[0]).build();
    public static final PropertyDescriptor PLATFORM = new PropertyDescriptor.Builder().name("Platform").description("The value to use for the platform field in each event.").required(true).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).defaultValue("nifi").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();

    public static SiteToSiteClient getClient(PropertyContext reportContext, ComponentLog logger, StateManager stateManager) {
        ProxyConfiguration proxyConfiguration;
        ProxyConfigurationService proxyConfigurationService;
        SSLContextProvider sslContextProvider = (SSLContextProvider)reportContext.getProperty(SSL_CONTEXT).asControllerService(SSLContextProvider.class);
        SSLContext sslContext = sslContextProvider == null ? null : sslContextProvider.createContext();
        EventReporter & Serializable eventReporter = (EventReporter & Serializable)(severity, category, message) -> {
            switch (severity) {
                case WARNING: {
                    logger.warn(message);
                    break;
                }
                case ERROR: {
                    logger.error(message);
                    break;
                }
            }
        };
        String destinationUrl = reportContext.getProperty(DESTINATION_URL).evaluateAttributeExpressions().getValue();
        SiteToSiteTransportProtocol mode = SiteToSiteTransportProtocol.valueOf((String)reportContext.getProperty(TRANSPORT_PROTOCOL).getValue());
        HttpProxy httpProxy = null;
        if (mode == SiteToSiteTransportProtocol.HTTP && (proxyConfigurationService = (ProxyConfigurationService)reportContext.getProperty(PROXY_CONFIGURATION_SERVICE).asControllerService(ProxyConfigurationService.class)) != null && (proxyConfiguration = proxyConfigurationService.getConfiguration()).getProxyType() == Proxy.Type.HTTP) {
            httpProxy = new HttpProxy(proxyConfiguration.getProxyServerHost(), proxyConfiguration.getProxyServerPort(), proxyConfiguration.getProxyUserName(), proxyConfiguration.getProxyUserPassword());
        }
        if (stateManager == null && reportContext instanceof ReportingContext) {
            stateManager = ((ReportingContext)reportContext).getStateManager();
        }
        return new SiteToSiteClient.Builder().urls(SiteToSiteRestApiClient.parseClusterUrls((String)destinationUrl)).portName(reportContext.getProperty(PORT_NAME).getValue()).useCompression(reportContext.getProperty(COMPRESS).asBoolean().booleanValue()).eventReporter((EventReporter)eventReporter).sslContext(sslContext).timeout(reportContext.getProperty(TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS).longValue(), TimeUnit.MILLISECONDS).transportProtocol(mode).httpProxy(httpProxy).stateManager(stateManager).build();
    }

    public static class NiFiUrlValidator
    implements Validator {
        public ValidationResult validate(String subject, String input, ValidationContext context) {
            String value = context.newPropertyValue(input).evaluateAttributeExpressions().getValue();
            try {
                SiteToSiteRestApiClient.parseClusterUrls((String)value);
                return new ValidationResult.Builder().input(input).subject(subject).valid(true).build();
            }
            catch (IllegalArgumentException ex) {
                return new ValidationResult.Builder().input(input).subject(subject).valid(false).explanation(ex.getLocalizedMessage()).build();
            }
        }
    }
}

