/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.reporting;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.json.Json;
import javax.json.JsonBuilderFactory;
import org.apache.avro.Schema;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.avro.AvroTypeUtil;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.controller.status.ProcessGroupStatus;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.metrics.jvm.JmxJvmMetrics;
import org.apache.nifi.metrics.jvm.JvmMetrics;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.remote.Transaction;
import org.apache.nifi.remote.TransferDirection;
import org.apache.nifi.reporting.AbstractSiteToSiteReportingTask;
import org.apache.nifi.reporting.ReportingContext;
import org.apache.nifi.reporting.s2s.SiteToSiteUtils;
import org.apache.nifi.reporting.util.metrics.MetricsService;
import org.apache.nifi.reporting.util.metrics.api.MetricsBuilder;

@Tags(value={"status", "metrics", "site", "site to site"})
@CapabilityDescription(value="Publishes same metrics as the Ambari Reporting task using the Site To Site protocol.")
public class SiteToSiteMetricsReportingTask
extends AbstractSiteToSiteReportingTask {
    static final AllowableValue AMBARI_FORMAT = new AllowableValue("ambari-format", "Ambari Format", "Metrics will be formatted according to the Ambari Metrics API. See Additional Details in Usage documentation.");
    static final AllowableValue RECORD_FORMAT = new AllowableValue("record-format", "Record Format", "Metrics will be formatted using the Record Writer property of this reporting task. See Additional Details in Usage documentation to have the description of the default schema.");
    static final PropertyDescriptor APPLICATION_ID = new PropertyDescriptor.Builder().name("s2s-metrics-application-id").displayName("Application ID").description("The Application ID to be included in the metrics").required(true).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).defaultValue("nifi").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    static final PropertyDescriptor HOSTNAME = new PropertyDescriptor.Builder().name("s2s-metrics-hostname").displayName("Hostname").description("The Hostname of this NiFi instance to be included in the metrics").required(true).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).defaultValue("${hostname(true)}").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    static final PropertyDescriptor FORMAT = new PropertyDescriptor.Builder().name("s2s-metrics-format").displayName("Output Format").description("The output format that will be used for the metrics. If " + RECORD_FORMAT.getDisplayName() + " is selected, a Record Writer must be provided. If " + AMBARI_FORMAT.getDisplayName() + " is selected, the Record Writer property should be empty.").required(true).allowableValues(new DescribedValue[]{AMBARI_FORMAT, RECORD_FORMAT}).defaultValue(AMBARI_FORMAT.getValue()).addValidator(Validator.VALID).build();
    private final MetricsService metricsService = new MetricsService();

    public SiteToSiteMetricsReportingTask() throws IOException {
        InputStream schema = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("schema-metrics.avsc");
        this.recordSchema = AvroTypeUtil.createSchema((Schema)new Schema.Parser().parse(schema));
    }

    @Override
    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>(super.getSupportedPropertyDescriptors());
        properties.add(HOSTNAME);
        properties.add(APPLICATION_ID);
        properties.add(FORMAT);
        properties.remove(SiteToSiteUtils.BATCH_SIZE);
        return properties;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> problems = new ArrayList<ValidationResult>(super.customValidate(validationContext));
        boolean isWriterSet = validationContext.getProperty(RECORD_WRITER).isSet();
        if (validationContext.getProperty(FORMAT).getValue().equals(RECORD_FORMAT.getValue()) && !isWriterSet) {
            problems.add(new ValidationResult.Builder().input("Record Writer").valid(false).explanation("If using " + RECORD_FORMAT.getDisplayName() + ", a record writer needs to be set.").build());
        }
        if (validationContext.getProperty(FORMAT).getValue().equals(AMBARI_FORMAT.getValue()) && isWriterSet) {
            problems.add(new ValidationResult.Builder().input("Record Writer").valid(false).explanation("If using " + AMBARI_FORMAT.getDisplayName() + ", no record writer should be set.").build());
        }
        return problems;
    }

    public void onTrigger(ReportingContext context) {
        boolean isClustered = context.isClustered();
        String nodeId = context.getClusterNodeIdentifier();
        if (nodeId == null && isClustered) {
            this.getLogger().debug("This instance of NiFi is configured for clustering, but the Cluster Node Identifier is not yet available. Will wait for Node Identifier to be established.");
            return;
        }
        JmxJvmMetrics virtualMachineMetrics = JmxJvmMetrics.getInstance();
        Map config = Collections.emptyMap();
        JsonBuilderFactory factory = Json.createBuilderFactory(config);
        String applicationId = context.getProperty(APPLICATION_ID).evaluateAttributeExpressions().getValue();
        String hostname = context.getProperty(HOSTNAME).evaluateAttributeExpressions().getValue();
        ProcessGroupStatus status = context.getEventAccess().getControllerStatus();
        Boolean allowNullValues = context.getProperty(ALLOW_NULL_VALUES).asBoolean();
        if (status != null) {
            byte[] data;
            Map statusMetrics = this.metricsService.getMetrics(status, false);
            Map jvmMetrics = this.metricsService.getMetrics((JvmMetrics)virtualMachineMetrics);
            MetricsBuilder metricsBuilder = new MetricsBuilder(factory);
            OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
            double systemLoad = os.getSystemLoadAverage();
            HashMap<String, String> attributes = new HashMap<String, String>();
            if (context.getProperty(FORMAT).getValue().equals(AMBARI_FORMAT.getValue())) {
                metricsObject = metricsBuilder.applicationId(applicationId).instanceId(status.getId()).hostname(hostname).timestamp(System.currentTimeMillis()).addAllMetrics(statusMetrics).addAllMetrics(jvmMetrics).metric("availableCores", String.valueOf(os.getAvailableProcessors())).metric("loadAverage1min", String.valueOf(systemLoad >= 0.0 ? systemLoad : -1.0)).build(allowNullValues.booleanValue());
                data = metricsObject.toString().getBytes(StandardCharsets.UTF_8);
                attributes.put(CoreAttributes.MIME_TYPE.key(), "application/json");
            } else {
                metricsObject = this.metricsService.getMetrics(factory, status, (JvmMetrics)virtualMachineMetrics, applicationId, status.getId(), hostname, System.currentTimeMillis(), os.getAvailableProcessors(), systemLoad >= 0.0 ? systemLoad : -1.0, allowNullValues.booleanValue());
                data = this.getData(context, new ByteArrayInputStream(metricsObject.toString().getBytes(StandardCharsets.UTF_8)), attributes);
            }
            Transaction transaction = null;
            try {
                this.setup((PropertyContext)context);
                long start = System.nanoTime();
                transaction = this.getClient().createTransaction(TransferDirection.SEND);
                if (transaction == null) {
                    this.getLogger().debug("All destination nodes are penalized; will attempt to send data later");
                    return;
                }
                String transactionId = UUID.randomUUID().toString();
                attributes.put("reporting.task.transaction.id", transactionId);
                attributes.put("reporting.task.name", this.getName());
                attributes.put("reporting.task.uuid", this.getIdentifier());
                attributes.put("reporting.task.type", ((Object)((Object)this)).getClass().getSimpleName());
                transaction.send(data, attributes);
                transaction.confirm();
                transaction.complete();
                long transferMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
                this.getLogger().info("Successfully sent metrics to destination in {}ms; Transaction ID = {}", new Object[]{transferMillis, transactionId});
            }
            catch (Exception e) {
                if (transaction != null) {
                    transaction.error();
                }
                if (e instanceof ProcessException) {
                    throw (ProcessException)e;
                }
                throw new ProcessException("Failed to send metrics to destination due to:" + e.getMessage(), (Throwable)e);
            }
        } else {
            this.getLogger().error("No process group status to retrieve metrics");
        }
    }
}

