/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpInetConnection;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.conn.ManagedHttpClientConnection;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.conn.ManagedNHttpClientConnection;
import org.apache.http.nio.protocol.BasicAsyncResponseConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpCoreContext;
import org.apache.http.util.EntityUtils;
import org.apache.nifi.remote.Peer;
import org.apache.nifi.remote.TransferDirection;
import org.apache.nifi.remote.client.http.TransportProtocolVersionNegotiator;
import org.apache.nifi.remote.exception.PortNotRunningException;
import org.apache.nifi.remote.exception.ProtocolException;
import org.apache.nifi.remote.exception.UnknownPortException;
import org.apache.nifi.remote.io.http.HttpCommunicationsSession;
import org.apache.nifi.remote.io.http.HttpInput;
import org.apache.nifi.remote.io.http.HttpOutput;
import org.apache.nifi.remote.protocol.CommunicationsSession;
import org.apache.nifi.remote.protocol.ResponseCode;
import org.apache.nifi.remote.protocol.http.HttpProxy;
import org.apache.nifi.security.util.CertificateUtils;
import org.apache.nifi.stream.io.ByteArrayInputStream;
import org.apache.nifi.stream.io.ByteArrayOutputStream;
import org.apache.nifi.stream.io.StreamUtils;
import org.apache.nifi.web.api.dto.ControllerDTO;
import org.apache.nifi.web.api.dto.remote.PeerDTO;
import org.apache.nifi.web.api.entity.ControllerEntity;
import org.apache.nifi.web.api.entity.PeersEntity;
import org.apache.nifi.web.api.entity.TransactionResultEntity;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SiteToSiteRestApiClient
implements Closeable {
    private static final int RESPONSE_CODE_OK = 200;
    private static final int RESPONSE_CODE_CREATED = 201;
    private static final int RESPONSE_CODE_ACCEPTED = 202;
    private static final int RESPONSE_CODE_BAD_REQUEST = 400;
    private static final int RESPONSE_CODE_NOT_FOUND = 404;
    private static final Logger logger = LoggerFactory.getLogger(SiteToSiteRestApiClient.class);
    private String baseUrl;
    protected final SSLContext sslContext;
    protected final HttpProxy proxy;
    private RequestConfig requestConfig;
    private CredentialsProvider credentialsProvider;
    private CloseableHttpClient httpClient;
    private CloseableHttpAsyncClient httpAsyncClient;
    private boolean compress = false;
    private long requestExpirationMillis = 0L;
    private int serverTransactionTtl = 0;
    private int batchCount = 0;
    private long batchSize = 0L;
    private long batchDurationMillis = 0L;
    private TransportProtocolVersionNegotiator transportProtocolVersionNegotiator = new TransportProtocolVersionNegotiator(1);
    private String trustedPeerDn;
    private final ScheduledExecutorService ttlExtendTaskExecutor;
    private ScheduledFuture<?> ttlExtendingThread;
    private SiteToSiteRestApiClient extendingApiClient;
    private int connectTimeoutMillis;
    private int readTimeoutMillis;
    private static final Pattern HTTP_ABS_URL = Pattern.compile("^https?://.+$");
    private final int DATA_PACKET_CHANNEL_READ_BUFFER_SIZE = 16384;
    private Future<HttpResponse> postResult;
    private CountDownLatch transferDataLatch = new CountDownLatch(1);

    public SiteToSiteRestApiClient(SSLContext sslContext, HttpProxy proxy) {
        this.sslContext = sslContext;
        this.proxy = proxy;
        this.ttlExtendTaskExecutor = Executors.newScheduledThreadPool(1, new ThreadFactory(){
            private final ThreadFactory defaultFactory = Executors.defaultThreadFactory();

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = this.defaultFactory.newThread(r);
                thread.setName(Thread.currentThread().getName() + " TTLExtend");
                thread.setDaemon(true);
                return thread;
            }
        });
    }

    @Override
    public void close() throws IOException {
        this.stopExtendingTtl();
        this.closeSilently((Closeable)this.httpClient);
        this.closeSilently((Closeable)this.httpAsyncClient);
    }

    private CloseableHttpClient getHttpClient() {
        if (this.httpClient == null) {
            this.setupClient();
        }
        return this.httpClient;
    }

    private CloseableHttpAsyncClient getHttpAsyncClient() {
        if (this.httpAsyncClient == null) {
            this.setupAsyncClient();
        }
        return this.httpAsyncClient;
    }

    private RequestConfig getRequestConfig() {
        if (this.requestConfig == null) {
            this.setupRequestConfig();
        }
        return this.requestConfig;
    }

    private CredentialsProvider getCredentialsProvider() {
        if (this.credentialsProvider == null) {
            this.setupCredentialsProvider();
        }
        return this.credentialsProvider;
    }

    private void setupRequestConfig() {
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom().setConnectionRequestTimeout(this.connectTimeoutMillis).setConnectTimeout(this.connectTimeoutMillis).setSocketTimeout(this.readTimeoutMillis);
        if (this.proxy != null) {
            requestConfigBuilder.setProxy(this.proxy.getHttpHost());
        }
        this.requestConfig = requestConfigBuilder.build();
    }

    private void setupCredentialsProvider() {
        this.credentialsProvider = new BasicCredentialsProvider();
        if (this.proxy != null && !StringUtils.isEmpty((CharSequence)this.proxy.getUsername()) && !StringUtils.isEmpty((CharSequence)this.proxy.getPassword())) {
            this.credentialsProvider.setCredentials(new AuthScope(this.proxy.getHttpHost()), (Credentials)new UsernamePasswordCredentials(this.proxy.getUsername(), this.proxy.getPassword()));
        }
    }

    private void setupClient() {
        HttpClientBuilder clientBuilder = HttpClients.custom();
        if (this.sslContext != null) {
            clientBuilder.setSslcontext(this.sslContext);
            clientBuilder.addInterceptorFirst((HttpResponseInterceptor)new HttpsResponseInterceptor());
        }
        this.httpClient = clientBuilder.setDefaultCredentialsProvider(this.getCredentialsProvider()).build();
    }

    private void setupAsyncClient() {
        HttpAsyncClientBuilder clientBuilder = HttpAsyncClients.custom();
        if (this.sslContext != null) {
            clientBuilder.setSSLContext(this.sslContext);
            clientBuilder.addInterceptorFirst((HttpResponseInterceptor)new HttpsResponseInterceptor());
        }
        this.httpAsyncClient = clientBuilder.setDefaultCredentialsProvider(this.getCredentialsProvider()).build();
        this.httpAsyncClient.start();
    }

    public ControllerDTO getController() throws IOException {
        try {
            HttpGet get = this.createGet("/site-to-site");
            get.setHeader("x-nifi-site-to-site-protocol-version", String.valueOf(this.transportProtocolVersionNegotiator.getVersion()));
            return this.execute(get, ControllerEntity.class).getController();
        }
        catch (HttpGetFailedException e) {
            if (404 == e.getResponseCode()) {
                logger.debug("getController received NOT_FOUND, trying to access the old NiFi version resource url...");
                HttpGet get = this.createGet("/controller");
                return this.execute(get, ControllerEntity.class).getController();
            }
            throw e;
        }
    }

    public Collection<PeerDTO> getPeers() throws IOException {
        HttpGet get = this.createGet("/site-to-site/peers");
        get.setHeader("x-nifi-site-to-site-protocol-version", String.valueOf(this.transportProtocolVersionNegotiator.getVersion()));
        return this.execute(get, PeersEntity.class).getPeers();
    }

    public String initiateTransaction(TransferDirection direction, String portId) throws IOException {
        if (TransferDirection.RECEIVE.equals((Object)direction)) {
            return this.initiateTransaction("output-ports", portId);
        }
        return this.initiateTransaction("input-ports", portId);
    }

    private String initiateTransaction(String portType, String portId) throws IOException {
        logger.debug("initiateTransaction handshaking portType={}, portId={}", (Object)portType, (Object)portId);
        HttpPost post = this.createPost("/data-transfer/" + portType + "/" + portId + "/transactions");
        post.setHeader("Accept", "application/json");
        post.setHeader("x-nifi-site-to-site-protocol-version", String.valueOf(this.transportProtocolVersionNegotiator.getVersion()));
        this.setHandshakeProperties((HttpRequestBase)post);
        try (CloseableHttpResponse response = this.getHttpClient().execute((HttpUriRequest)post);){
            String transactionUrl;
            int responseCode = response.getStatusLine().getStatusCode();
            logger.debug("initiateTransaction responseCode={}", (Object)responseCode);
            switch (responseCode) {
                case 201: {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                    transactionUrl = this.readTransactionUrl(response);
                    if (StringUtils.isEmpty((CharSequence)transactionUrl)) {
                        throw new ProtocolException("Server returned RESPONSE_CODE_CREATED without Location header");
                    }
                    Header transportProtocolVersionHeader = response.getFirstHeader("x-nifi-site-to-site-protocol-version");
                    if (transportProtocolVersionHeader == null) {
                        throw new ProtocolException("Server didn't return confirmed protocol version");
                    }
                    Integer protocolVersionConfirmedByServer = Integer.valueOf(transportProtocolVersionHeader.getValue());
                    logger.debug("Finished version negotiation, protocolVersionConfirmedByServer={}", (Object)protocolVersionConfirmedByServer);
                    this.transportProtocolVersionNegotiator.setVersion(protocolVersionConfirmedByServer);
                    Header serverTransactionTtlHeader = response.getFirstHeader("x-nifi-site-to-site-server-transaction-ttl");
                    if (serverTransactionTtlHeader == null) {
                        throw new ProtocolException("Server didn't return x-nifi-site-to-site-server-transaction-ttl");
                    }
                    this.serverTransactionTtl = Integer.parseInt(serverTransactionTtlHeader.getValue());
                    break;
                }
                default: {
                    InputStream content = response.getEntity().getContent();
                    Throwable throwable = null;
                    try {
                        try {
                            throw this.handleErrResponse(responseCode, content);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable3) {
                        if (content != null) {
                            if (throwable != null) {
                                try {
                                    content.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                            } else {
                                content.close();
                            }
                        }
                        throw throwable3;
                    }
                }
            }
            logger.debug("initiateTransaction handshaking finished, transactionUrl={}", (Object)transactionUrl);
            String string = transactionUrl;
            return string;
        }
    }

    public boolean openConnectionForReceive(String transactionUrl, Peer peer) throws IOException {
        HttpGet get = this.createGet(transactionUrl + "/flow-files");
        ((HttpCommunicationsSession)peer.getCommunicationsSession()).setDataTransferUrl(get.getURI().toString());
        get.setHeader("x-nifi-site-to-site-protocol-version", String.valueOf(this.transportProtocolVersionNegotiator.getVersion()));
        this.setHandshakeProperties((HttpRequestBase)get);
        final CloseableHttpResponse response = this.getHttpClient().execute((HttpUriRequest)get);
        int responseCode = response.getStatusLine().getStatusCode();
        logger.debug("responseCode={}", (Object)responseCode);
        boolean keepItOpen = false;
        try {
            switch (responseCode) {
                case 200: {
                    logger.debug("Server returned RESPONSE_CODE_OK, indicating there was no data.");
                    EntityUtils.consume((HttpEntity)response.getEntity());
                    boolean bl = false;
                    return bl;
                }
                case 202: {
                    final InputStream httpIn = response.getEntity().getContent();
                    InputStream streamCapture = new InputStream(){
                        boolean closed = false;

                        @Override
                        public int read() throws IOException {
                            if (this.closed) {
                                return -1;
                            }
                            int r = httpIn.read();
                            if (r < 0) {
                                this.closed = true;
                                logger.debug("Reached to end of input stream. Closing resources...");
                                SiteToSiteRestApiClient.this.stopExtendingTtl();
                                SiteToSiteRestApiClient.this.closeSilently(httpIn);
                                SiteToSiteRestApiClient.this.closeSilently((Closeable)response);
                            }
                            return r;
                        }
                    };
                    ((HttpInput)peer.getCommunicationsSession().getInput()).setInputStream(streamCapture);
                    this.startExtendingTtl(transactionUrl, httpIn, response);
                    keepItOpen = true;
                    boolean bl = true;
                    return bl;
                }
            }
            InputStream content = response.getEntity().getContent();
            Throwable throwable = null;
            try {
                try {
                    throw this.handleErrResponse(responseCode, content);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (content != null) {
                    if (throwable != null) {
                        try {
                            content.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        content.close();
                    }
                }
                throw throwable3;
            }
        }
        finally {
            if (!keepItOpen) {
                response.close();
            }
        }
    }

    public void openConnectionForSend(String transactionUrl, Peer peer) throws IOException {
        final CommunicationsSession commSession = peer.getCommunicationsSession();
        final String flowFilesPath = transactionUrl + "/flow-files";
        final HttpPost post = this.createPost(flowFilesPath);
        ((HttpCommunicationsSession)peer.getCommunicationsSession()).setDataTransferUrl(post.getURI().toString());
        post.setHeader("Content-Type", "application/octet-stream");
        post.setHeader("Accept", "text/plain");
        post.setHeader("x-nifi-site-to-site-protocol-version", String.valueOf(this.transportProtocolVersionNegotiator.getVersion()));
        this.setHandshakeProperties((HttpRequestBase)post);
        final CountDownLatch initConnectionLatch = new CountDownLatch(1);
        final URI requestUri = post.getURI();
        final PipedOutputStream outputStream = new PipedOutputStream();
        PipedInputStream inputStream = new PipedInputStream(outputStream, 16384);
        final ReadableByteChannel dataPacketChannel = Channels.newChannel(inputStream);
        HttpAsyncRequestProducer asyncRequestProducer = new HttpAsyncRequestProducer(){
            private final ByteBuffer buffer = ByteBuffer.allocate(16384);

            public HttpHost getTarget() {
                return URIUtils.extractHost((URI)requestUri);
            }

            public HttpRequest generateRequest() throws IOException, HttpException {
                logger.debug("sending data to {} has started...", (Object)flowFilesPath);
                ((HttpOutput)commSession.getOutput()).setOutputStream(outputStream);
                initConnectionLatch.countDown();
                BasicHttpEntity entity = new BasicHttpEntity();
                entity.setChunked(true);
                entity.setContentType("application/octet-stream");
                post.setEntity((HttpEntity)entity);
                return post;
            }

            public void produceContent(ContentEncoder encoder, IOControl ioControl) throws IOException {
                int read;
                int totalRead = 0;
                int totalProduced = 0;
                while ((read = dataPacketChannel.read(this.buffer)) > -1) {
                    this.buffer.flip();
                    while (this.buffer.hasRemaining()) {
                        totalProduced += encoder.write(this.buffer);
                    }
                    this.buffer.clear();
                    logger.trace("Read {} bytes from dataPacketChannel. {}", (Object)read, (Object)flowFilesPath);
                    totalRead += read;
                }
                this.buffer.flip();
                while (this.buffer.hasRemaining()) {
                    totalProduced += encoder.write(this.buffer);
                }
                long totalWritten = commSession.getOutput().getBytesWritten();
                logger.debug("sending data to {} has reached to its end. produced {} bytes by reading {} bytes from channel. {} bytes written in this transaction.", new Object[]{flowFilesPath, totalProduced, totalRead, totalWritten});
                if ((long)totalRead != totalWritten || (long)totalProduced != totalWritten) {
                    String msg = "Sending data to %s has reached to its end, but produced : read : wrote byte sizes (%d : $d : %d) were not equal. Something went wrong.";
                    throw new RuntimeException(String.format("Sending data to %s has reached to its end, but produced : read : wrote byte sizes (%d : $d : %d) were not equal. Something went wrong.", flowFilesPath, totalProduced, totalRead, totalWritten));
                }
                SiteToSiteRestApiClient.this.transferDataLatch.countDown();
                encoder.complete();
                dataPacketChannel.close();
            }

            public void requestCompleted(HttpContext context) {
                logger.debug("Sending data to {} completed.", (Object)flowFilesPath);
            }

            public void failed(Exception ex) {
                logger.error("Sending data to {} has failed", (Object)flowFilesPath, (Object)ex);
            }

            public boolean isRepeatable() {
                return true;
            }

            public void resetRequest() throws IOException {
                logger.debug("Sending data request to {} has been reset...", (Object)flowFilesPath);
            }

            public void close() throws IOException {
                logger.debug("Closing sending data request to {}", (Object)flowFilesPath);
                SiteToSiteRestApiClient.this.closeSilently(outputStream);
                SiteToSiteRestApiClient.this.closeSilently(dataPacketChannel);
                SiteToSiteRestApiClient.this.stopExtendingTtl();
            }
        };
        this.postResult = this.getHttpAsyncClient().execute(asyncRequestProducer, (HttpAsyncResponseConsumer)new BasicAsyncResponseConsumer(), null);
        try {
            if (!initConnectionLatch.await(this.connectTimeoutMillis, TimeUnit.MILLISECONDS)) {
                throw new IOException("Awaiting initConnectionLatch has been timeout.");
            }
            this.transferDataLatch = new CountDownLatch(1);
            this.startExtendingTtl(transactionUrl, dataPacketChannel, null);
        }
        catch (InterruptedException e) {
            throw new IOException("Awaiting initConnectionLatch has been interrupted.", e);
        }
    }

    public void finishTransferFlowFiles(CommunicationsSession commSession) throws IOException {
        HttpResponse response;
        if (this.postResult == null) {
            new IllegalStateException("Data transfer has not started yet.");
        }
        commSession.getOutput().getOutputStream().close();
        logger.debug("{} FinishTransferFlowFiles no more data can be sent", (Object)this);
        try {
            if (!this.transferDataLatch.await(this.requestExpirationMillis, TimeUnit.MILLISECONDS)) {
                throw new IOException("Awaiting transferDataLatch has been timeout.");
            }
        }
        catch (InterruptedException e) {
            throw new IOException("Awaiting transferDataLatch has been interrupted.", e);
        }
        this.stopExtendingTtl();
        try {
            response = this.postResult.get(this.readTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            logger.debug("Something has happened at sending thread. {}", (Object)e.getMessage());
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new IOException(cause);
        }
        catch (InterruptedException | TimeoutException e) {
            throw new IOException(e);
        }
        int responseCode = response.getStatusLine().getStatusCode();
        switch (responseCode) {
            case 202: {
                String receivedChecksum = EntityUtils.toString((HttpEntity)response.getEntity());
                ((HttpInput)commSession.getInput()).setInputStream((InputStream)new ByteArrayInputStream(receivedChecksum.getBytes()));
                ((HttpCommunicationsSession)commSession).setChecksum(receivedChecksum);
                logger.debug("receivedChecksum={}", (Object)receivedChecksum);
                break;
            }
            default: {
                InputStream content = response.getEntity().getContent();
                Throwable throwable = null;
                try {
                    try {
                        throw this.handleErrResponse(responseCode, content);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (Throwable throwable3) {
                    if (content != null) {
                        if (throwable != null) {
                            try {
                                content.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            content.close();
                        }
                    }
                    throw throwable3;
                }
            }
        }
    }

    private void startExtendingTtl(String transactionUrl, Closeable stream, CloseableHttpResponse response) {
        if (this.ttlExtendingThread != null) {
            return;
        }
        logger.debug("Starting extending TTL thread...");
        this.extendingApiClient = new SiteToSiteRestApiClient(this.sslContext, this.proxy);
        this.extendingApiClient.transportProtocolVersionNegotiator = this.transportProtocolVersionNegotiator;
        this.extendingApiClient.connectTimeoutMillis = this.connectTimeoutMillis;
        this.extendingApiClient.readTimeoutMillis = this.readTimeoutMillis;
        int extendFrequency = this.serverTransactionTtl / 2;
        this.ttlExtendingThread = this.ttlExtendTaskExecutor.scheduleWithFixedDelay(() -> {
            try {
                this.extendingApiClient.extendTransaction(transactionUrl);
            }
            catch (Exception e) {
                logger.warn("Failed to extend transaction ttl", (Throwable)e);
                try {
                    this.close();
                }
                catch (IOException ec) {
                    logger.warn("Failed to close", (Throwable)e);
                }
            }
        }, extendFrequency, extendFrequency, TimeUnit.SECONDS);
    }

    private void closeSilently(Closeable closeable) {
        block3: {
            try {
                if (closeable != null) {
                    closeable.close();
                }
            }
            catch (IOException e) {
                logger.warn("Got an exception during closing {}: {}", (Object)closeable, (Object)e.getMessage());
                if (!logger.isDebugEnabled()) break block3;
                logger.warn("", (Throwable)e);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public TransactionResultEntity extendTransaction(String transactionUrl) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 11[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void stopExtendingTtl() {
        if (!this.ttlExtendTaskExecutor.isShutdown()) {
            this.ttlExtendTaskExecutor.shutdown();
        }
        if (this.ttlExtendingThread != null && !this.ttlExtendingThread.isCancelled()) {
            logger.debug("Cancelling extending ttl...");
            this.ttlExtendingThread.cancel(true);
        }
        this.closeSilently(this.extendingApiClient);
    }

    private IOException handleErrResponse(int responseCode, InputStream in) throws IOException {
        if (in == null) {
            return new IOException("Unexpected response code: " + responseCode);
        }
        TransactionResultEntity errEntity = this.readResponse(in);
        ResponseCode errCode = ResponseCode.fromCode(errEntity.getResponseCode());
        switch (errCode) {
            case UNKNOWN_PORT: {
                return new UnknownPortException(errEntity.getMessage());
            }
            case PORT_NOT_IN_VALID_STATE: {
                return new PortNotRunningException(errEntity.getMessage());
            }
        }
        return new IOException("Unexpected response code: " + responseCode + " errCode:" + (Object)((Object)errCode) + " errMessage:" + errEntity.getMessage());
    }

    private TransactionResultEntity readResponse(InputStream inputStream) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        StreamUtils.copy((InputStream)inputStream, (OutputStream)bos);
        String responseMessage = null;
        try {
            responseMessage = new String(bos.toByteArray(), "UTF-8");
            logger.debug("readResponse responseMessage={}", (Object)responseMessage);
            ObjectMapper mapper = new ObjectMapper();
            return (TransactionResultEntity)mapper.readValue(responseMessage, TransactionResultEntity.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Failed to parse JSON.", e);
            }
            TransactionResultEntity entity = new TransactionResultEntity();
            entity.setResponseCode(ResponseCode.ABORT.getCode());
            entity.setMessage(responseMessage);
            return entity;
        }
    }

    private String readTransactionUrl(CloseableHttpResponse response) {
        Header locationUriIntentHeader = response.getFirstHeader("x-location-uri-intent");
        logger.debug("locationUriIntentHeader={}", (Object)locationUriIntentHeader);
        if (locationUriIntentHeader != null && "transaction-url".equals(locationUriIntentHeader.getValue())) {
            Header transactionUrl = response.getFirstHeader("Location");
            logger.debug("transactionUrl={}", (Object)transactionUrl);
            if (transactionUrl != null) {
                return transactionUrl.getValue();
            }
        }
        return null;
    }

    private void setHandshakeProperties(HttpRequestBase httpRequest) {
        if (this.compress) {
            httpRequest.setHeader("x-nifi-site-to-site-use-compression", "true");
        }
        if (this.requestExpirationMillis > 0L) {
            httpRequest.setHeader("x-nifi-site-to-site-request-expiration", String.valueOf(this.requestExpirationMillis));
        }
        if (this.batchCount > 0) {
            httpRequest.setHeader("x-nifi-site-to-site-batch-count", String.valueOf(this.batchCount));
        }
        if (this.batchSize > 0L) {
            httpRequest.setHeader("x-nifi-site-to-site-batch-size", String.valueOf(this.batchSize));
        }
        if (this.batchDurationMillis > 0L) {
            httpRequest.setHeader("x-nifi-site-to-site-batch-duration", String.valueOf(this.batchDurationMillis));
        }
    }

    private URI getUri(String path) {
        URI url;
        try {
            if (HTTP_ABS_URL.matcher(path).find()) {
                url = new URI(path);
            } else {
                if (StringUtils.isEmpty((CharSequence)this.getBaseUrl())) {
                    throw new IllegalStateException("API baseUrl is not resolved yet, call setBaseUrl or resolveBaseUrl before sending requests with relative path.");
                }
                url = new URI(this.baseUrl + path);
            }
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        return url;
    }

    private HttpGet createGet(String path) {
        URI url = this.getUri(path);
        HttpGet get = new HttpGet(url);
        get.setConfig(this.getRequestConfig());
        return get;
    }

    private HttpPost createPost(String path) {
        URI url = this.getUri(path);
        HttpPost post = new HttpPost(url);
        post.setConfig(this.getRequestConfig());
        return post;
    }

    private HttpPut createPut(String path) {
        URI url = this.getUri(path);
        HttpPut put = new HttpPut(url);
        put.setConfig(this.getRequestConfig());
        return put;
    }

    private HttpDelete createDelete(String path) {
        URI url = this.getUri(path);
        HttpDelete delete = new HttpDelete(url);
        delete.setConfig(this.getRequestConfig());
        return delete;
    }

    private String execute(HttpGet get) throws IOException {
        CloseableHttpClient httpClient = this.getHttpClient();
        if (logger.isTraceEnabled()) {
            Arrays.stream(get.getAllHeaders()).forEach(h -> logger.debug("REQ| {}", h));
        }
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)get);){
            String responseMessage;
            StatusLine statusLine;
            int statusCode;
            if (logger.isTraceEnabled()) {
                Arrays.stream(response.getAllHeaders()).forEach(h -> logger.debug("RES| {}", h));
            }
            if (200 != (statusCode = (statusLine = response.getStatusLine()).getStatusCode())) {
                throw new HttpGetFailedException(statusCode, statusLine.getReasonPhrase(), null);
            }
            HttpEntity entity = response.getEntity();
            String string = responseMessage = EntityUtils.toString((HttpEntity)entity);
            return string;
        }
    }

    private <T> T execute(HttpGet get, Class<T> entityClass) throws IOException {
        get.setHeader("Accept", "application/json");
        String responseMessage = this.execute(get);
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            return (T)mapper.readValue(responseMessage, entityClass);
        }
        catch (JsonParseException e) {
            logger.warn("Failed to parse Json, response={}", (Object)responseMessage);
            throw e;
        }
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void setConnectTimeoutMillis(int connectTimeoutMillis) {
        this.connectTimeoutMillis = connectTimeoutMillis;
    }

    public void setReadTimeoutMillis(int readTimeoutMillis) {
        this.readTimeoutMillis = readTimeoutMillis;
    }

    public String resolveBaseUrl(String clusterUrl) {
        URI clusterUri;
        try {
            clusterUri = new URI(clusterUrl);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Specified clusterUrl was: " + clusterUrl, e);
        }
        return this.resolveBaseUrl(clusterUri);
    }

    public String resolveBaseUrl(URI clusterUrl) {
        String urlPath = clusterUrl.getPath();
        if (urlPath.endsWith("/")) {
            urlPath = urlPath.substring(0, urlPath.length() - 1);
        }
        return this.resolveBaseUrl(clusterUrl.getScheme(), clusterUrl.getHost(), clusterUrl.getPort(), urlPath + "-api");
    }

    public String resolveBaseUrl(String scheme, String host, int port) {
        return this.resolveBaseUrl(scheme, host, port, "/nifi-api");
    }

    private String resolveBaseUrl(String scheme, String host, int port, String path) {
        String baseUri;
        try {
            baseUri = new URL(scheme, host, port, path).toURI().toString();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        this.setBaseUrl(baseUri);
        return baseUri;
    }

    public void setCompress(boolean compress) {
        this.compress = compress;
    }

    public void setRequestExpirationMillis(long requestExpirationMillis) {
        if (requestExpirationMillis < 0L) {
            throw new IllegalArgumentException("requestExpirationMillis can't be a negative value.");
        }
        this.requestExpirationMillis = requestExpirationMillis;
    }

    public void setBatchCount(int batchCount) {
        if (batchCount < 0) {
            throw new IllegalArgumentException("batchCount can't be a negative value.");
        }
        this.batchCount = batchCount;
    }

    public void setBatchSize(long batchSize) {
        if (batchSize < 0L) {
            throw new IllegalArgumentException("batchSize can't be a negative value.");
        }
        this.batchSize = batchSize;
    }

    public void setBatchDurationMillis(long batchDurationMillis) {
        if (batchDurationMillis < 0L) {
            throw new IllegalArgumentException("batchDurationMillis can't be a negative value.");
        }
        this.batchDurationMillis = batchDurationMillis;
    }

    public Integer getTransactionProtocolVersion() {
        return this.transportProtocolVersionNegotiator.getTransactionProtocolVersion();
    }

    public String getTrustedPeerDn() {
        return this.trustedPeerDn;
    }

    /*
     * Exception decompiling
     */
    public TransactionResultEntity commitReceivingFlowFiles(String transactionUrl, ResponseCode clientResponse, String checksum) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 15[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public TransactionResultEntity commitTransferFlowFiles(String transactionUrl, ResponseCode clientResponse) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 15[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public class HttpGetFailedException
    extends IOException {
        private static final long serialVersionUID = 7920714957269466946L;
        private final int responseCode;
        private final String responseMessage;
        private final String explanation;

        public HttpGetFailedException(int responseCode, String responseMessage, String explanation) {
            super("response code " + responseCode + ":" + responseMessage + " with explanation: " + explanation);
            this.responseCode = responseCode;
            this.responseMessage = responseMessage;
            this.explanation = explanation;
        }

        public int getResponseCode() {
            return this.responseCode;
        }

        public String getDescription() {
            return !StringUtils.isEmpty((CharSequence)this.explanation) ? this.explanation : this.responseMessage;
        }
    }

    private class HttpsResponseInterceptor
    implements HttpResponseInterceptor {
        private HttpsResponseInterceptor() {
        }

        public void process(HttpResponse response, HttpContext httpContext) throws HttpException, IOException {
            SSLSession sslSession;
            HttpCoreContext coreContext = HttpCoreContext.adapt((HttpContext)httpContext);
            HttpInetConnection conn = (HttpInetConnection)coreContext.getConnection(HttpInetConnection.class);
            if (!conn.isOpen()) {
                return;
            }
            if (conn instanceof ManagedHttpClientConnection) {
                sslSession = ((ManagedHttpClientConnection)conn).getSSLSession();
            } else if (conn instanceof ManagedNHttpClientConnection) {
                sslSession = ((ManagedNHttpClientConnection)conn).getSSLSession();
            } else {
                throw new RuntimeException("Unexpected connection type was used, " + conn);
            }
            if (sslSession != null) {
                Certificate[] certChain = sslSession.getPeerCertificates();
                if (certChain == null || certChain.length == 0) {
                    throw new SSLPeerUnverifiedException("No certificates found");
                }
                try {
                    X509Certificate cert = CertificateUtils.convertAbstractX509Certificate((Certificate)certChain[0]);
                    SiteToSiteRestApiClient.this.trustedPeerDn = cert.getSubjectDN().getName().trim();
                }
                catch (CertificateException e) {
                    String msg = "Could not extract subject DN from SSL session peer certificate";
                    logger.warn("Could not extract subject DN from SSL session peer certificate");
                    throw new SSLPeerUnverifiedException("Could not extract subject DN from SSL session peer certificate");
                }
            }
        }
    }
}

