/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote.client;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.nifi.events.EventReporter;
import org.apache.nifi.remote.Transaction;
import org.apache.nifi.remote.TransferDirection;
import org.apache.nifi.remote.client.KeystoreType;
import org.apache.nifi.remote.client.SiteToSiteClientConfig;
import org.apache.nifi.remote.client.http.HttpClient;
import org.apache.nifi.remote.client.socket.SocketClient;
import org.apache.nifi.remote.exception.HandshakeException;
import org.apache.nifi.remote.exception.PortNotRunningException;
import org.apache.nifi.remote.exception.ProtocolException;
import org.apache.nifi.remote.exception.UnknownPortException;
import org.apache.nifi.remote.protocol.SiteToSiteTransportProtocol;
import org.apache.nifi.remote.protocol.http.HttpProxy;

public interface SiteToSiteClient
extends Closeable {
    public Transaction createTransaction(TransferDirection var1) throws HandshakeException, PortNotRunningException, ProtocolException, UnknownPortException, IOException;

    public boolean isSecure() throws IOException;

    public SiteToSiteClientConfig getConfig();

    public static class StandardSiteToSiteClientConfig
    implements SiteToSiteClientConfig,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final String url;
        private final long timeoutNanos;
        private final long penalizationNanos;
        private final long idleExpirationNanos;
        private final SSLContext sslContext;
        private final String keystoreFilename;
        private final String keystorePass;
        private final KeystoreType keystoreType;
        private final String truststoreFilename;
        private final String truststorePass;
        private final KeystoreType truststoreType;
        private final EventReporter eventReporter;
        private final File peerPersistenceFile;
        private final boolean useCompression;
        private final SiteToSiteTransportProtocol transportProtocol;
        private final String portName;
        private final String portIdentifier;
        private final int batchCount;
        private final long batchSize;
        private final long batchNanos;
        private final HttpProxy httpProxy;

        private StandardSiteToSiteClientConfig() {
            this.url = null;
            this.timeoutNanos = 0L;
            this.penalizationNanos = 0L;
            this.idleExpirationNanos = 0L;
            this.sslContext = null;
            this.keystoreFilename = null;
            this.keystorePass = null;
            this.keystoreType = null;
            this.truststoreFilename = null;
            this.truststorePass = null;
            this.truststoreType = null;
            this.eventReporter = null;
            this.peerPersistenceFile = null;
            this.useCompression = false;
            this.portName = null;
            this.portIdentifier = null;
            this.batchCount = 0;
            this.batchSize = 0L;
            this.batchNanos = 0L;
            this.transportProtocol = null;
            this.httpProxy = null;
        }

        private StandardSiteToSiteClientConfig(Builder builder) {
            this.url = builder.url;
            this.timeoutNanos = builder.timeoutNanos;
            this.penalizationNanos = builder.penalizationNanos;
            this.idleExpirationNanos = builder.idleExpirationNanos;
            this.sslContext = builder.sslContext;
            this.keystoreFilename = builder.keystoreFilename;
            this.keystorePass = builder.keystorePass;
            this.keystoreType = builder.keystoreType;
            this.truststoreFilename = builder.truststoreFilename;
            this.truststorePass = builder.truststorePass;
            this.truststoreType = builder.truststoreType;
            this.eventReporter = builder.eventReporter;
            this.peerPersistenceFile = builder.peerPersistenceFile;
            this.useCompression = builder.useCompression;
            this.portName = builder.portName;
            this.portIdentifier = builder.portIdentifier;
            this.batchCount = builder.batchCount;
            this.batchSize = builder.batchSize;
            this.batchNanos = builder.batchNanos;
            this.transportProtocol = builder.getTransportProtocol();
            this.httpProxy = builder.getHttpProxy();
        }

        @Override
        public boolean isUseCompression() {
            return this.useCompression;
        }

        @Override
        public String getUrl() {
            return this.url;
        }

        @Override
        public long getTimeout(TimeUnit timeUnit) {
            return timeUnit.convert(this.timeoutNanos, TimeUnit.NANOSECONDS);
        }

        @Override
        public long getIdleConnectionExpiration(TimeUnit timeUnit) {
            return timeUnit.convert(this.idleExpirationNanos, TimeUnit.NANOSECONDS);
        }

        @Override
        public SSLContext getSslContext() {
            TrustManagerFactory trustManagerFactory;
            KeyManagerFactory keyManagerFactory;
            if (this.sslContext != null) {
                return this.sslContext;
            }
            if (this.keystoreFilename != null && this.keystorePass != null && this.keystoreType != null) {
                try {
                    KeyStore keyStore = KeyStore.getInstance(this.getKeystoreType().name());
                    try (FileInputStream keyStoreStream = new FileInputStream(new File(this.getKeystoreFilename()));){
                        keyStore.load(keyStoreStream, this.keystorePass.toCharArray());
                    }
                    keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                    keyManagerFactory.init(keyStore, this.keystorePass.toCharArray());
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to load Keystore", e);
                }
            }
            keyManagerFactory = null;
            if (this.truststoreFilename != null && this.truststorePass != null && this.truststoreType != null) {
                try {
                    KeyStore trustStore = KeyStore.getInstance(this.getTruststoreType().name());
                    try (FileInputStream trustStoreStream = new FileInputStream(new File(this.getTruststoreFilename()));){
                        trustStore.load(trustStoreStream, this.truststorePass.toCharArray());
                    }
                    trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    trustManagerFactory.init(trustStore);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to load Truststore", e);
                }
            }
            trustManagerFactory = null;
            if (keyManagerFactory != null && trustManagerFactory != null) {
                try {
                    SSLContext sslContext = SSLContext.getInstance("TLS");
                    sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), new SecureRandom());
                    sslContext.getDefaultSSLParameters().setNeedClientAuth(true);
                    return sslContext;
                }
                catch (Exception e) {
                    throw new IllegalStateException("Created keystore and truststore but failed to initialize SSLContext", e);
                }
            }
            return null;
        }

        @Override
        public String getPortName() {
            return this.portName;
        }

        @Override
        public String getPortIdentifier() {
            return this.portIdentifier;
        }

        @Override
        public long getPenalizationPeriod(TimeUnit timeUnit) {
            return timeUnit.convert(this.penalizationNanos, TimeUnit.NANOSECONDS);
        }

        @Override
        public File getPeerPersistenceFile() {
            return this.peerPersistenceFile;
        }

        @Override
        public EventReporter getEventReporter() {
            return this.eventReporter;
        }

        @Override
        public long getPreferredBatchDuration(TimeUnit timeUnit) {
            return timeUnit.convert(this.batchNanos, TimeUnit.NANOSECONDS);
        }

        @Override
        public long getPreferredBatchSize() {
            return this.batchSize;
        }

        @Override
        public int getPreferredBatchCount() {
            return this.batchCount;
        }

        @Override
        public String getKeystoreFilename() {
            return this.keystoreFilename;
        }

        @Override
        public String getKeystorePassword() {
            return this.keystorePass;
        }

        @Override
        public KeystoreType getKeystoreType() {
            return this.keystoreType;
        }

        @Override
        public String getTruststoreFilename() {
            return this.truststoreFilename;
        }

        @Override
        public String getTruststorePassword() {
            return this.truststorePass;
        }

        @Override
        public KeystoreType getTruststoreType() {
            return this.truststoreType;
        }

        @Override
        public SiteToSiteTransportProtocol getTransportProtocol() {
            return this.transportProtocol;
        }

        @Override
        public HttpProxy getHttpProxy() {
            return this.httpProxy;
        }
    }

    public static class Builder
    implements Serializable {
        private static final long serialVersionUID = -4954962284343090219L;
        private String url;
        private long timeoutNanos = TimeUnit.SECONDS.toNanos(30L);
        private long penalizationNanos = TimeUnit.SECONDS.toNanos(3L);
        private long idleExpirationNanos = TimeUnit.SECONDS.toNanos(30L);
        private SSLContext sslContext;
        private String keystoreFilename;
        private String keystorePass;
        private KeystoreType keystoreType;
        private String truststoreFilename;
        private String truststorePass;
        private KeystoreType truststoreType;
        private EventReporter eventReporter;
        private File peerPersistenceFile;
        private boolean useCompression;
        private String portName;
        private String portIdentifier;
        private int batchCount;
        private long batchSize;
        private long batchNanos;
        private SiteToSiteTransportProtocol transportProtocol = SiteToSiteTransportProtocol.RAW;
        private HttpProxy httpProxy;

        public Builder fromConfig(SiteToSiteClientConfig config) {
            this.url = config.getUrl();
            this.timeoutNanos = config.getTimeout(TimeUnit.NANOSECONDS);
            this.penalizationNanos = config.getPenalizationPeriod(TimeUnit.NANOSECONDS);
            this.idleExpirationNanos = config.getIdleConnectionExpiration(TimeUnit.NANOSECONDS);
            this.sslContext = config.getSslContext();
            this.keystoreFilename = config.getKeystoreFilename();
            this.keystorePass = config.getKeystorePassword();
            this.keystoreType = config.getKeystoreType();
            this.truststoreFilename = config.getTruststoreFilename();
            this.truststorePass = config.getTruststorePassword();
            this.truststoreType = config.getTruststoreType();
            this.eventReporter = config.getEventReporter();
            this.peerPersistenceFile = config.getPeerPersistenceFile();
            this.useCompression = config.isUseCompression();
            this.transportProtocol = config.getTransportProtocol();
            this.portName = config.getPortName();
            this.portIdentifier = config.getPortIdentifier();
            this.batchCount = config.getPreferredBatchCount();
            this.batchSize = config.getPreferredBatchSize();
            this.batchNanos = config.getPreferredBatchDuration(TimeUnit.NANOSECONDS);
            this.httpProxy = config.getHttpProxy();
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder timeout(long timeout, TimeUnit unit) {
            this.timeoutNanos = unit.toNanos(timeout);
            return this;
        }

        public Builder idleExpiration(long timeout, TimeUnit unit) {
            this.idleExpirationNanos = unit.toNanos(timeout);
            return this;
        }

        public Builder nodePenalizationPeriod(long period, TimeUnit unit) {
            this.penalizationNanos = unit.toNanos(period);
            return this;
        }

        public Builder sslContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public String getKeystoreFilename() {
            return this.keystoreFilename;
        }

        public Builder keystoreFilename(String keystoreFilename) {
            this.keystoreFilename = keystoreFilename;
            return this;
        }

        public String getKeystorePass() {
            return this.keystorePass;
        }

        public Builder keystorePass(String keystorePass) {
            this.keystorePass = keystorePass;
            return this;
        }

        public KeystoreType getKeystoreType() {
            return this.keystoreType;
        }

        public Builder keystoreType(KeystoreType keystoreType) {
            this.keystoreType = keystoreType;
            return this;
        }

        public String getTruststoreFilename() {
            return this.truststoreFilename;
        }

        public Builder truststoreFilename(String truststoreFilename) {
            this.truststoreFilename = truststoreFilename;
            return this;
        }

        public String getTruststorePass() {
            return this.truststorePass;
        }

        public Builder truststorePass(String truststorePass) {
            this.truststorePass = truststorePass;
            return this;
        }

        public KeystoreType getTruststoreType() {
            return this.truststoreType;
        }

        public Builder truststoreType(KeystoreType truststoreType) {
            this.truststoreType = truststoreType;
            return this;
        }

        public Builder eventReporter(EventReporter eventReporter) {
            this.eventReporter = eventReporter;
            return this;
        }

        public Builder peerPersistenceFile(File peerPersistenceFile) {
            this.peerPersistenceFile = peerPersistenceFile;
            return this;
        }

        public Builder useCompression(boolean compress) {
            this.useCompression = compress;
            return this;
        }

        public Builder transportProtocol(SiteToSiteTransportProtocol transportProtocol) {
            this.transportProtocol = transportProtocol;
            return this;
        }

        public Builder portName(String portName) {
            this.portName = portName;
            return this;
        }

        public Builder portIdentifier(String portIdentifier) {
            this.portIdentifier = portIdentifier;
            return this;
        }

        public Builder requestBatchCount(int count) {
            this.batchCount = count;
            return this;
        }

        public Builder requestBatchSize(long bytes) {
            this.batchSize = bytes;
            return this;
        }

        public Builder requestBatchDuration(long value, TimeUnit unit) {
            this.batchNanos = unit.toNanos(value);
            return this;
        }

        public SiteToSiteClientConfig buildConfig() {
            return new StandardSiteToSiteClientConfig(this);
        }

        public SiteToSiteClient build() {
            if (this.url == null) {
                throw new IllegalStateException("Must specify URL to build Site-to-Site client");
            }
            if (this.portName == null && this.portIdentifier == null) {
                throw new IllegalStateException("Must specify either Port Name or Port Identifier to build Site-to-Site client");
            }
            switch (this.transportProtocol) {
                case RAW: {
                    return new SocketClient(this.buildConfig());
                }
                case HTTP: {
                    return new HttpClient(this.buildConfig());
                }
            }
            throw new IllegalStateException("Transport protocol '" + (Object)((Object)this.transportProtocol) + "' is not supported.");
        }

        public String getUrl() {
            return this.url;
        }

        public long getTimeout(TimeUnit timeUnit) {
            return timeUnit.convert(this.timeoutNanos, TimeUnit.NANOSECONDS);
        }

        public long getIdleConnectionExpiration(TimeUnit timeUnit) {
            return timeUnit.convert(this.idleExpirationNanos, TimeUnit.NANOSECONDS);
        }

        public long getPenalizationPeriod(TimeUnit timeUnit) {
            return timeUnit.convert(this.penalizationNanos, TimeUnit.NANOSECONDS);
        }

        public SSLContext getSslContext() {
            return this.sslContext;
        }

        public EventReporter getEventReporter() {
            return this.eventReporter;
        }

        public File getPeerPersistenceFile() {
            return this.peerPersistenceFile;
        }

        public boolean isUseCompression() {
            return this.useCompression;
        }

        public SiteToSiteTransportProtocol getTransportProtocol() {
            return this.transportProtocol;
        }

        public String getPortName() {
            return this.portName;
        }

        public String getPortIdentifier() {
            return this.portIdentifier;
        }

        public Builder httpProxy(HttpProxy httpProxy) {
            this.httpProxy = httpProxy;
            return this;
        }

        public HttpProxy getHttpProxy() {
            return this.httpProxy;
        }
    }
}

