/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote.client;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.net.ssl.SSLContext;
import org.apache.nifi.remote.TransferDirection;
import org.apache.nifi.remote.protocol.http.HttpProxy;
import org.apache.nifi.remote.util.SiteToSiteRestApiClient;
import org.apache.nifi.web.api.dto.ControllerDTO;
import org.apache.nifi.web.api.dto.PortDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SiteInfoProvider {
    private static final Logger logger = LoggerFactory.getLogger(SiteInfoProvider.class);
    private static final long REMOTE_REFRESH_MILLIS = TimeUnit.MILLISECONDS.convert(10L, TimeUnit.MINUTES);
    private final ReadWriteLock listeningPortRWLock = new ReentrantReadWriteLock();
    private final Lock remoteInfoReadLock = this.listeningPortRWLock.readLock();
    private final Lock remoteInfoWriteLock = this.listeningPortRWLock.writeLock();
    private Integer siteToSitePort;
    private Integer siteToSiteHttpPort;
    private Boolean siteToSiteSecure;
    private long remoteRefreshTime;
    private HttpProxy proxy;
    private final Map<String, String> inputPortMap = new HashMap<String, String>();
    private final Map<String, String> outputPortMap = new HashMap<String, String>();
    private URI clusterUrl;
    private SSLContext sslContext;
    private int connectTimeoutMillis;
    private int readTimeoutMillis;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ControllerDTO refreshRemoteInfo() throws IOException {
        ControllerDTO controller;
        try (SiteToSiteRestApiClient apiClient = new SiteToSiteRestApiClient(this.sslContext, this.proxy);){
            apiClient.resolveBaseUrl(this.clusterUrl);
            apiClient.setConnectTimeoutMillis(this.connectTimeoutMillis);
            apiClient.setReadTimeoutMillis(this.readTimeoutMillis);
            controller = apiClient.getController();
        }
        this.remoteInfoWriteLock.lock();
        try {
            this.siteToSitePort = controller.getRemoteSiteListeningPort();
            this.siteToSiteHttpPort = controller.getRemoteSiteHttpListeningPort();
            this.siteToSiteSecure = controller.isSiteToSiteSecure();
            this.inputPortMap.clear();
            for (PortDTO inputPort : controller.getInputPorts()) {
                this.inputPortMap.put(inputPort.getName(), inputPort.getId());
            }
            this.outputPortMap.clear();
            for (PortDTO outputPort : controller.getOutputPorts()) {
                this.outputPortMap.put(outputPort.getName(), outputPort.getId());
            }
            this.remoteRefreshTime = System.currentTimeMillis();
        }
        finally {
            this.remoteInfoWriteLock.unlock();
        }
        return controller;
    }

    public boolean isWebInterfaceSecure() {
        return this.clusterUrl.toString().startsWith("https");
    }

    public Integer getSiteToSitePort() throws IOException {
        Integer listeningPort;
        this.remoteInfoReadLock.lock();
        try {
            listeningPort = this.siteToSitePort;
            if (listeningPort != null && this.remoteRefreshTime > System.currentTimeMillis() - REMOTE_REFRESH_MILLIS) {
                Integer n = listeningPort;
                return n;
            }
        }
        finally {
            this.remoteInfoReadLock.unlock();
        }
        ControllerDTO controller = this.refreshRemoteInfo();
        listeningPort = controller.getRemoteSiteListeningPort();
        return listeningPort;
    }

    public Integer getSiteToSiteHttpPort() throws IOException {
        Integer listeningHttpPort;
        this.remoteInfoReadLock.lock();
        try {
            listeningHttpPort = this.siteToSiteHttpPort;
            if (listeningHttpPort != null && this.remoteRefreshTime > System.currentTimeMillis() - REMOTE_REFRESH_MILLIS) {
                Integer n = listeningHttpPort;
                return n;
            }
        }
        finally {
            this.remoteInfoReadLock.unlock();
        }
        ControllerDTO controller = this.refreshRemoteInfo();
        listeningHttpPort = controller.getRemoteSiteHttpListeningPort();
        return listeningHttpPort;
    }

    public boolean isSecure() throws IOException {
        this.remoteInfoReadLock.lock();
        try {
            Boolean secure = this.siteToSiteSecure;
            if (secure != null && this.remoteRefreshTime > System.currentTimeMillis() - REMOTE_REFRESH_MILLIS) {
                boolean bl = secure;
                return bl;
            }
        }
        finally {
            this.remoteInfoReadLock.unlock();
        }
        ControllerDTO controller = this.refreshRemoteInfo();
        Boolean isSecure = controller.isSiteToSiteSecure();
        if (isSecure == null) {
            throw new IOException("Remote NiFi instance " + this.clusterUrl + " is not currently configured to accept site-to-site connections");
        }
        return isSecure;
    }

    public String getPortIdentifier(String portName, TransferDirection transferDirection) throws IOException {
        if (transferDirection == TransferDirection.RECEIVE) {
            return this.getOutputPortIdentifier(portName);
        }
        return this.getInputPortIdentifier(portName);
    }

    public String getInputPortIdentifier(String portName) throws IOException {
        return this.getPortIdentifier(portName, this.inputPortMap);
    }

    public String getOutputPortIdentifier(String portName) throws IOException {
        return this.getPortIdentifier(portName, this.outputPortMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPortIdentifier(String portName, Map<String, String> portMap) throws IOException {
        String identifier;
        this.remoteInfoReadLock.lock();
        try {
            identifier = portMap.get(portName);
        }
        finally {
            this.remoteInfoReadLock.unlock();
        }
        if (identifier != null) {
            return identifier;
        }
        this.refreshRemoteInfo();
        this.remoteInfoReadLock.lock();
        try {
            String string = portMap.get(portName);
            return string;
        }
        finally {
            this.remoteInfoReadLock.unlock();
        }
    }

    public void setClusterUrl(URI clusterUrl) {
        this.clusterUrl = clusterUrl;
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public void setConnectTimeoutMillis(int connectTimeoutMillis) {
        this.connectTimeoutMillis = connectTimeoutMillis;
    }

    public void setReadTimeoutMillis(int readTimeoutMillis) {
        this.readTimeoutMillis = readTimeoutMillis;
    }

    public void setProxy(HttpProxy proxy) {
        this.proxy = proxy;
    }
}

