/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote.client;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.remote.client.SiteInfoProvider;
import org.apache.nifi.remote.client.SiteToSiteClient;
import org.apache.nifi.remote.client.SiteToSiteClientConfig;

public abstract class AbstractSiteToSiteClient
implements SiteToSiteClient {
    protected final SiteToSiteClientConfig config;
    protected final SiteInfoProvider siteInfoProvider;
    protected final URI clusterUrl;

    public AbstractSiteToSiteClient(SiteToSiteClientConfig config) {
        this.config = config;
        try {
            Objects.requireNonNull(config.getUrl(), "URL cannot be null");
            this.clusterUrl = new URI(config.getUrl());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid Cluster URL: " + config.getUrl());
        }
        int commsTimeout = (int)config.getTimeout(TimeUnit.MILLISECONDS);
        this.siteInfoProvider = new SiteInfoProvider();
        this.siteInfoProvider.setClusterUrl(this.clusterUrl);
        this.siteInfoProvider.setSslContext(config.getSslContext());
        this.siteInfoProvider.setConnectTimeoutMillis(commsTimeout);
        this.siteInfoProvider.setReadTimeoutMillis(commsTimeout);
        this.siteInfoProvider.setProxy(config.getHttpProxy());
    }

    @Override
    public SiteToSiteClientConfig getConfig() {
        return this.config;
    }
}

