/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.nifi.remote.Communicant;
import org.apache.nifi.remote.PeerDescription;
import org.apache.nifi.remote.protocol.CommunicationsSession;

public class Peer
implements Communicant {
    private final PeerDescription description;
    private final CommunicationsSession commsSession;
    private final String url;
    private final String clusterUrl;
    private final String host;
    private final int port;
    private final Map<String, Long> penaltyExpirationMap = new HashMap<String, Long>();
    private boolean closed = false;

    public Peer(PeerDescription description, CommunicationsSession commsSession, String peerUrl, String clusterUrl) {
        this.description = description;
        this.commsSession = commsSession;
        this.url = peerUrl;
        this.clusterUrl = clusterUrl;
        try {
            URI uri = new URI(peerUrl);
            this.port = uri.getPort();
            this.host = uri.getHost();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid URL: " + peerUrl);
        }
    }

    public PeerDescription getDescription() {
        return this.description;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    public String getClusterUrl() {
        return this.clusterUrl;
    }

    public CommunicationsSession getCommunicationsSession() {
        return this.commsSession;
    }

    public void close() throws IOException {
        this.closed = true;
        try {
            this.commsSession.getInput().consume();
        }
        finally {
            this.commsSession.close();
        }
    }

    public void penalize(String destinationId, long millis) {
        Long currentPenalty = this.penaltyExpirationMap.get(destinationId);
        long proposedPenalty = System.currentTimeMillis() + millis;
        if (currentPenalty == null || proposedPenalty > currentPenalty) {
            this.penaltyExpirationMap.put(destinationId, proposedPenalty);
        }
    }

    public boolean isPenalized(String destinationId) {
        Long currentPenalty = this.penaltyExpirationMap.get(destinationId);
        return currentPenalty != null && currentPenalty > System.currentTimeMillis();
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    public int hashCode() {
        return 8320 + this.url.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Peer)) {
            return false;
        }
        Peer other = (Peer)obj;
        return this.url.equals(other.url);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Peer[url=").append(this.url);
        if (this.closed) {
            sb.append(",CLOSED");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getDistinguishedName() {
        return this.commsSession.getUserDn();
    }

    @Override
    public String createTransitUri(String sourceFlowFileIdentifier) {
        return this.commsSession.createTransitUri(this.url, sourceFlowFileIdentifier);
    }
}

