/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import org.apache.nifi.stream.io.StreamUtils;
import org.apache.nifi.web.api.dto.ControllerDTO;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

public class NiFiRestApiUtil {
    public static final int RESPONSE_CODE_OK = 200;
    private final SSLContext sslContext;

    public NiFiRestApiUtil(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    private HttpURLConnection getConnection(String connUrl, int timeoutMillis) throws IOException {
        URL url = new URL(connUrl);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setConnectTimeout(timeoutMillis);
        connection.setReadTimeout(timeoutMillis);
        if (this.sslContext != null && connection instanceof HttpsURLConnection) {
            HttpsURLConnection secureConnection = (HttpsURLConnection)connection;
            secureConnection.setSSLSocketFactory(this.sslContext.getSocketFactory());
            secureConnection.setHostnameVerifier(new OverrideHostnameVerifier(url.getHost(), secureConnection.getHostnameVerifier()));
        }
        return connection;
    }

    public ControllerDTO getController(String url, int timeoutMillis) throws IOException {
        HttpURLConnection connection = this.getConnection(url, timeoutMillis);
        connection.setRequestMethod("GET");
        int responseCode = connection.getResponseCode();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamUtils.copy((InputStream)connection.getInputStream(), (OutputStream)baos);
        String responseMessage = baos.toString();
        if (responseCode == 200) {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonNode = mapper.readTree(responseMessage);
            JsonNode controllerNode = jsonNode.get("controller");
            return (ControllerDTO)mapper.readValue(controllerNode, ControllerDTO.class);
        }
        throw new IOException("Got HTTP response Code " + responseCode + ": " + connection.getResponseMessage() + " with explanation: " + responseMessage);
    }

    private static class OverrideHostnameVerifier
    implements HostnameVerifier {
        private final String trustedHostname;
        private final HostnameVerifier delegate;

        private OverrideHostnameVerifier(String trustedHostname, HostnameVerifier delegate) {
            this.trustedHostname = trustedHostname;
            this.delegate = delegate;
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            if (this.trustedHostname.equalsIgnoreCase(hostname)) {
                return true;
            }
            return this.delegate.verify(hostname, session);
        }
    }
}

