/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote.protocol.socket;

import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.nifi.remote.exception.ProtocolException;

public enum ResponseCode {
    RESERVED(0, "Reserved for Future Use", false),
    PROPERTIES_OK(1, "Properties OK", false),
    UNKNOWN_PROPERTY_NAME(230, "Unknown Property Name", true),
    ILLEGAL_PROPERTY_VALUE(231, "Illegal Property Value", true),
    MISSING_PROPERTY(232, "Missing Property", true),
    CONTINUE_TRANSACTION(10, "Continue Transaction", false),
    FINISH_TRANSACTION(11, "Finish Transaction", false),
    CONFIRM_TRANSACTION(12, "Confirm Transaction", true),
    TRANSACTION_FINISHED(13, "Transaction Finished", false),
    TRANSACTION_FINISHED_BUT_DESTINATION_FULL(14, "Transaction Finished But Destination is Full", false),
    CANCEL_TRANSACTION(15, "Cancel Transaction", true),
    BAD_CHECKSUM(19, "Bad Checksum", false),
    MORE_DATA(20, "More Data Exists", false),
    NO_MORE_DATA(21, "No More Data Exists", false),
    UNKNOWN_PORT(200, "Unknown Port", false),
    PORT_NOT_IN_VALID_STATE(201, "Port Not in a Valid State", true),
    PORTS_DESTINATION_FULL(202, "Port's Destination is Full", false),
    UNAUTHORIZED(240, "User Not Authorized", true),
    ABORT(250, "Abort", true),
    UNRECOGNIZED_RESPONSE_CODE(254, "Unrecognized Response Code", false),
    END_OF_STREAM(255, "End of Stream", false);

    private static final ResponseCode[] codeArray;
    private static final byte CODE_SEQUENCE_VALUE_1 = 82;
    private static final byte CODE_SEQUENCE_VALUE_2 = 67;
    private final int code;
    private final byte[] codeSequence;
    private final String description;
    private final boolean containsMessage;

    private ResponseCode(int code, String description, boolean containsMessage) {
        this.codeSequence = new byte[]{82, 67, (byte)code};
        this.code = code;
        this.description = description;
        this.containsMessage = containsMessage;
    }

    public int getCode() {
        return this.code;
    }

    public byte[] getCodeSequence() {
        return this.codeSequence;
    }

    public String toString() {
        return this.description;
    }

    public boolean containsMessage() {
        return this.containsMessage;
    }

    public void writeResponse(DataOutputStream out) throws IOException {
        if (this.containsMessage()) {
            throw new IllegalArgumentException("ResponseCode " + this.code + " expects an explanation");
        }
        out.write(this.getCodeSequence());
        out.flush();
    }

    public void writeResponse(DataOutputStream out, String explanation) throws IOException {
        if (!this.containsMessage()) {
            throw new IllegalArgumentException("ResponseCode " + this.code + " does not expect an explanation");
        }
        out.write(this.getCodeSequence());
        out.writeUTF(explanation);
        out.flush();
    }

    static ResponseCode readCode(InputStream in) throws IOException, ProtocolException {
        int byte1 = in.read();
        if (byte1 < 0) {
            throw new EOFException();
        }
        if (byte1 != 82) {
            throw new ProtocolException("Expected to receive ResponseCode, but the stream did not have a ResponseCode");
        }
        int byte2 = in.read();
        if (byte2 < 0) {
            throw new EOFException();
        }
        if (byte2 != 67) {
            throw new ProtocolException("Expected to receive ResponseCode, but the stream did not have a ResponseCode");
        }
        int byte3 = in.read();
        if (byte3 < 0) {
            throw new EOFException();
        }
        ResponseCode responseCode = codeArray[byte3];
        if (responseCode == null) {
            throw new ProtocolException("Received Response Code of " + byte3 + " but do not recognize this code");
        }
        return responseCode;
    }

    public static ResponseCode fromSequence(byte[] value) {
        int code = value[3] & 0xFF;
        ResponseCode responseCode = codeArray[code];
        return responseCode == null ? UNRECOGNIZED_RESPONSE_CODE : responseCode;
    }

    static {
        codeArray = new ResponseCode[256];
        ResponseCode[] responseCodeArray = ResponseCode.values();
        int n = responseCodeArray.length;
        for (int i = 0; i < n; ++i) {
            ResponseCode responseCode;
            ResponseCode.codeArray[responseCode.getCode()] = responseCode = responseCodeArray[i];
        }
    }
}

