/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote.io.socket.ssl;

import java.io.IOException;
import org.apache.nifi.remote.AbstractCommunicationsSession;
import org.apache.nifi.remote.io.socket.ssl.SSLSocketChannel;
import org.apache.nifi.remote.io.socket.ssl.SSLSocketChannelInput;
import org.apache.nifi.remote.io.socket.ssl.SSLSocketChannelOutput;

public class SSLSocketChannelCommunicationsSession
extends AbstractCommunicationsSession {
    private final SSLSocketChannel channel;
    private final SSLSocketChannelInput request;
    private final SSLSocketChannelOutput response;

    public SSLSocketChannelCommunicationsSession(SSLSocketChannel channel, String uri) {
        super(uri);
        this.request = new SSLSocketChannelInput(channel);
        this.response = new SSLSocketChannelOutput(channel);
        this.channel = channel;
    }

    @Override
    public SSLSocketChannelInput getInput() {
        return this.request;
    }

    @Override
    public SSLSocketChannelOutput getOutput() {
        return this.response;
    }

    @Override
    public void setTimeout(int millis) throws IOException {
        this.channel.setTimeout(millis);
    }

    @Override
    public int getTimeout() throws IOException {
        return this.channel.getTimeout();
    }

    @Override
    public void close() throws IOException {
        IOException suppressed = null;
        try {
            this.request.consume();
        }
        catch (IOException ioe) {
            suppressed = ioe;
        }
        try {
            this.channel.close();
        }
        catch (IOException ioe) {
            if (suppressed != null) {
                ioe.addSuppressed(suppressed);
            }
            throw ioe;
        }
        if (suppressed != null) {
            throw suppressed;
        }
    }

    @Override
    public boolean isClosed() {
        return this.channel.isClosed();
    }

    @Override
    public boolean isDataAvailable() {
        try {
            return this.request.isDataAvailable();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public long getBytesWritten() {
        return this.response.getBytesWritten();
    }

    @Override
    public long getBytesRead() {
        return this.request.getBytesRead();
    }

    @Override
    public void interrupt() {
        this.channel.interrupt();
    }

    @Override
    public String toString() {
        return super.toString() + "[SSLSocketChannel=" + this.channel + "]";
    }
}

