/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote.io.socket;

import java.io.IOException;
import java.nio.channels.SocketChannel;
import org.apache.nifi.remote.AbstractCommunicationsSession;
import org.apache.nifi.remote.io.socket.SocketChannelInput;
import org.apache.nifi.remote.io.socket.SocketChannelOutput;

public class SocketChannelCommunicationsSession
extends AbstractCommunicationsSession {
    private final SocketChannel channel;
    private final SocketChannelInput request;
    private final SocketChannelOutput response;
    private int timeout = 30000;

    public SocketChannelCommunicationsSession(SocketChannel socketChannel, String uri) throws IOException {
        super(uri);
        this.request = new SocketChannelInput(socketChannel);
        this.response = new SocketChannelOutput(socketChannel);
        this.channel = socketChannel;
        socketChannel.configureBlocking(false);
    }

    @Override
    public boolean isClosed() {
        return !this.channel.isConnected();
    }

    @Override
    public SocketChannelInput getInput() {
        return this.request;
    }

    @Override
    public SocketChannelOutput getOutput() {
        return this.response;
    }

    @Override
    public void setTimeout(int millis) throws IOException {
        this.request.setTimeout(millis);
        this.response.setTimeout(millis);
        this.timeout = millis;
    }

    @Override
    public int getTimeout() throws IOException {
        return this.timeout;
    }

    @Override
    public void close() throws IOException {
        IOException suppressed = null;
        try {
            this.request.consume();
        }
        catch (IOException ioe) {
            suppressed = ioe;
        }
        try {
            this.channel.close();
        }
        catch (IOException ioe) {
            if (suppressed != null) {
                ioe.addSuppressed(suppressed);
            }
            throw ioe;
        }
        if (suppressed != null) {
            throw suppressed;
        }
    }

    @Override
    public boolean isDataAvailable() {
        return this.request.isDataAvailable();
    }

    @Override
    public long getBytesWritten() {
        return this.response.getBytesWritten();
    }

    @Override
    public long getBytesRead() {
        return this.request.getBytesRead();
    }

    @Override
    public void interrupt() {
        this.request.interrupt();
        this.response.interrupt();
    }
}

