/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.util;

import java.io.PrintWriter;
import java.io.Writer;

public enum SecurityStoreTypes {
    TRUSTSTORE("javax.net.ssl.trustStore", "javax.net.ssl.trustStorePassword", "javax.net.ssl.trustStoreType"),
    KEYSTORE("javax.net.ssl.keyStore", "javax.net.ssl.keyStorePassword", "javax.net.ssl.keyStoreType");

    private String storeProperty = "";
    private String storePasswordProperty = "";
    private String storeTypeProperty = "";

    public static void logProperties(Writer writer, boolean logPasswords) {
        if (writer == null) {
            return;
        }
        PrintWriter pw = new PrintWriter(writer);
        pw.println(KEYSTORE.getStoreProperty() + " = " + System.getProperty(KEYSTORE.getStoreProperty()));
        if (logPasswords) {
            pw.println(KEYSTORE.getStorePasswordProperty() + " = " + System.getProperty(KEYSTORE.getStoreProperty()));
        }
        pw.println(KEYSTORE.getStoreTypeProperty() + " = " + System.getProperty(KEYSTORE.getStoreTypeProperty()));
        pw.println(TRUSTSTORE.getStoreProperty() + " = " + System.getProperty(TRUSTSTORE.getStoreProperty()));
        if (logPasswords) {
            pw.println(TRUSTSTORE.getStorePasswordProperty() + " = " + System.getProperty(TRUSTSTORE.getStoreProperty()));
        }
        pw.println(TRUSTSTORE.getStoreTypeProperty() + " = " + System.getProperty(TRUSTSTORE.getStoreTypeProperty()));
        pw.flush();
    }

    private SecurityStoreTypes(String storeProperty, String storePasswordProperty, String storeTypeProperty) {
        this.storeProperty = storeProperty;
        this.storePasswordProperty = storePasswordProperty;
        this.storeTypeProperty = storeTypeProperty;
    }

    public String getStoreProperty() {
        return this.storeProperty;
    }

    public String getStorePasswordProperty() {
        return this.storePasswordProperty;
    }

    public String getStoreTypeProperty() {
        return this.storeTypeProperty;
    }
}

