/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.util;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public enum EncryptionMethod {
    MD5_128AES("PBEWITHMD5AND128BITAES-CBC-OPENSSL", "BC", false, false),
    MD5_192AES("PBEWITHMD5AND192BITAES-CBC-OPENSSL", "BC", true, false),
    MD5_256AES("PBEWITHMD5AND256BITAES-CBC-OPENSSL", "BC", true, false),
    MD5_DES("PBEWITHMD5ANDDES", "BC", false, false),
    MD5_RC2("PBEWITHMD5ANDRC2", "BC", false, false),
    SHA1_RC2("PBEWITHSHA1ANDRC2", "BC", false, false),
    SHA1_DES("PBEWITHSHA1ANDDES", "BC", false, false),
    SHA_128AES("PBEWITHSHAAND128BITAES-CBC-BC", "BC", false, false),
    SHA_192AES("PBEWITHSHAAND192BITAES-CBC-BC", "BC", true, false),
    SHA_256AES("PBEWITHSHAAND256BITAES-CBC-BC", "BC", true, false),
    SHA_40RC2("PBEWITHSHAAND40BITRC2-CBC", "BC", false, false),
    SHA_128RC2("PBEWITHSHAAND128BITRC2-CBC", "BC", false, false),
    SHA_40RC4("PBEWITHSHAAND40BITRC4", "BC", false, false),
    SHA_128RC4("PBEWITHSHAAND128BITRC4", "BC", false, false),
    SHA256_128AES("PBEWITHSHA256AND128BITAES-CBC-BC", "BC", false, false),
    SHA256_192AES("PBEWITHSHA256AND192BITAES-CBC-BC", "BC", true, false),
    SHA256_256AES("PBEWITHSHA256AND256BITAES-CBC-BC", "BC", true, false),
    SHA_2KEYTRIPLEDES("PBEWITHSHAAND2-KEYTRIPLEDES-CBC", "BC", false, false),
    SHA_3KEYTRIPLEDES("PBEWITHSHAAND3-KEYTRIPLEDES-CBC", "BC", false, false),
    SHA_TWOFISH("PBEWITHSHAANDTWOFISH-CBC", "BC", false, false),
    PGP("PGP", "BC", false, false),
    PGP_ASCII_ARMOR("PGP-ASCII-ARMOR", "BC", false, false),
    AES_CBC("AES/CBC/PKCS7Padding", "BC", false, true),
    AES_CTR("AES/CTR/NoPadding", "BC", false, true),
    AES_GCM("AES/GCM/NoPadding", "BC", false, true);

    private final String algorithm;
    private final String provider;
    private final boolean unlimitedStrength;
    private final boolean compatibleWithStrongKDFs;

    private EncryptionMethod(String algorithm, String provider, boolean unlimitedStrength, boolean compatibleWithStrongKDFs) {
        this.algorithm = algorithm;
        this.provider = provider;
        this.unlimitedStrength = unlimitedStrength;
        this.compatibleWithStrongKDFs = compatibleWithStrongKDFs;
    }

    public String getProvider() {
        return this.provider;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public boolean isUnlimitedStrength() {
        return this.unlimitedStrength;
    }

    public boolean isCompatibleWithStrongKDFs() {
        return this.compatibleWithStrongKDFs;
    }

    public boolean isKeyedCipher() {
        return !this.algorithm.startsWith("PBE") && !this.algorithm.startsWith("PGP");
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        ToStringBuilder.setDefaultStyle((ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append("Algorithm name", (Object)this.algorithm);
        builder.append("Requires unlimited strength JCE policy", this.unlimitedStrength);
        builder.append("Algorithm Provider", (Object)this.provider);
        builder.append("Compatible with strong KDFs", this.compatibleWithStrongKDFs);
        builder.append("Keyed cipher", this.isKeyedCipher());
        return builder.toString();
    }

    public static EncryptionMethod forAlgorithm(String algorithm) {
        if (StringUtils.isNotBlank((CharSequence)algorithm)) {
            for (EncryptionMethod em : EncryptionMethod.values()) {
                if (!em.algorithm.equalsIgnoreCase(algorithm)) continue;
                return em;
            }
        }
        return null;
    }
}

