/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.lookup.script;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.resource.ResourceReferences;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.ControllerServiceInitializationContext;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.NodeTypeProvider;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.lookup.LookupService;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.script.ScriptRunner;
import org.apache.nifi.script.AbstractScriptedControllerService;
import org.apache.nifi.script.ScriptingComponentHelper;
import org.apache.nifi.script.ScriptingComponentUtils;
import org.apache.nifi.script.impl.FilteredPropertiesValidationContextAdapter;

public class BaseScriptedLookupService
extends AbstractScriptedControllerService {
    protected final AtomicReference<LookupService> lookupService = new AtomicReference();
    protected volatile String kerberosServicePrincipal = null;
    protected volatile File kerberosConfigFile = null;
    protected volatile File kerberosServiceKeytab = null;

    protected void init(ControllerServiceInitializationContext context) {
        this.kerberosServicePrincipal = context.getKerberosServicePrincipal();
        this.kerberosConfigFile = context.getKerberosConfigurationFile();
        this.kerberosServiceKeytab = context.getKerberosServiceKeytab();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<Object> supportedPropertyDescriptors;
        block8: {
            AtomicBoolean atomicBoolean = this.scriptingComponentHelper.isInitialized;
            synchronized (atomicBoolean) {
                if (!this.scriptingComponentHelper.isInitialized.get()) {
                    this.scriptingComponentHelper.createResources();
                }
            }
            supportedPropertyDescriptors = new ArrayList<Object>();
            ArrayList<PropertyDescriptor> _temp = new ArrayList<PropertyDescriptor>();
            _temp.addAll(this.scriptingComponentHelper.getDescriptors());
            _temp.remove(this.scriptingComponentHelper.SCRIPT_ENGINE);
            PropertyDescriptor.Builder engineProp = new PropertyDescriptor.Builder().fromPropertyDescriptor(this.scriptingComponentHelper.SCRIPT_ENGINE);
            List<AllowableValue> filtered = this.scriptingComponentHelper.getScriptEngineAllowableValues().stream().collect(Collectors.toList());
            engineProp.allowableValues((DescribedValue[])filtered.toArray(new AllowableValue[filtered.size()]));
            supportedPropertyDescriptors.add(engineProp.build());
            supportedPropertyDescriptors.addAll(_temp);
            ConfigurableComponent instance = (ConfigurableComponent)this.lookupService.get();
            if (instance != null) {
                try {
                    List instanceDescriptors = instance.getPropertyDescriptors();
                    if (instanceDescriptors != null) {
                        supportedPropertyDescriptors.addAll(instanceDescriptors);
                    }
                }
                catch (Throwable t) {
                    ComponentLog logger = this.getLogger();
                    String message = "Unable to get property descriptors from LookupService: " + String.valueOf(t);
                    logger.error(message);
                    if (!logger.isDebugEnabled()) break block8;
                    logger.error(message, t);
                }
            }
        }
        return Collections.unmodifiableList(supportedPropertyDescriptors);
    }

    @Override
    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).dynamic(true).build();
    }

    @Override
    public void onPropertyModified(PropertyDescriptor descriptor, String oldValue, String newValue) {
        this.validationResults.set(new HashSet());
        ComponentLog logger = this.getLogger();
        LookupService instance = this.lookupService.get();
        if (ScriptingComponentUtils.SCRIPT_FILE.equals((Object)descriptor) || ScriptingComponentUtils.SCRIPT_BODY.equals((Object)descriptor) || ScriptingComponentUtils.MODULES.equals((Object)descriptor) || this.scriptingComponentHelper.SCRIPT_ENGINE.equals((Object)descriptor)) {
            if (ScriptingComponentUtils.SCRIPT_FILE.equals((Object)descriptor)) {
                this.scriptingComponentHelper.setScriptPath(newValue);
            } else if (ScriptingComponentUtils.SCRIPT_BODY.equals((Object)descriptor)) {
                this.scriptingComponentHelper.setScriptBody(newValue);
            } else if (this.scriptingComponentHelper.SCRIPT_ENGINE.equals((Object)descriptor)) {
                this.scriptingComponentHelper.setScriptEngineName(newValue);
            }
            this.scriptNeedsReload.set(true);
            this.scriptRunner = null;
        } else if (instance != null) {
            try {
                instance.onPropertyModified(descriptor, oldValue, newValue);
            }
            catch (Exception e) {
                String message = "Unable to invoke onPropertyModified from scripted LookupService: " + String.valueOf(e);
                logger.error(message, (Throwable)e);
            }
        }
    }

    @Override
    protected Collection<ValidationResult> customValidate(ValidationContext context) {
        Collection<ValidationResult> commonValidationResults = super.customValidate(context);
        if (!commonValidationResults.isEmpty()) {
            return commonValidationResults;
        }
        if (!((Collection)this.validationResults.get()).isEmpty()) {
            return (Collection)this.validationResults.get();
        }
        Collection<ValidationResult> scriptingComponentHelperResults = this.scriptingComponentHelper.customValidate(context);
        if (scriptingComponentHelperResults != null && !scriptingComponentHelperResults.isEmpty()) {
            this.validationResults.set(scriptingComponentHelperResults);
            return scriptingComponentHelperResults;
        }
        this.scriptingComponentHelper.setScriptEngineName(context.getProperty(this.scriptingComponentHelper.SCRIPT_ENGINE).getValue());
        this.scriptingComponentHelper.setScriptPath(context.getProperty(ScriptingComponentUtils.SCRIPT_FILE).evaluateAttributeExpressions().getValue());
        this.scriptingComponentHelper.setScriptBody(context.getProperty(ScriptingComponentUtils.SCRIPT_BODY).getValue());
        ResourceReferences resourceReferences = context.getProperty(ScriptingComponentUtils.MODULES).evaluateAttributeExpressions().asResources();
        this.scriptingComponentHelper.setModules(resourceReferences);
        this.setup();
        LookupService instance = this.lookupService.get();
        Collection currentValidationResults = (Collection)this.validationResults.get();
        if (currentValidationResults.isEmpty() && instance != null) {
            try {
                HashSet<PropertyDescriptor> innerPropertyDescriptor = new HashSet<PropertyDescriptor>(this.scriptingComponentHelper.getDescriptors());
                FilteredPropertiesValidationContextAdapter innerValidationContext = new FilteredPropertiesValidationContextAdapter(context, innerPropertyDescriptor);
                Collection instanceResults = instance.validate((ValidationContext)innerValidationContext);
                if (instanceResults != null && !instanceResults.isEmpty()) {
                    return instanceResults;
                }
            }
            catch (Exception e) {
                ComponentLog logger = this.getLogger();
                String message = "Unable to validate the scripted LookupService: " + String.valueOf(e);
                logger.error(message, (Throwable)e);
                HashSet<ValidationResult> results = new HashSet<ValidationResult>();
                results.add(new ValidationResult.Builder().subject("Validation").valid(false).explanation("An error occurred calling validate in the configured scripted LookupService.").input(context.getProperty(ScriptingComponentUtils.SCRIPT_FILE).getValue()).build());
                return results;
            }
        }
        return currentValidationResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        AtomicBoolean atomicBoolean = this.scriptingComponentHelper.isInitialized;
        synchronized (atomicBoolean) {
            if (!this.scriptingComponentHelper.isInitialized.get()) {
                this.scriptingComponentHelper.createResources();
            }
        }
        super.onEnabled(context);
        if (this.scriptRunner == null) throw new ProcessException("Error creating ScriptRunner");
        ScriptEngine scriptEngine = this.scriptRunner.getScriptEngine();
        Invocable invocable = (Invocable)((Object)scriptEngine);
        if (this.configurationContext == null) return;
        try {
            Object obj = scriptEngine.get("lookupService");
            if (obj == null) throw new ScriptException("No LookupService was defined by the script.");
            try {
                invocable.invokeMethod(obj, "onEnabled", context);
                return;
            }
            catch (NoSuchMethodException nsme) {
                if (!this.getLogger().isDebugEnabled()) return;
                this.getLogger().debug("Configured script LookupService does not contain an onEnabled() method.");
            }
            return;
        }
        catch (ScriptException se) {
            throw new ProcessException("Error executing onEnabled(context) method", (Throwable)se);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @OnDisabled
    public void onDisabled(ConfigurationContext context) {
        if (this.scriptRunner == null) throw new ProcessException("Error creating ScriptRunner");
        ScriptEngine scriptEngine = this.scriptRunner.getScriptEngine();
        Invocable invocable = (Invocable)((Object)scriptEngine);
        if (this.configurationContext != null) {
            try {
                Object obj = this.scriptRunner.getScriptEngine().get("lookupService");
                if (obj != null) {
                    try {
                        invocable.invokeMethod(obj, "onDisabled", context);
                    }
                    catch (NoSuchMethodException nsme) {
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("Configured script LookupService does not contain an onDisabled() method.");
                        }
                    }
                } else {
                    this.getLogger().warn("No LookupService was defined by the script.");
                }
            }
            catch (ScriptException se) {
                throw new ProcessException("Error executing onDisabled(context) method", (Throwable)se);
            }
        }
        this.scriptingComponentHelper.stop();
        this.lookupService.set(null);
        this.scriptRunner = null;
    }

    @Override
    public void setup() {
        if (this.scriptNeedsReload.get() || this.lookupService.get() == null) {
            if (ScriptingComponentHelper.isFile(this.scriptingComponentHelper.getScriptPath())) {
                this.scriptNeedsReload.set(!this.reloadScriptFile(this.scriptingComponentHelper.getScriptPath()));
            } else {
                this.scriptNeedsReload.set(!this.reloadScriptBody(this.scriptingComponentHelper.getScriptBody()));
            }
        }
    }

    @Override
    protected boolean reloadScript(String scriptBody) {
        HashSet<ValidationResult> results;
        block11: {
            results = new HashSet<ValidationResult>();
            try {
                if (this.scriptRunner == null) {
                    this.scriptingComponentHelper.setupScriptRunners(1, scriptBody, this.getLogger());
                    this.scriptRunner = (ScriptRunner)this.scriptingComponentHelper.scriptRunnerQ.poll();
                }
                if (this.scriptRunner == null) {
                    throw new ProcessException("No script runner available!");
                }
                ScriptEngine scriptEngine = this.scriptRunner.getScriptEngine();
                if (scriptEngine instanceof Invocable) {
                    Invocable invocable = (Invocable)((Object)scriptEngine);
                    this.scriptRunner.run(scriptEngine.getBindings(100));
                    Object obj = this.scriptRunner.getScriptEngine().get("lookupService");
                    if (obj != null) {
                        ComponentLog logger;
                        block10: {
                            logger = this.getLogger();
                            try {
                                invocable.invokeMethod(obj, "setLogger", logger);
                            }
                            catch (NoSuchMethodException nsme) {
                                if (!logger.isDebugEnabled()) break block10;
                                logger.debug("Scripted LookupService does not contain a setLogger method.");
                            }
                        }
                        LookupService scriptedLookupService = invocable.getInterface(obj, LookupService.class);
                        this.lookupService.set(scriptedLookupService);
                        if (scriptedLookupService == null) break block11;
                        try {
                            scriptedLookupService.initialize(new ControllerServiceInitializationContext(){

                                public String getIdentifier() {
                                    return BaseScriptedLookupService.this.getIdentifier();
                                }

                                public ComponentLog getLogger() {
                                    return logger;
                                }

                                public StateManager getStateManager() {
                                    return BaseScriptedLookupService.this.getStateManager();
                                }

                                public NodeTypeProvider getNodeTypeProvider() {
                                    return BaseScriptedLookupService.this.getNodeTypeProvider();
                                }

                                public ControllerServiceLookup getControllerServiceLookup() {
                                    return BaseScriptedLookupService.super.getControllerServiceLookup();
                                }

                                public String getKerberosServicePrincipal() {
                                    return BaseScriptedLookupService.this.kerberosServicePrincipal;
                                }

                                public File getKerberosServiceKeytab() {
                                    return BaseScriptedLookupService.this.kerberosServiceKeytab;
                                }

                                public File getKerberosConfigurationFile() {
                                    return BaseScriptedLookupService.this.kerberosConfigFile;
                                }
                            });
                            break block11;
                        }
                        catch (Exception e) {
                            logger.error("Unable to initialize scripted LookupService", (Throwable)e);
                            throw new ProcessException((Throwable)e);
                        }
                    }
                    throw new ScriptException("No LookupService was defined by the script.");
                }
                throw new ScriptException("Script engine is not Invocable, cannot be used for ScriptedLookupService");
            }
            catch (Exception ex) {
                ComponentLog logger = this.getLogger();
                String message = "Unable to load script: " + ex.getLocalizedMessage();
                logger.error(message, (Throwable)ex);
                results.add(new ValidationResult.Builder().subject("ScriptedLookupServiceValidation").valid(false).explanation("Unable to load script due to " + ex.getLocalizedMessage()).input(this.scriptingComponentHelper.getScriptPath()).build());
            }
        }
        this.validationResults.set(results);
        return results.isEmpty();
    }
}

