/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.script;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.apache.commons.io.IOUtils;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.script.InterpretedScriptEvaluator;
import org.apache.nifi.processors.script.ScriptEvaluator;
import org.apache.nifi.processors.script.ScriptRunner;
import org.apache.nifi.script.ScriptingComponentHelper;
import org.apache.nifi.script.ScriptingComponentUtils;
import org.apache.nifi.search.SearchContext;
import org.apache.nifi.search.SearchResult;
import org.apache.nifi.search.Searchable;
import org.apache.nifi.serialization.RecordReaderFactory;
import org.apache.nifi.serialization.RecordSetWriterFactory;

abstract class ScriptedRecordProcessor
extends AbstractProcessor
implements Searchable {
    protected static final Set<String> SCRIPT_OPTIONS = ScriptingComponentUtils.getAvailableEngines();
    protected volatile String scriptToRun = null;
    protected final AtomicReference<CompiledScript> compiledScriptRef = new AtomicReference();
    private final ScriptingComponentHelper scriptingComponentHelper = new ScriptingComponentHelper();
    static final PropertyDescriptor RECORD_READER = new PropertyDescriptor.Builder().name("Record Reader").displayName("Record Reader").description("The Record Reader to use parsing the incoming FlowFile into Records").required(true).identifiesControllerService(RecordReaderFactory.class).build();
    static final PropertyDescriptor RECORD_WRITER = new PropertyDescriptor.Builder().name("Record Writer").displayName("Record Writer").description("The Record Writer to use for serializing Records after they have been transformed").required(true).identifiesControllerService(RecordSetWriterFactory.class).build();
    static final PropertyDescriptor LANGUAGE = new PropertyDescriptor.Builder().name("Script Engine").displayName("Script Language").description("The Language to use for the script").allowableValues(SCRIPT_OPTIONS).defaultValue("Groovy").required(true).build();
    protected static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(RECORD_READER, RECORD_WRITER, LANGUAGE, ScriptingComponentUtils.SCRIPT_BODY, ScriptingComponentUtils.SCRIPT_FILE, ScriptingComponentUtils.MODULES);

    ScriptedRecordProcessor() {
    }

    @OnScheduled
    public void setup(ProcessContext context) throws IOException {
        if (!this.scriptingComponentHelper.isInitialized.get()) {
            this.scriptingComponentHelper.createResources(false);
        }
        this.scriptingComponentHelper.setupVariables((PropertyContext)context);
        this.scriptToRun = this.scriptingComponentHelper.getScriptBody();
        if (this.scriptToRun == null && this.scriptingComponentHelper.getScriptPath() != null) {
            try (FileInputStream scriptStream = new FileInputStream(this.scriptingComponentHelper.getScriptPath());){
                this.scriptToRun = IOUtils.toString((InputStream)scriptStream, (Charset)Charset.defaultCharset());
            }
        }
        int maxTasks = context.getMaxConcurrentTasks();
        this.scriptingComponentHelper.setupScriptRunners(maxTasks, this.scriptToRun, this.getLogger());
        this.compiledScriptRef.set(null);
    }

    protected ScriptEvaluator createEvaluator(ScriptEngine scriptEngine, FlowFile flowFile) throws ScriptException {
        return new InterpretedScriptEvaluator(scriptEngine, this.scriptToRun, flowFile, this.getLogger());
    }

    private CompiledScript getOrCompileScript(Compilable scriptEngine, String scriptToRun) throws ScriptException {
        CompiledScript existing = this.compiledScriptRef.get();
        if (existing != null) {
            return existing;
        }
        CompiledScript compiled = scriptEngine.compile(scriptToRun);
        boolean updated = this.compiledScriptRef.compareAndSet(null, compiled);
        if (updated) {
            return compiled;
        }
        return this.compiledScriptRef.get();
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        return this.scriptingComponentHelper.customValidate(validationContext);
    }

    public Collection<SearchResult> search(SearchContext context) {
        return ScriptingComponentUtils.search(context, this.getLogger());
    }

    protected static Bindings setupBindings(ScriptEngine scriptEngine) {
        Bindings bindings = scriptEngine.getBindings(100);
        if (bindings == null) {
            bindings = new SimpleBindings();
        }
        scriptEngine.setBindings(bindings, 100);
        return bindings;
    }

    protected ScriptRunner pollScriptRunner() {
        ScriptRunner scriptRunner = (ScriptRunner)this.scriptingComponentHelper.scriptRunnerQ.poll();
        if (scriptRunner == null) {
            throw new ProcessException("Could not acquire script runner!");
        }
        return scriptRunner;
    }

    protected void offerScriptRunner(ScriptRunner scriptRunner) {
        this.scriptingComponentHelper.scriptRunnerQ.offer(scriptRunner);
    }
}

