/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.schemaregistry.services;

import java.util.Map;
import java.util.Objects;
import org.apache.nifi.schemaregistry.services.SchemaDefinition;
import org.apache.nifi.serialization.record.SchemaIdentifier;

public class StandardSchemaDefinition
implements SchemaDefinition {
    private final SchemaIdentifier identifier;
    private final String text;
    private final Map<String, SchemaDefinition> references;
    private final SchemaDefinition.SchemaType schemaType;

    public StandardSchemaDefinition(SchemaIdentifier identifier, String text, SchemaDefinition.SchemaType schemaType, Map<String, SchemaDefinition> references) {
        this.identifier = Objects.requireNonNull(identifier, "Schema identifier cannot be null");
        this.text = Objects.requireNonNull(text, "Schema text cannot be null");
        this.schemaType = Objects.requireNonNull(schemaType, "Schema type cannot be null");
        this.references = references != null ? Map.copyOf(references) : Map.of();
    }

    public StandardSchemaDefinition(SchemaIdentifier identifier, String text, SchemaDefinition.SchemaType schemaType) {
        this(identifier, text, schemaType, null);
    }

    @Override
    public SchemaDefinition.SchemaType getSchemaType() {
        return this.schemaType;
    }

    @Override
    public SchemaIdentifier getIdentifier() {
        return this.identifier;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public Map<String, SchemaDefinition> getReferences() {
        return this.references;
    }

    public final boolean equals(Object o) {
        if (!(o instanceof StandardSchemaDefinition)) {
            return false;
        }
        StandardSchemaDefinition that = (StandardSchemaDefinition)o;
        return this.identifier.equals((Object)that.identifier) && this.text.equals(that.text) && this.references.equals(that.references) && this.schemaType == that.schemaType;
    }

    public int hashCode() {
        int result = this.identifier.hashCode();
        result = 31 * result + this.text.hashCode();
        result = 31 * result + this.references.hashCode();
        result = 31 * result + this.schemaType.hashCode();
        return result;
    }

    public String toString() {
        return "StandardSchemaDefinition{identifier=" + String.valueOf(this.identifier) + ", references=" + String.valueOf(this.references) + ", schemaType=" + String.valueOf((Object)this.schemaType) + "}";
    }
}

