/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.rules.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.ControllerServiceInitializationContext;
import org.apache.nifi.record.sink.RecordSinkService;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.rules.Action;
import org.apache.nifi.rules.handlers.AbstractActionHandlerService;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.WriteResult;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.ListRecordSet;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.RecordSet;

@Tags(value={"rules", "rules engine", "action", "action handler", "record", "record sink"})
@CapabilityDescription(value="Sends fact information to sink based on a provided action (usually created by a rules engine).  Action objects executed with this Handler should contain \"sendZeroResult\" attribute.")
public class RecordSinkHandler
extends AbstractActionHandlerService {
    static final PropertyDescriptor RECORD_SINK_SERVICE = new PropertyDescriptor.Builder().name("record-sink-service").displayName("Record Sink Service").description("Specifies the Controller Service used to support the SEND event action.  If not set SEND events will be ignored.").identifiesControllerService(RecordSinkService.class).required(true).build();
    private RecordSinkService recordSinkService;
    private List<PropertyDescriptor> properties;

    protected void init(ControllerServiceInitializationContext config) throws InitializationException {
        super.init(config);
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(RECORD_SINK_SERVICE);
        properties.add(ENFORCE_ACTION_TYPE);
        properties.add(ENFORCE_ACTION_TYPE_LEVEL);
        this.properties = Collections.unmodifiableList(properties);
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    @Override
    @OnEnabled
    public void onEnabled(ConfigurationContext context) throws InitializationException {
        super.onEnabled(context);
        if (context.getProperty(RECORD_SINK_SERVICE).isSet()) {
            this.recordSinkService = (RecordSinkService)context.getProperty(RECORD_SINK_SERVICE).asControllerService(RecordSinkService.class);
        }
    }

    @Override
    protected void executeAction(PropertyContext propertyContext, Action action, Map<String, Object> facts) {
        this.executeAction(action, facts);
    }

    @Override
    protected void executeAction(Action action, Map<String, Object> facts) {
        Map attributes = action.getAttributes();
        boolean sendZeroResults = attributes.containsKey("sentZeroResults") && Boolean.parseBoolean((String)attributes.get("sendZeroResults"));
        RecordSet recordSet = this.getRecordSet(facts);
        try {
            WriteResult result = this.recordSinkService.sendData(recordSet, attributes, sendZeroResults);
            if (this.getLogger().isDebugEnabled() && result != null) {
                this.getLogger().debug("Records written to sink service: {}", new Object[]{result.getRecordCount()});
            }
        }
        catch (Exception ex) {
            this.getLogger().warn("Exception encountered when attempting to send metrics", (Throwable)ex);
        }
    }

    private RecordSet getRecordSet(Map<String, Object> metrics) {
        List recordFields = metrics.entrySet().stream().map(entry -> new RecordField((String)entry.getKey(), this.getDataType(String.valueOf(entry.getValue())))).collect(Collectors.toList());
        SimpleRecordSchema recordSchema = new SimpleRecordSchema(recordFields);
        return new ListRecordSet((RecordSchema)recordSchema, Arrays.asList(new MapRecord((RecordSchema)recordSchema, metrics)));
    }

    private DataType getDataType(String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        if (NumberUtils.isParsable((String)value)) {
            if (value.contains(".")) {
                try {
                    double doubleValue = Double.parseDouble(value);
                    if (doubleValue > 3.4028234663852886E38 || doubleValue < (double)1.4E-45f) {
                        return RecordFieldType.DOUBLE.getDataType();
                    }
                    return RecordFieldType.FLOAT.getDataType();
                }
                catch (NumberFormatException nfe) {
                    return RecordFieldType.STRING.getDataType();
                }
            }
            try {
                long longValue = Long.parseLong(value);
                if (longValue > Integer.MAX_VALUE || longValue < Integer.MIN_VALUE) {
                    return RecordFieldType.LONG.getDataType();
                }
                return RecordFieldType.INT.getDataType();
            }
            catch (NumberFormatException nfe) {
                return RecordFieldType.STRING.getDataType();
            }
        }
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
            return RecordFieldType.BOOLEAN.getDataType();
        }
        return RecordFieldType.STRING.getDataType();
    }
}

