/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.rules.handlers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.ControllerServiceInitializationContext;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.rules.Action;
import org.apache.nifi.rules.handlers.AbstractActionHandlerService;
import org.mvel2.MVEL;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

@Tags(value={"rules", "rules engine", "action", "action handler", "expression language", "MVEL", "SpEL"})
@CapabilityDescription(value="Executes an action containing an expression written in MVEL or SpEL. The action is usually created by a rules engine. Action objects executed with this Handler should contain \"command\" and \"type\" attributes.")
public class ExpressionHandler
extends AbstractActionHandlerService {
    public static final PropertyDescriptor DEFAULT_EXPRESSION_LANGUAGE_TYPE = new PropertyDescriptor.Builder().name("default-expression-language-type").displayName("Default Expression Language Type").required(true).description("If an expression language type is not provided as an attribute within an Action, the default expression language that should be used to compile and execute action. Supported languages are MVEL and Spring Expression Language (SpEL).").allowableValues((Enum[])ExpresssionType.values()).defaultValue("MVEL").build();
    private List<PropertyDescriptor> properties;
    private ExpresssionType type;

    protected void init(ControllerServiceInitializationContext config) throws InitializationException {
        super.init(config);
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(DEFAULT_EXPRESSION_LANGUAGE_TYPE);
        properties.add(ENFORCE_ACTION_TYPE);
        properties.add(ENFORCE_ACTION_TYPE_LEVEL);
        this.properties = Collections.unmodifiableList(properties);
    }

    @Override
    @OnEnabled
    public void onEnabled(ConfigurationContext context) throws InitializationException {
        super.onEnabled(context);
        this.type = ExpresssionType.valueOf(context.getProperty(DEFAULT_EXPRESSION_LANGUAGE_TYPE).getValue());
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    @Override
    protected void executeAction(PropertyContext propertyContext, Action action, Map<String, Object> facts) {
        this.executeAction(action, facts);
    }

    @Override
    protected void executeAction(Action action, Map<String, Object> facts) {
        block5: {
            Map attributes = action.getAttributes();
            String command = (String)attributes.get("command");
            if (StringUtils.isNotEmpty((CharSequence)command)) {
                try {
                    String type = attributes.getOrDefault("type", this.type.toString());
                    ExpresssionType expresssionType = ExpresssionType.valueOf(type);
                    if (expresssionType.equals((Object)ExpresssionType.MVEL)) {
                        this.executeMVEL(command, facts);
                        break block5;
                    }
                    this.executeSPEL(command, facts);
                }
                catch (Exception ex) {
                    this.getLogger().warn("Error occurred when attempting to execute expression. Action: {}, Facts - {}", new Object[]{action, facts}, (Throwable)ex);
                }
            } else {
                this.getLogger().warn("Command attribute was not provided.  Action: {}, Facts - {}", new Object[]{action, facts});
            }
        }
    }

    private void executeMVEL(String command, Map<String, Object> facts) {
        MVEL.executeExpression((Object)MVEL.compileExpression((String)command), facts);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Expression was executed successfully: {}: {}", new Object[]{this.type, command});
        }
    }

    private void executeSPEL(String command, Map<String, Object> facts) {
        SpelExpressionParser parser = new SpelExpressionParser();
        StandardEvaluationContext context = new StandardEvaluationContext();
        context.setRootObject(facts);
        context.setVariables(facts);
        Expression expression = parser.parseExpression(command);
        Object value = expression.getValue((EvaluationContext)context);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Expression was executed successfully with result: {}. {}: {}", new Object[]{value, this.type, command});
        }
    }

    static enum ExpresssionType {
        MVEL,
        SPEL;

    }
}

