/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.redis.service;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.distributed.cache.client.AtomicCacheEntry;
import org.apache.nifi.distributed.cache.client.AtomicDistributedMapCacheClient;
import org.apache.nifi.distributed.cache.client.Deserializer;
import org.apache.nifi.distributed.cache.client.Serializer;
import org.apache.nifi.redis.RedisConnectionPool;
import org.apache.nifi.redis.RedisType;
import org.apache.nifi.redis.service.SimpleRedisDistributedMapCacheClientService;
import org.apache.nifi.redis.util.RedisUtils;

@Tags(value={"redis", "distributed", "cache", "map"})
@CapabilityDescription(value="An implementation of DistributedMapCacheClient that uses Redis as the backing cache. This service relies on the WATCH, MULTI, and EXEC commands in Redis, which are not fully supported when Redis is clustered. As a result, this service can only be used with a Redis Connection Pool that is configured for standalone or sentinel mode. Sentinel mode can be used to provide high-availability configurations.")
public class RedisDistributedMapCacheClientService
extends SimpleRedisDistributedMapCacheClientService
implements AtomicDistributedMapCacheClient<byte[]> {
    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        RedisType redisType;
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        RedisConnectionPool redisConnectionPool = (RedisConnectionPool)validationContext.getProperty(RedisUtils.REDIS_CONNECTION_POOL).asControllerService(RedisConnectionPool.class);
        if (redisConnectionPool != null && (redisType = redisConnectionPool.getRedisType()) != null && redisType == RedisType.CLUSTER) {
            results.add(new ValidationResult.Builder().subject(RedisUtils.REDIS_CONNECTION_POOL.getDisplayName()).valid(false).explanation(RedisUtils.REDIS_CONNECTION_POOL.getDisplayName() + " is configured in clustered mode, and this service requires a non-clustered Redis").build());
        }
        return results;
    }

    public <K, V> AtomicCacheEntry<K, V, byte[]> fetch(K key, Serializer<K> keySerializer, Deserializer<V> valueDeserializer) throws IOException {
        return (AtomicCacheEntry)this.withConnection(redisConnection -> {
            byte[] k = this.serialize(key, keySerializer);
            byte[] v = redisConnection.stringCommands().get(k);
            if (v == null) {
                return null;
            }
            return new AtomicCacheEntry(key, valueDeserializer.deserialize(v), (Object)v);
        });
    }

    public <K, V> boolean replace(AtomicCacheEntry<K, V, byte[]> entry, Serializer<K> keySerializer, Serializer<V> valueSerializer) throws IOException {
        return (Boolean)this.withConnection(redisConnection -> {
            List results;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            keySerializer.serialize(entry.getKey(), (OutputStream)out);
            byte[] k = out.toByteArray();
            out.reset();
            valueSerializer.serialize(entry.getValue(), (OutputStream)out);
            byte[] newVal = out.toByteArray();
            byte[] prevVal = entry.getRevision().orElse(null);
            boolean replaced = false;
            redisConnection.watch((byte[][])new byte[][]{k});
            byte[] currValue = redisConnection.stringCommands().get(k);
            redisConnection.multi();
            if (Arrays.equals(prevVal, currValue)) {
                redisConnection.stringCommands().getSet(k, newVal);
                long ttl = this.getTtl();
                if (ttl != -1L) {
                    redisConnection.keyCommands().expire(k, ttl);
                }
            }
            if ((results = redisConnection.exec()) != null && !results.isEmpty()) {
                replaced = true;
            }
            return replaced;
        });
    }
}

