/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.questdb.mapping;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import org.apache.nifi.questdb.QueryResultProcessor;
import org.apache.nifi.questdb.QueryRowContext;
import org.apache.nifi.questdb.mapping.RequestMapping;

final class RequestMappingBasedQueryResultProcessor<T>
implements QueryResultProcessor<List<T>> {
    private final RequestMapping<T> mapping;
    private final List<T> result = new ArrayList<T>();

    RequestMappingBasedQueryResultProcessor(RequestMapping<T> mapping) {
        this.mapping = mapping;
    }

    @Override
    public void processRow(QueryRowContext context) {
        T entry = this.mapping.getNewInstance();
        for (int position = 0; position < this.mapping.getNumberOfFields(); ++position) {
            if (!ENTRY_FILLERS.containsKey(this.mapping.getFieldType(position))) {
                throw new IllegalArgumentException(String.format("Unknown field type \"%s\"", this.mapping.getFieldType(position)));
            }
            BiFunction integerRecordBiFunction = (BiFunction)ENTRY_FILLERS.get(this.mapping.getFieldType(position));
            this.mapping.getMapping(position).accept(entry, integerRecordBiFunction.apply(position, context));
        }
        this.result.add(entry);
    }

    @Override
    public List<T> getResult() {
        return this.result;
    }
}

