/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.questdb.embedded;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.HashSet;
import java.util.Set;
import org.apache.nifi.questdb.embedded.EmbeddedDatabaseManagerContext;
import org.apache.nifi.questdb.embedded.ManagedTableDefinition;

final class SimpleEmbeddedDatabaseManagerContext
implements EmbeddedDatabaseManagerContext {
    private final Set<ManagedTableDefinition> tableDefinitions = new HashSet<ManagedTableDefinition>();
    private String persistLocation;
    private String backupLocation;
    private int numberOfAttemptedRetries;
    private Duration lockAttemptDuration;
    private Duration rolloverFrequnecyDuration;

    SimpleEmbeddedDatabaseManagerContext() {
    }

    @Override
    public String getPersistLocation() {
        return this.persistLocation;
    }

    @Override
    public Path getPersistLocationAsPath() {
        return Paths.get(this.getPersistLocation(), new String[0]);
    }

    @Override
    public String getBackupLocation() {
        return this.backupLocation;
    }

    @Override
    public Path getBackupLocationAsPath() {
        return Paths.get(this.getBackupLocation(), new String[0]);
    }

    @Override
    public int getNumberOfAttemptedRetries() {
        return this.numberOfAttemptedRetries;
    }

    @Override
    public Duration getLockAttemptTime() {
        return this.lockAttemptDuration;
    }

    @Override
    public Duration getRolloverFrequency() {
        return this.rolloverFrequnecyDuration;
    }

    @Override
    public Set<ManagedTableDefinition> getTableDefinitions() {
        return this.tableDefinitions;
    }

    void setPersistLocation(String persistLocation) {
        this.persistLocation = persistLocation;
    }

    public void setBackupLocation(String backupLocation) {
        this.backupLocation = backupLocation;
    }

    void setNumberOfAttemptedRetries(int numberOfAttemptedRetries) {
        this.numberOfAttemptedRetries = numberOfAttemptedRetries;
    }

    void setLockAttemptDuration(Duration lockAttemptDuration) {
        this.lockAttemptDuration = lockAttemptDuration;
    }

    void setRolloverFrequencyDuration(Duration rolloverFreqencyDuration) {
        this.rolloverFrequnecyDuration = rolloverFreqencyDuration;
    }

    void addTableDefinition(ManagedTableDefinition tableDefinition) {
        this.tableDefinitions.add(tableDefinition);
    }

    public String toString() {
        return "SimpleEmbeddedDatabaseManagerContext{tableDefinitions=" + String.valueOf(this.tableDefinitions) + ", persistLocation='" + this.persistLocation + "', backupLocation='" + this.backupLocation + "', numberOfAttemptedRetries=" + this.numberOfAttemptedRetries + ", lockAttemptDuration=" + String.valueOf(this.lockAttemptDuration) + ", rolloverFrequnecyDuration=" + String.valueOf(this.rolloverFrequnecyDuration) + "}";
    }
}

