/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.questdb.embedded;

import java.util.HashSet;
import java.util.Set;
import org.apache.nifi.questdb.Client;
import org.apache.nifi.questdb.embedded.ManagedTableDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RolloverWorker
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(RolloverWorker.class);
    private final Client client;
    private final Set<ManagedTableDefinition> tableDefinitions = new HashSet<ManagedTableDefinition>();

    RolloverWorker(Client client, Set<ManagedTableDefinition> tableDefinitions) {
        this.client = client;
        this.tableDefinitions.addAll(tableDefinitions);
    }

    @Override
    public void run() {
        LOGGER.debug("Rollover started");
        for (ManagedTableDefinition tableDefinition : this.tableDefinitions) {
            LOGGER.debug("Rollover started for Table {}", (Object)tableDefinition.getName());
            tableDefinition.getRolloverStrategy().rollOver(this.client, tableDefinition.getName());
            LOGGER.debug("Rollover completed for Table {}", (Object)tableDefinition.getName());
        }
        LOGGER.debug("Rollover completed");
    }
}

