/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.questdb.embedded;

import java.util.function.BiConsumer;
import org.apache.nifi.questdb.Client;
import org.apache.nifi.questdb.DatabaseException;
import org.apache.nifi.questdb.InsertRowDataSource;
import org.apache.nifi.questdb.QueryResultProcessor;
import org.apache.nifi.questdb.embedded.ClientDisconnectedException;
import org.springframework.retry.RetryCallback;
import org.springframework.retry.RetryContext;
import org.springframework.retry.RetryListener;
import org.springframework.retry.support.RetryTemplate;

final class RetryingClient
implements Client {
    private final RetryTemplate retryTemplate;
    private final Client client;
    private final Client fallbackClient;

    private RetryingClient(RetryTemplate retryTemplate, Client client, Client fallbackClient) {
        this.retryTemplate = retryTemplate;
        this.client = client;
        this.fallbackClient = fallbackClient;
    }

    @Override
    public void execute(final String query) throws DatabaseException {
        this.retryTemplate.execute((RetryCallback)new RetryWhenConnected<Void>(){

            @Override
            public Void executeWithRetry(RetryContext context) throws DatabaseException {
                RetryingClient.this.client.execute(query);
                return null;
            }
        }, context -> {
            this.fallbackClient.execute(query);
            return null;
        });
    }

    @Override
    public void insert(final String tableName, final InsertRowDataSource rowSource) throws DatabaseException {
        this.retryTemplate.execute((RetryCallback)new RetryWhenConnected<Void>(){

            @Override
            public Void executeWithRetry(RetryContext context) throws DatabaseException {
                RetryingClient.this.client.insert(tableName, rowSource);
                return null;
            }
        }, context -> {
            this.fallbackClient.insert(tableName, rowSource);
            return null;
        });
    }

    @Override
    public <T> T query(final String query, final QueryResultProcessor<T> rowProcessor) throws DatabaseException {
        return (T)this.retryTemplate.execute((RetryCallback)new RetryWhenConnected<T>(){

            @Override
            public T executeWithRetry(RetryContext context) throws DatabaseException {
                return RetryingClient.this.client.query(query, rowProcessor);
            }
        }, context -> this.fallbackClient.query(query, rowProcessor));
    }

    @Override
    public void disconnect() throws DatabaseException {
        this.client.disconnect();
    }

    static RetryingClient getInstance(int numberOfRetries, final BiConsumer<Integer, Throwable> errorAction, Client client, Client fallbackClient) {
        RetryListener listener = new RetryListener(){

            public <T, E extends Throwable> void onError(RetryContext context, RetryCallback<T, E> callback, Throwable throwable) {
                errorAction.accept(context.getRetryCount(), throwable);
            }
        };
        RetryTemplate retryTemplate = RetryTemplate.builder().maxAttempts(numberOfRetries + 1).fixedBackoff(50L).withListener(listener).build();
        return new RetryingClient(retryTemplate, client, fallbackClient);
    }

    private static abstract class RetryWhenConnected<R>
    implements RetryCallback<R, DatabaseException> {
        private RetryWhenConnected() {
        }

        public R doWithRetry(RetryContext context) throws DatabaseException {
            try {
                return this.executeWithRetry(context);
            }
            catch (ClientDisconnectedException e) {
                context.setExhaustedOnly();
                throw e;
            }
        }

        public abstract R executeWithRetry(RetryContext var1) throws DatabaseException;
    }
}

