/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.questdb.embedded;

import org.apache.nifi.questdb.Client;
import org.apache.nifi.questdb.DatabaseException;
import org.apache.nifi.questdb.InsertRowDataSource;
import org.apache.nifi.questdb.QueryResultProcessor;
import org.apache.nifi.questdb.embedded.ConditionFailedException;

final class ConditionAwareClient
implements Client {
    public static final String CONDITION_ERROR = "Condition is not met, cannot call the enveloped client";
    private final Client client;
    private final Condition condition;

    ConditionAwareClient(Condition condition, Client client) {
        this.client = client;
        this.condition = condition;
    }

    @Override
    public void execute(String query) throws DatabaseException {
        if (!this.condition.check()) {
            throw new ConditionFailedException(CONDITION_ERROR);
        }
        this.client.execute(query);
    }

    @Override
    public void insert(String tableName, InsertRowDataSource rowSource) throws DatabaseException {
        if (!this.condition.check()) {
            throw new ConditionFailedException(CONDITION_ERROR);
        }
        this.client.insert(tableName, rowSource);
    }

    @Override
    public <T> T query(String query, QueryResultProcessor<T> rowProcessor) throws DatabaseException {
        if (this.condition.check()) {
            return this.client.query(query, rowProcessor);
        }
        throw new ConditionFailedException(CONDITION_ERROR);
    }

    @Override
    public void disconnect() throws DatabaseException {
        this.client.disconnect();
    }

    public String toString() {
        return "ConditionAwareQuestDbClient{client=" + String.valueOf(this.client) + ", condition=" + String.valueOf(this.condition) + "}";
    }

    @FunctionalInterface
    static interface Condition {
        public boolean check();
    }
}

