/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.questdb;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.nifi.questdb.QueryRowContext;

public interface QueryResultProcessor<R> {
    public static final Map<Class<?>, BiFunction<Integer, QueryRowContext, ?>> ENTRY_FILLERS = Map.of(Integer.class, (p, r) -> r.getInt((int)p), Long.class, (p, r) -> r.getLong((int)p), String.class, (p, r) -> r.getString((int)p), Instant.class, (p, r) -> QueryResultProcessor.microsToInstant(r.getTimestamp((int)p)));

    private static Instant microsToInstant(long micros) {
        return Instant.EPOCH.plus(micros, ChronoUnit.MICROS);
    }

    public void processRow(QueryRowContext var1);

    public R getResult();
}

