/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.python.processor;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.python.processor.InputFlowFile;
import org.apache.nifi.stream.io.StreamUtils;

public class StandardInputFlowFile
implements InputFlowFile,
Closeable {
    private final ProcessSession session;
    private final FlowFile flowFile;
    private BufferedReader bufferedReader;

    public StandardInputFlowFile(ProcessSession session, FlowFile flowFile) {
        this.session = session;
        this.flowFile = flowFile;
    }

    @Override
    public byte[] getContentsAsBytes() throws IOException {
        if (this.flowFile.getSize() > Integer.MAX_VALUE) {
            throw new IOException("Cannot read FlowFile contents into a byte array because size is " + this.flowFile.getSize() + ", which exceeds the maximum allowable size of 2147483647 bytes");
        }
        try (InputStream in = this.session.read(this.flowFile);){
            byte[] bytes = new byte[(int)this.flowFile.getSize()];
            StreamUtils.fillBuffer((InputStream)in, (byte[])bytes);
            byte[] byArray = bytes;
            return byArray;
        }
    }

    @Override
    public BufferedReader getContentsAsReader() throws IOException {
        this.close();
        InputStream in = this.session.read(this.flowFile);
        InputStreamReader reader = new InputStreamReader(in);
        this.bufferedReader = new BufferedReader(reader);
        return this.bufferedReader;
    }

    @Override
    public void close() throws IOException {
        if (this.bufferedReader != null) {
            this.bufferedReader.close();
        }
    }

    @Override
    public long getSize() {
        return this.flowFile.getSize();
    }

    @Override
    public String getAttribute(String name) {
        return this.flowFile.getAttribute(name);
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.flowFile.getAttributes();
    }

    public String toString() {
        return "FlowFile[id=" + this.getAttribute("uuid") + ", filename=" + this.getAttribute("filename") + ", size=" + this.getSize() + "]";
    }
}

