/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.py4j.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.LoggerContextListener;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.nifi.logging.LogLevel;
import org.apache.nifi.py4j.logging.LogLevelChangeListener;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;

public class LevelChangeListener
implements LoggerContextListener {
    private static final Map<Level, LogLevel> LEVELS = Map.of(Level.ALL, LogLevel.TRACE, Level.TRACE, LogLevel.TRACE, Level.DEBUG, LogLevel.DEBUG, Level.INFO, LogLevel.INFO, Level.WARN, LogLevel.WARN, Level.ERROR, LogLevel.ERROR, Level.OFF, LogLevel.NONE);
    private static final List<Pattern> EXCLUDED_LOGGERS = List.of(Pattern.compile("^$"), Pattern.compile("^org|com|net$"), Pattern.compile("^jetbrains.*"), Pattern.compile("^org\\.apache.*"), Pattern.compile("^org\\.eclipse.*"), Pattern.compile("^org\\.glassfish.*"), Pattern.compile("^org\\.springframework.*"), Pattern.compile("^org\\.opensaml.*"), Pattern.compile("^software\\.amazon.*"));
    private final LogLevelChangeListener logLevelChangeListener;

    LevelChangeListener(LogLevelChangeListener logLevelChangeListener) {
        this.logLevelChangeListener = Objects.requireNonNull(logLevelChangeListener, "Listener required");
    }

    public static void registerLogbackListener(LogLevelChangeListener logLevelChangeListener) {
        LevelChangeListener levelChangeListener = new LevelChangeListener(logLevelChangeListener);
        ILoggerFactory loggerFactory = LoggerFactory.getILoggerFactory();
        if (loggerFactory instanceof LoggerContext) {
            LoggerContext loggerContext = (LoggerContext)loggerFactory;
            loggerContext.addListener((LoggerContextListener)levelChangeListener);
            levelChangeListener.onStart(loggerContext);
        }
    }

    public boolean isResetResistant() {
        return true;
    }

    public void onStart(LoggerContext loggerContext) {
        for (Logger logger : loggerContext.getLoggerList()) {
            this.onLevelChange(logger, logger.getEffectiveLevel());
        }
    }

    public void onReset(LoggerContext loggerContext) {
        this.onStart(loggerContext);
    }

    public void onStop(LoggerContext loggerContext) {
    }

    public void onLevelChange(Logger logger, Level level) {
        Objects.requireNonNull(level, "Level required");
        String loggerName = logger.getName();
        if (this.isLoggerSupported(loggerName)) {
            LogLevel logLevel = LEVELS.getOrDefault(level, LogLevel.WARN);
            this.logLevelChangeListener.onLevelChange(loggerName, logLevel);
        }
    }

    private boolean isLoggerSupported(String loggerName) {
        boolean supported = true;
        for (Pattern loggerPattern : EXCLUDED_LOGGERS) {
            Matcher matcher = loggerPattern.matcher(loggerName);
            if (!matcher.matches()) continue;
            supported = false;
            break;
        }
        return supported;
    }
}

