/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.py4j.client;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.nifi.py4j.client.JavaObjectBindings;
import org.apache.nifi.py4j.client.PythonProxyInvocationHandler;
import org.apache.nifi.python.PythonController;
import org.apache.nifi.python.PythonObjectProxy;
import org.apache.nifi.python.processor.PreserveJavaBinding;
import org.apache.nifi.python.processor.PythonProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import py4j.CallbackClient;
import py4j.Gateway;
import py4j.Py4JPythonClient;
import py4j.ReturnObject;
import py4j.reflection.PythonProxyHandler;

public class NiFiPythonGateway
extends Gateway {
    private static final Logger logger = LoggerFactory.getLogger(NiFiPythonGateway.class);
    private final JavaObjectBindings objectBindings;
    private final List<InvocationBindings> activeInvocations = new ArrayList<InvocationBindings>();
    private final ReturnObject END_OF_ITERATOR_OBJECT = ReturnObject.getErrorReturnObject((Throwable)new NoSuchElementException());
    private final Method freeMethod;
    private final Method pingMethod;

    public NiFiPythonGateway(JavaObjectBindings bindings, Object entryPoint, CallbackClient callbackClient) {
        super(entryPoint, (Py4JPythonClient)callbackClient);
        this.objectBindings = bindings;
        this.freeMethod = this.getMethod(PythonObjectProxy.class, "free");
        this.pingMethod = this.getMethod(PythonController.class, "ping");
    }

    private Method getMethod(Class<?> clazz, String methodName) {
        try {
            return clazz.getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException ignored) {
            return null;
        }
    }

    public JavaObjectBindings getObjectBindings() {
        return this.objectBindings;
    }

    public Object getObject(String objectId) {
        return this.objectBindings.getBoundObject(objectId);
    }

    public ReturnObject invoke(String methodName, String targetObjectId, List<Object> args) {
        boolean intervene = this.isNextOnExhaustedIterator(methodName, targetObjectId, args);
        if (!intervene) {
            return super.invoke(methodName, targetObjectId, args);
        }
        return this.END_OF_ITERATOR_OBJECT;
    }

    private boolean isNextOnExhaustedIterator(String methodName, String targetObjectId, List<Object> args) {
        if (!"next".equals(methodName)) {
            return false;
        }
        if (args != null && !args.isEmpty()) {
            return false;
        }
        Object targetObject = this.getObjectFromId(targetObjectId);
        if (!(targetObject instanceof Iterator)) {
            return false;
        }
        Iterator itr = (Iterator)targetObject;
        return !itr.hasNext();
    }

    public synchronized String putNewObject(Object object) {
        String objectId = this.objectBindings.bind(object, this.activeInvocations.size() + 1);
        for (InvocationBindings activeInvocation : this.activeInvocations) {
            activeInvocation.add(objectId);
        }
        logger.debug("Binding {}: {} ({})", new Object[]{objectId, object, object == null ? "null" : object.getClass().getName()});
        return objectId;
    }

    public synchronized Object putObject(String id, Object object) {
        this.objectBindings.bind(id, object, this.activeInvocations.size() + 1);
        logger.debug("Binding {}: {} ({})", new Object[]{id, object, object == null ? "null" : object.getClass().getName()});
        return super.putObject(id, object);
    }

    public void deleteObject(String objectId) {
        logger.debug("Unbinding {} because it was explicitly requested from Python side", (Object)objectId);
        this.objectBindings.unbind(objectId);
    }

    protected PythonProxyHandler createPythonProxyHandler(String id) {
        logger.debug("Creating Python Proxy Handler for ID {}", (Object)id);
        final PythonProxyInvocationHandler createdHandler = new PythonProxyInvocationHandler(this, id);
        return new PythonProxyHandler(id, this){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (Objects.equals(NiFiPythonGateway.this.freeMethod, method)) {
                    createdHandler.free();
                    return null;
                }
                return createdHandler.invoke(proxy, method, args);
            }
        };
    }

    public synchronized InvocationBindings beginInvocation(String objectId, Method method, Object[] args) {
        boolean unbind = this.isUnbind(method);
        InvocationBindings bindings = new InvocationBindings(objectId, method, args, unbind);
        if (!this.pingMethod.equals(method)) {
            this.activeInvocations.add(bindings);
        }
        logger.debug("Beginning method invocation {}", (Object)bindings);
        return bindings;
    }

    public synchronized void endInvocation(InvocationBindings invocationBindings) {
        String methodName = invocationBindings.getMethod().getName();
        logger.debug("Ending method invocation {}", (Object)invocationBindings);
        String objectId = invocationBindings.getTargetObjectId();
        this.activeInvocations.remove(invocationBindings);
        invocationBindings.getObjectIds().forEach(id -> {
            Object unbound = this.objectBindings.unbind((String)id);
            if (logger.isDebugEnabled()) {
                logger.debug("Unbinding {}: {} because invocation of {} on {} with args {} has completed", new Object[]{id, unbound, methodName, objectId, Arrays.toString(invocationBindings.getArgs())});
            }
        });
    }

    protected boolean isUnbind(Method method) {
        boolean relevantClass;
        Class<?> declaringClass = method.getDeclaringClass();
        boolean bl = relevantClass = PythonController.class.isAssignableFrom(declaringClass) || PythonProcessor.class.isAssignableFrom(declaringClass);
        if (relevantClass && method.getAnnotation(PreserveJavaBinding.class) == null) {
            boolean bindNecessary = this.isBindNecessary(method.getReturnType());
            for (Class<?> parameterType : method.getParameterTypes()) {
                if (!this.isBindNecessary(parameterType)) continue;
                bindNecessary = true;
                break;
            }
            return bindNecessary;
        }
        return false;
    }

    private boolean isBindNecessary(Class<?> type) {
        return !type.isPrimitive() && type != String.class && type != byte[].class;
    }

    public static class InvocationBindings {
        private final String targetObjectId;
        private final Method method;
        private final Object[] args;
        private final boolean unbind;
        private final List<String> objectIds = new ArrayList<String>();

        public InvocationBindings(String targetObjectId, Method method, Object[] args, boolean unbind) {
            this.targetObjectId = targetObjectId;
            this.method = method;
            this.args = args;
            this.unbind = unbind;
        }

        public boolean isUnbind() {
            return this.unbind;
        }

        public void add(String objectId) {
            this.objectIds.add(objectId);
        }

        public List<String> getObjectIds() {
            return this.objectIds;
        }

        public String getTargetObjectId() {
            return this.targetObjectId;
        }

        public Method getMethod() {
            return this.method;
        }

        public Object[] getArgs() {
            return this.args;
        }

        public String toString() {
            return "InvocationBindings[method=" + String.valueOf(this.method) + ", target=" + this.targetObjectId + ", args=" + Arrays.toString(this.args) + "]";
        }
    }
}

