/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.py4j.client;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.py4j.client.JavaObjectBindings;
import py4j.Protocol;
import py4j.StringUtil;
import py4j.reflection.ReflectionEngine;

public class CommandBuilder {
    private static final String VOID_ARGUMENT_LINE = String.valueOf('v');
    public static final String METHOD_INVOCATION_START_CLAUSE = "c\n";
    public static final String METHOD_INVOCATION_END_CLAUSE = "e\n";
    private final JavaObjectBindings bindings;
    private final List<String> boundIds = new ArrayList<String>();
    private final String objectId;
    private final String methodName;

    public CommandBuilder(JavaObjectBindings bindings, String objectId, String methodName) {
        this.bindings = bindings;
        this.objectId = objectId;
        this.methodName = methodName;
    }

    public String buildCommand(Object[] args) {
        StringBuilder sb = new StringBuilder();
        sb.append(METHOD_INVOCATION_START_CLAUSE);
        sb.append(this.objectId).append("\n");
        sb.append(this.methodName).append("\n");
        if (args != null) {
            for (Object arg : args) {
                String argumentLine = this.getArgumentLine(arg);
                sb.append(argumentLine).append("\n");
            }
        }
        sb.append(METHOD_INVOCATION_END_CLAUSE);
        return sb.toString();
    }

    private String getArgumentLine(Object arg) {
        if (arg == null) {
            return "n";
        }
        if (arg instanceof String || arg instanceof Character) {
            return "s" + StringUtil.escape((String)arg.toString());
        }
        if (arg instanceof byte[]) {
            return "j" + Protocol.encodeBytes((byte[])((byte[])arg));
        }
        if (arg instanceof Long) {
            return "L" + arg.toString();
        }
        if (arg instanceof Double || arg instanceof Float) {
            return "d" + arg.toString();
        }
        if (arg instanceof Boolean) {
            return "b" + arg.toString();
        }
        if (arg instanceof Integer || arg instanceof Short || arg instanceof Byte) {
            return "i" + arg.toString();
        }
        if (arg == ReflectionEngine.RETURN_VOID) {
            return VOID_ARGUMENT_LINE;
        }
        if (arg instanceof BigDecimal) {
            return "D" + ((BigDecimal)arg).toPlainString();
        }
        if (arg instanceof List) {
            String listId = this.bind(arg);
            return "l" + listId;
        }
        if (arg instanceof Map) {
            String mapId = this.bind(arg);
            return "a" + mapId;
        }
        if (arg.getClass().isArray()) {
            String arrayId = this.bind(arg);
            return "t" + arrayId;
        }
        if (arg instanceof Set) {
            String setId = this.bind(arg);
            return "h" + setId;
        }
        if (arg instanceof Iterator) {
            String iteratorId = this.bind(arg);
            return "g" + iteratorId;
        }
        String objectId = this.bind(arg);
        return "r" + objectId;
    }

    private String bind(Object value) {
        String objectId = this.bindings.bind(value, 1);
        this.boundIds.add(objectId);
        return objectId;
    }

    public List<String> getBoundIds() {
        return this.boundIds;
    }

    public String toString() {
        return "CommandBuilder[objectId=" + this.objectId + ", methodName=" + this.methodName + ", boundIds=" + this.boundIds.size() + "]";
    }
}

