/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.py4j;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.stream.Collectors;
import org.apache.nifi.py4j.logging.PythonLogLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PythonProcessLogReader
implements Runnable {
    private static final int LOG_LEVEL_BEGIN_INDEX = 0;
    private static final int LOG_LEVEL_END_INDEX = 2;
    private static final int MESSAGE_BEGIN_INDEX = 3;
    private static final char NAME_MESSAGE_SEPARATOR = ':';
    private static final int MINIMUM_LOGGER_NAME_INDEX = 3;
    private static final String LOG_PREFIX = "PY4JLOG";
    private static final int PREFIXED_LOG_LEVEL_BEGIN_INDEX = 8;
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private static final Map<String, PythonLogLevel> PYTHON_LOG_LEVELS = Arrays.stream(PythonLogLevel.values()).collect(Collectors.toUnmodifiableMap(pythonLogLevel -> Integer.toString(pythonLogLevel.getLevel()), pythonLogLevel -> pythonLogLevel));
    private final Logger processLogger = LoggerFactory.getLogger((String)"org.apache.nifi.py4j.ProcessLog");
    private final BufferedReader processReader;

    PythonProcessLogReader(BufferedReader processReader) {
        this.processReader = Objects.requireNonNull(processReader, "Reader required");
    }

    @Override
    public void run() {
        ArrayDeque<ParsedRecord> parsedRecords = new ArrayDeque<ParsedRecord>();
        try {
            String line = this.processReader.readLine();
            while (line != null) {
                try {
                    ParsedRecord parsedRecord;
                    this.processLine(line, parsedRecords);
                    if (parsedRecords.size() == 2) {
                        parsedRecord = (ParsedRecord)parsedRecords.remove();
                        this.log(parsedRecord);
                    }
                    if (!this.processReader.ready()) {
                        while (!parsedRecords.isEmpty()) {
                            parsedRecord = (ParsedRecord)parsedRecords.poll();
                            this.log(parsedRecord);
                        }
                    }
                }
                catch (Exception e) {
                    this.processLogger.error("Failed to handle log from Python Process", (Throwable)e);
                }
                line = this.processReader.readLine();
            }
        }
        catch (IOException e) {
            this.processLogger.error("Failed to read output of Python Process", (Throwable)e);
        }
        for (ParsedRecord parsedRecord : parsedRecords) {
            this.log(parsedRecord);
        }
    }

    private void processLine(String line, Queue<ParsedRecord> parsedRecords) {
        int logPrefixIndex = line.indexOf(LOG_PREFIX);
        if (logPrefixIndex == 0) {
            String message;
            Logger logger;
            String levelLogLine = line.substring(8);
            String levelNumber = levelLogLine.substring(0, 2);
            PythonLogLevel logLevel = PYTHON_LOG_LEVELS.getOrDefault(levelNumber, PythonLogLevel.NOTSET);
            String loggerMessage = levelLogLine.substring(3);
            int nameSeparatorIndex = loggerMessage.indexOf(58);
            if (nameSeparatorIndex < 3) {
                logger = this.processLogger;
                message = loggerMessage;
            } else {
                String loggerName = loggerMessage.substring(0, nameSeparatorIndex);
                logger = LoggerFactory.getLogger((String)loggerName);
                int messageBeginIndex = nameSeparatorIndex + 1;
                message = loggerMessage.substring(messageBeginIndex);
            }
            StringBuilder buffer = new StringBuilder(message);
            ParsedRecord parsedRecord = new ParsedRecord(logLevel, logger, buffer);
            parsedRecords.add(parsedRecord);
        } else {
            ParsedRecord lastRecord = parsedRecords.peek();
            if (lastRecord == null) {
                StringBuilder buffer = new StringBuilder(line);
                ParsedRecord parsedRecord = new ParsedRecord(PythonLogLevel.INFO, this.processLogger, buffer);
                parsedRecords.add(parsedRecord);
            } else if (!line.isEmpty()) {
                lastRecord.buffer.append(LINE_SEPARATOR);
                lastRecord.buffer.append(line);
            }
        }
    }

    private void log(ParsedRecord parsedRecord) {
        PythonLogLevel logLevel = parsedRecord.level;
        Logger logger = parsedRecord.logger;
        String message = parsedRecord.buffer.toString();
        if (PythonLogLevel.DEBUG == logLevel) {
            logger.debug(message);
        } else if (PythonLogLevel.INFO == logLevel) {
            logger.info(message);
        } else if (PythonLogLevel.WARNING == logLevel) {
            logger.warn(message);
        } else if (PythonLogLevel.ERROR == logLevel) {
            logger.error(message);
        } else if (PythonLogLevel.CRITICAL == logLevel) {
            logger.error(message);
        } else {
            logger.warn(message);
        }
    }

    private record ParsedRecord(PythonLogLevel level, Logger logger, StringBuilder buffer) {
    }
}

