/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.python.processor;

import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.python.processor.FlowFileTransform;
import org.apache.nifi.python.processor.FlowFileTransformResult;
import org.apache.nifi.python.processor.PythonProcessorBridge;
import org.apache.nifi.python.processor.PythonProcessorProxy;
import org.apache.nifi.python.processor.StandardInputFlowFile;
import py4j.Py4JNetworkException;

@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
public class FlowFileTransformProxy
extends PythonProcessorProxy<FlowFileTransform> {
    public FlowFileTransformProxy(String processorType, Supplier<PythonProcessorBridge> bridgeFactory, boolean initialize) {
        super(processorType, bridgeFactory, initialize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFileTransformResult result;
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        try (StandardInputFlowFile inputFlowFile = new StandardInputFlowFile(session, flowFile);){
            result = ((FlowFileTransform)this.getTransform()).transformFlowFile(inputFlowFile);
        }
        catch (Py4JNetworkException e) {
            throw new ProcessException("Failed to communicate with Python Process", (Throwable)e);
        }
        catch (Exception e) {
            this.getLogger().error("Failed to transform {}", new Object[]{flowFile, e});
            session.transfer(flowFile, REL_FAILURE);
            return;
        }
        try {
            byte[] contents;
            String relationshipName = result.getRelationship();
            Relationship relationship = new Relationship.Builder().name(relationshipName).build();
            Map<String, String> attributes = result.getAttributes();
            if (REL_FAILURE.getName().equals(relationshipName)) {
                if (attributes != null) {
                    flowFile = session.putAllAttributes(flowFile, attributes);
                }
                session.transfer(flowFile, REL_FAILURE);
                return;
            }
            Optional<Object> clone = context.isAutoTerminated(REL_ORIGINAL) ? Optional.empty() : Optional.of(session.clone(flowFile));
            if (attributes != null) {
                flowFile = session.putAllAttributes(flowFile, attributes);
            }
            if ((contents = result.getContents()) != null) {
                flowFile = session.write(flowFile, out -> out.write(contents));
            }
            session.transfer(flowFile, relationship);
            if (clone.isPresent()) {
                session.transfer((FlowFile)clone.get(), REL_ORIGINAL);
            }
        }
        finally {
            result.free();
        }
    }
}

