/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.py4j.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Collections;
import java.util.List;
import javax.net.ServerSocketFactory;
import org.apache.nifi.py4j.server.NiFiGatewayConnection;
import py4j.Gateway;
import py4j.GatewayServer;
import py4j.Py4JServerConnection;
import py4j.commands.Command;

public class NiFiGatewayServer
extends GatewayServer {
    private volatile boolean shutdown = false;
    private volatile boolean startProcessForked = false;
    private final String componentType;
    private final String componentId;
    private final String authToken;
    private final ClassLoader contextClassLoader;

    public NiFiGatewayServer(Gateway gateway, int port, InetAddress address, int connectTimeout, int readTimeout, List<Class<? extends Command>> customCommands, ServerSocketFactory sSocketFactory, String authToken, String componentType, String componentId) {
        super(gateway, port, address, connectTimeout, readTimeout, customCommands, sSocketFactory);
        this.componentType = componentType;
        this.componentId = componentId;
        this.authToken = authToken;
        this.contextClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
    }

    protected Py4JServerConnection createConnection(Gateway gateway, Socket socket) throws IOException {
        NiFiGatewayConnection connection = new NiFiGatewayConnection(this, gateway, socket, this.authToken, Collections.emptyList(), this.getListeners());
        connection.startConnection();
        return connection;
    }

    public void shutdown(boolean shutdownCallbackClient) {
        this.shutdown = true;
        super.shutdown(shutdownCallbackClient);
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    public void start(boolean fork) {
        this.startProcessForked = fork;
        super.start(fork);
    }

    public void run() {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.contextClassLoader);
            if (this.startProcessForked) {
                Thread.currentThread().setName("NiFiGatewayServer Thread for " + this.componentType + " " + this.componentId);
            }
            super.run();
        }
        finally {
            if (originalClassLoader != null) {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
        }
    }

    public String toString() {
        return "NiFiGatewayServer[shutdown=" + this.shutdown + ", forked=" + this.startProcessForked + ", componentType=" + this.componentType + ", componentId=" + this.componentId + "]";
    }

    public String getComponentId() {
        return this.componentId;
    }

    public String getComponentType() {
        return this.componentType;
    }
}

