/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.py4j.server;

import java.io.IOException;
import java.net.Socket;
import java.util.List;
import org.apache.nifi.py4j.server.NiFiGatewayServer;
import py4j.Gateway;
import py4j.GatewayConnection;
import py4j.GatewayServerListener;
import py4j.commands.Command;

public class NiFiGatewayConnection
extends GatewayConnection {
    private final NiFiGatewayServer gatewayServer;
    private final ClassLoader contextClassLoader;

    public NiFiGatewayConnection(NiFiGatewayServer gatewayServer, Gateway gateway, Socket socket, String authToken, List<Class<? extends Command>> customCommands, List<GatewayServerListener> listeners) throws IOException {
        super(gateway, socket, authToken, customCommands, listeners);
        this.gatewayServer = gatewayServer;
        this.contextClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
    }

    public void run() {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.contextClassLoader);
            Thread.currentThread().setName(String.format("NiFiGatewayConnection Thread for %s %s", this.gatewayServer.getComponentType(), this.gatewayServer.getComponentId()));
            super.run();
            this.shutdown(false);
        }
        finally {
            if (originalClassLoader != null) {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
        }
    }
}

