/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.py4j.logging;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.nifi.logging.LogLevel;
import org.apache.nifi.py4j.logging.LogLevelChangeHandler;
import org.apache.nifi.py4j.logging.LogLevelChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardLogLevelChangeHandler
implements LogLevelChangeHandler {
    private static final StandardLogLevelChangeHandler HANDLER = new StandardLogLevelChangeHandler();
    private static final Logger handlerLogger = LoggerFactory.getLogger(StandardLogLevelChangeHandler.class);
    private final Map<String, LogLevelChangeListener> listeners = new ConcurrentHashMap<String, LogLevelChangeListener>();
    private final Map<String, LogLevel> loggerLevels = new ConcurrentHashMap<String, LogLevel>();

    private StandardLogLevelChangeHandler() {
    }

    public static LogLevelChangeHandler getHandler() {
        return HANDLER;
    }

    @Override
    public void addListener(String identifier, LogLevelChangeListener listener) {
        Objects.requireNonNull(identifier, "Identifier required");
        Objects.requireNonNull(listener, "Listener required");
        for (Map.Entry<String, LogLevel> loggerLevel : this.loggerLevels.entrySet()) {
            listener.onLevelChange(loggerLevel.getKey(), loggerLevel.getValue());
        }
        this.listeners.put(identifier, listener);
        handlerLogger.trace("Added Listener [{}]", (Object)identifier);
    }

    @Override
    public void removeListener(String identifier) {
        Objects.requireNonNull(identifier, "Identifier required");
        this.listeners.remove(identifier);
        handlerLogger.trace("Removed Listener [{}]", (Object)identifier);
    }

    @Override
    public void onLevelChange(String loggerName, LogLevel logLevel) {
        Objects.requireNonNull(loggerName, "Logger Name required");
        Objects.requireNonNull(logLevel, "Log Level required");
        handlerLogger.trace("Logger [{}] Level [{}] changed", (Object)loggerName, (Object)logLevel);
        this.loggerLevels.put(loggerName, logLevel);
        for (LogLevelChangeListener listener : this.listeners.values()) {
            listener.onLevelChange(loggerName, logLevel);
        }
    }
}

