/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.services.protobuf;

import com.squareup.wire.schema.Schema;
import java.io.IOException;
import java.io.InputStream;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.services.protobuf.converter.ProtobufDataConverter;

public class ProtobufRecordReader
implements RecordReader {
    private final Schema protoSchema;
    private final String messageType;
    private final InputStream inputStream;
    private RecordSchema recordSchema;
    private boolean inputProcessed;

    public ProtobufRecordReader(Schema protoSchema, String messageType, InputStream inputStream, RecordSchema recordSchema) {
        this.protoSchema = protoSchema;
        this.messageType = messageType;
        this.inputStream = inputStream;
        this.recordSchema = recordSchema;
    }

    public Record nextRecord(boolean coerceTypes, boolean dropUnknownFields) throws IOException {
        if (!this.inputProcessed) {
            ProtobufDataConverter dataConverter = new ProtobufDataConverter(this.protoSchema, this.messageType, this.recordSchema, coerceTypes, dropUnknownFields);
            MapRecord record = dataConverter.createRecord(this.inputStream);
            this.inputProcessed = true;
            this.recordSchema = record.getSchema();
            return record;
        }
        return null;
    }

    public RecordSchema getSchema() {
        return this.recordSchema;
    }

    public void close() throws IOException {
        this.inputStream.close();
    }
}

