/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.services.protobuf;

import java.util.Arrays;

public enum FieldType {
    DOUBLE("double"),
    FLOAT("float"),
    INT32("int32"),
    INT64("int64"),
    UINT32("uint32"),
    UINT64("uint64"),
    SINT32("sint32"),
    SINT64("sint64"),
    FIXED32("fixed32"),
    FIXED64("fixed64"),
    SFIXED32("sfixed32"),
    SFIXED64("sfixed64"),
    BOOL("bool"),
    STRING("string"),
    BYTES("bytes");

    private final String type;

    private FieldType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public static FieldType findValue(String value) {
        return Arrays.stream(FieldType.values()).filter(type -> type.getType().equalsIgnoreCase(value)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("ProtoType [%s] not found", value)));
    }
}

