/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.pgp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.pgp.service.api.PGPPublicKeyService;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.io.StreamCallback;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.pgp.DecryptContentPGP;
import org.apache.nifi.processors.pgp.SignContentPGP;
import org.apache.nifi.processors.pgp.VerifyContentPGP;
import org.apache.nifi.processors.pgp.attributes.CompressionAlgorithm;
import org.apache.nifi.processors.pgp.attributes.FileEncoding;
import org.apache.nifi.processors.pgp.attributes.SymmetricKeyAlgorithm;
import org.apache.nifi.processors.pgp.exception.PGPEncryptionException;
import org.apache.nifi.processors.pgp.io.EncodingStreamCallback;
import org.apache.nifi.stream.io.StreamUtils;
import org.apache.nifi.util.StringUtils;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.Packet;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.bc.BcPGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPublicKeyKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.jcajce.JcePBEKeyEncryptionMethodGenerator;

@SideEffectFree
@SupportsBatching
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"PGP", "GPG", "OpenPGP", "Encryption", "RFC 4880"})
@CapabilityDescription(value="Encrypt contents using OpenPGP. The processor reads input and detects OpenPGP messages to avoid unnecessary additional wrapping in Literal Data packets.")
@SeeAlso(value={DecryptContentPGP.class, SignContentPGP.class, VerifyContentPGP.class})
@WritesAttributes(value={@WritesAttribute(attribute="pgp.symmetric.key.algorithm", description="Symmetric-Key Algorithm"), @WritesAttribute(attribute="pgp.symmetric.key.algorithm.block.cipher", description="Symmetric-Key Algorithm Block Cipher"), @WritesAttribute(attribute="pgp.symmetric.key.algorithm.key.size", description="Symmetric-Key Algorithm Key Size"), @WritesAttribute(attribute="pgp.symmetric.key.algorithm.id", description="Symmetric-Key Algorithm Identifier"), @WritesAttribute(attribute="pgp.file.encoding", description="File Encoding"), @WritesAttribute(attribute="pgp.compression.algorithm", description="Compression Algorithm"), @WritesAttribute(attribute="pgp.compression.algorithm.id", description="Compression Algorithm Identifier")})
public class EncryptContentPGP
extends AbstractProcessor {
    public static final Relationship SUCCESS = new Relationship.Builder().name("success").description("Encryption Succeeded").build();
    public static final Relationship FAILURE = new Relationship.Builder().name("failure").description("Encryption Failed").build();
    public static final PropertyDescriptor SYMMETRIC_KEY_ALGORITHM = new PropertyDescriptor.Builder().name("symmetric-key-algorithm").displayName("Symmetric-Key Algorithm").description("Symmetric-Key Algorithm for encryption").required(true).defaultValue(SymmetricKeyAlgorithm.AES_256.toString()).allowableValues((Enum[])SymmetricKeyAlgorithm.values()).build();
    public static final PropertyDescriptor FILE_ENCODING = new PropertyDescriptor.Builder().name("file-encoding").displayName("File Encoding").description("File Encoding for encryption").required(true).defaultValue(FileEncoding.BINARY.toString()).allowableValues((Enum[])FileEncoding.values()).build();
    public static final PropertyDescriptor PASSPHRASE = new PropertyDescriptor.Builder().name("passphrase").displayName("Passphrase").description("Passphrase used for encrypting data with Password-Based Encryption").sensitive(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor PUBLIC_KEY_SERVICE = new PropertyDescriptor.Builder().name("public-key-service").displayName("Public Key Service").description("PGP Public Key Service for encrypting data with Public Key Encryption").identifiesControllerService(PGPPublicKeyService.class).build();
    public static final PropertyDescriptor PUBLIC_KEY_SEARCH = new PropertyDescriptor.Builder().name("public-key-search").displayName("Public Key Search").description("PGP Public Key Search will be used to match against the User ID or Key ID when formatted as uppercase hexadecimal string of 16 characters").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_EL_VALIDATOR).dependsOn(PUBLIC_KEY_SERVICE, new AllowableValue[0]).build();
    private static final boolean ENCRYPTION_INTEGRITY_PACKET_ENABLED = true;
    private static final CompressionAlgorithm COMPRESSION_DISABLED = CompressionAlgorithm.UNCOMPRESSED;
    private static final Set<Relationship> RELATIONSHIPS = Set.of(SUCCESS, FAILURE);
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(SYMMETRIC_KEY_ALGORITHM, FILE_ENCODING, PASSPHRASE, PUBLIC_KEY_SERVICE, PUBLIC_KEY_SEARCH);

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    public final List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        try {
            SymmetricKeyAlgorithm symmetricKeyAlgorithm = this.getSymmetricKeyAlgorithm(context);
            FileEncoding fileEncoding = this.getFileEncoding(context);
            StreamCallback callback = this.getEncryptStreamCallback(context, flowFile, symmetricKeyAlgorithm, fileEncoding);
            flowFile = session.write(flowFile, callback);
            Map<String, String> attributes = this.getAttributes(symmetricKeyAlgorithm, fileEncoding);
            flowFile = session.putAllAttributes(flowFile, attributes);
            session.transfer(flowFile, SUCCESS);
        }
        catch (RuntimeException e) {
            this.getLogger().error("Encryption Failed {}", new Object[]{flowFile, e});
            session.transfer(flowFile, FAILURE);
        }
    }

    protected Collection<ValidationResult> customValidate(ValidationContext context) {
        ValidationResult result;
        PGPPublicKeyService publicKeyService;
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        String passphrase = context.getProperty(PASSPHRASE).getValue();
        if (StringUtils.isBlank((String)passphrase) && (publicKeyService = (PGPPublicKeyService)context.getProperty(PUBLIC_KEY_SERVICE).asControllerService(PGPPublicKeyService.class)) == null) {
            String explanation = String.format("Neither [%s] nor [%s] configured", PASSPHRASE.getDisplayName(), PUBLIC_KEY_SERVICE.getDisplayName());
            ValidationResult result2 = new ValidationResult.Builder().valid(false).subject(((Object)((Object)this)).getClass().getSimpleName()).explanation(explanation).build();
            results.add(result2);
        }
        if (context.getProperty(PUBLIC_KEY_SERVICE).isSet()) {
            result = new ValidationResult.Builder().valid(context.getProperty(PUBLIC_KEY_SEARCH).isSet()).subject(PUBLIC_KEY_SERVICE.getDisplayName()).explanation(String.format("[%s] requires [%s]", PUBLIC_KEY_SERVICE.getDisplayName(), PUBLIC_KEY_SEARCH.getDisplayName())).build();
            results.add(result);
        }
        if (context.getProperty(PUBLIC_KEY_SEARCH).isSet()) {
            result = new ValidationResult.Builder().valid(context.getProperty(PUBLIC_KEY_SERVICE).isSet()).subject(PUBLIC_KEY_SERVICE.getDisplayName()).explanation(String.format("[%s] requires [%s]", PUBLIC_KEY_SEARCH.getDisplayName(), PUBLIC_KEY_SERVICE.getDisplayName())).build();
            results.add(result);
        }
        return results;
    }

    private StreamCallback getEncryptStreamCallback(ProcessContext context, FlowFile flowFile, SymmetricKeyAlgorithm symmetricKeyAlgorithm, FileEncoding fileEncoding) {
        SecureRandom secureRandom = new SecureRandom();
        BcPGPDataEncryptorBuilder dataEncryptorBuilder = new BcPGPDataEncryptorBuilder(symmetricKeyAlgorithm.getId()).setSecureRandom(secureRandom).setWithIntegrityPacket(true);
        PGPEncryptedDataGenerator encryptedDataGenerator = new PGPEncryptedDataGenerator((PGPDataEncryptorBuilder)dataEncryptorBuilder);
        List<PGPKeyEncryptionMethodGenerator> methodGenerators = this.getEncryptionMethodGenerators(context, flowFile, secureRandom);
        methodGenerators.forEach(arg_0 -> ((PGPEncryptedDataGenerator)encryptedDataGenerator).addMethod(arg_0));
        String filename = flowFile.getAttribute(CoreAttributes.FILENAME.key());
        return new EncryptStreamCallback(fileEncoding, filename, this.getLogger(), encryptedDataGenerator);
    }

    private List<PGPKeyEncryptionMethodGenerator> getEncryptionMethodGenerators(ProcessContext context, FlowFile flowFile, SecureRandom secureRandom) {
        PGPPublicKeyService publicKeyService;
        String publicKeySearch;
        ArrayList<PGPKeyEncryptionMethodGenerator> generators = new ArrayList<PGPKeyEncryptionMethodGenerator>();
        PropertyValue passphraseProperty = context.getProperty(PASSPHRASE);
        if (passphraseProperty.isSet()) {
            char[] passphrase = passphraseProperty.getValue().toCharArray();
            generators.add((PGPKeyEncryptionMethodGenerator)new JcePBEKeyEncryptionMethodGenerator(passphrase).setSecureRandom(secureRandom));
        }
        String string = publicKeySearch = (publicKeyService = (PGPPublicKeyService)context.getProperty(PUBLIC_KEY_SERVICE).asControllerService(PGPPublicKeyService.class)) == null ? null : context.getProperty(PUBLIC_KEY_SEARCH).evaluateAttributeExpressions(flowFile).getValue();
        if (StringUtils.isNotBlank(publicKeySearch)) {
            this.getLogger().debug("Public Key Search [{}]", new Object[]{publicKeySearch});
            Optional optionalPublicKey = publicKeyService.findPublicKey(publicKeySearch);
            if (optionalPublicKey.isPresent()) {
                PGPPublicKey publicKey = (PGPPublicKey)optionalPublicKey.get();
                generators.add((PGPKeyEncryptionMethodGenerator)new BcPublicKeyKeyEncryptionMethodGenerator(publicKey).setSecureRandom(secureRandom));
            } else {
                throw new PGPEncryptionException(String.format("Public Key not found using search [%s]", publicKeySearch));
            }
        }
        return generators;
    }

    private SymmetricKeyAlgorithm getSymmetricKeyAlgorithm(ProcessContext context) {
        String algorithm = context.getProperty(SYMMETRIC_KEY_ALGORITHM).getValue();
        return SymmetricKeyAlgorithm.valueOf(algorithm);
    }

    private FileEncoding getFileEncoding(ProcessContext context) {
        String encoding = context.getProperty(FILE_ENCODING).getValue();
        return FileEncoding.valueOf(encoding);
    }

    private Map<String, String> getAttributes(SymmetricKeyAlgorithm symmetricKeyAlgorithm, FileEncoding fileEncoding) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("pgp.symmetric.key.algorithm", symmetricKeyAlgorithm.toString());
        attributes.put("pgp.symmetric.key.algorithm.block.cipher", symmetricKeyAlgorithm.getBlockCipher().toString());
        attributes.put("pgp.symmetric.key.algorithm.key.size", Integer.toString(symmetricKeyAlgorithm.getKeySize()));
        attributes.put("pgp.symmetric.key.algorithm.id", Integer.toString(symmetricKeyAlgorithm.getId()));
        attributes.put("pgp.file.encoding", fileEncoding.toString());
        attributes.put("pgp.compression.algorithm", COMPRESSION_DISABLED.toString());
        attributes.put("pgp.compression.algorithm.id", Integer.toString(COMPRESSION_DISABLED.getId()));
        return attributes;
    }

    private static class EncryptStreamCallback
    extends EncodingStreamCallback {
        private static final Set<Integer> PACKAGED_PACKET_TAGS = Set.of(Integer.valueOf(4), Integer.valueOf(8), Integer.valueOf(11));
        private final PGPEncryptedDataGenerator encryptedDataGenerator;
        private final ComponentLog logger;

        public EncryptStreamCallback(FileEncoding fileEncoding, String filename, ComponentLog logger, PGPEncryptedDataGenerator encryptedDataGenerator) {
            super(fileEncoding, COMPRESSION_DISABLED, filename);
            this.logger = logger;
            this.encryptedDataGenerator = encryptedDataGenerator;
        }

        @Override
        protected void processEncoding(InputStream inputStream, OutputStream encodingOutputStream) throws IOException, PGPException {
            try (PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, 8192);
                 OutputStream encryptedOutputStream = this.encryptedDataGenerator.open(encodingOutputStream, this.createOutputBuffer());){
                if (this.isPacketFound(pushbackInputStream)) {
                    StreamUtils.copy((InputStream)pushbackInputStream, (OutputStream)encryptedOutputStream);
                } else {
                    super.processEncoding(pushbackInputStream, encryptedOutputStream);
                }
            }
            this.encryptedDataGenerator.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isPacketFound(PushbackInputStream pushbackInputStream) throws IOException {
            boolean packetFound = false;
            byte[] buffer = new byte[8192];
            int bytesRead = StreamUtils.fillBuffer((InputStream)pushbackInputStream, (byte[])buffer, (boolean)false);
            this.logger.debug("PGP Packet search read buffer bytes [{}]", new Object[]{bytesRead});
            try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(buffer);
                 InputStream decodedInputStream = PGPUtil.getDecoderStream((InputStream)byteArrayInputStream);
                 BCPGInputStream packetInputStream = new BCPGInputStream(decodedInputStream);){
                Packet packet = packetInputStream.readPacket();
                if (packet == null) {
                    this.logger.debug("PGP Packet not found");
                } else {
                    int packetTag = packet.getPacketTag();
                    this.logger.debug("PGP Packet Tag [{}] read", new Object[]{packetTag});
                    packetFound = PACKAGED_PACKET_TAGS.contains(packetTag);
                }
            }
            catch (Exception e) {
                this.logger.debug("PGP Packet read failed", (Throwable)e);
            }
            finally {
                pushbackInputStream.unread(buffer, 0, bytesRead);
            }
            return packetFound;
        }
    }
}

