/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance.store;

import java.util.concurrent.TimeUnit;
import org.apache.nifi.provenance.serialization.RecordWriter;
import org.apache.nifi.provenance.store.RolloverState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordWriterLease {
    private final Logger logger = LoggerFactory.getLogger(RecordWriterLease.class);
    private final RecordWriter writer;
    private final long maxBytes;
    private final int maxEvents;
    private final long maxSystemTime;
    private long usageCounter;
    private RolloverState rolloverState = RolloverState.SHOULD_NOT_ROLLOVER;
    private boolean closed = false;

    public RecordWriterLease(RecordWriter writer, long maxBytes, int maxEvents, long maxMillis) {
        this.writer = writer;
        this.maxBytes = maxBytes;
        this.maxEvents = maxEvents;
        this.maxSystemTime = System.currentTimeMillis() + Math.min(maxMillis, Integer.MAX_VALUE - TimeUnit.HOURS.toMillis(1L));
    }

    public RecordWriter getWriter() {
        return this.writer;
    }

    public synchronized boolean tryClaim() {
        if (this.rolloverState.isRollover()) {
            return false;
        }
        if (this.determineRolloverReason().isRollover()) {
            return false;
        }
        ++this.usageCounter;
        return true;
    }

    public synchronized void relinquishClaim() {
        --this.usageCounter;
        if (this.closed && this.usageCounter < 1L) {
            try {
                this.writer.close();
            }
            catch (Exception e) {
                this.logger.warn("Failed to close {}", (Object)this.writer, (Object)e);
            }
        }
    }

    private synchronized RolloverState determineRolloverReason() {
        if (this.writer.isClosed()) {
            return RolloverState.WRITER_ALREADY_CLOSED;
        }
        if (this.writer.isDirty()) {
            return RolloverState.WRITER_IS_DIRTY;
        }
        if (this.writer.getBytesWritten() >= this.maxBytes) {
            return RolloverState.MAX_BYTES_REACHED;
        }
        int recordsWritten = this.writer.getRecordsWritten();
        if (recordsWritten >= this.maxEvents) {
            return RolloverState.MAX_EVENTS_REACHED;
        }
        if (recordsWritten > 0 && System.currentTimeMillis() >= this.maxSystemTime) {
            return RolloverState.MAX_TIME_REACHED;
        }
        return RolloverState.SHOULD_NOT_ROLLOVER;
    }

    public synchronized RolloverState getRolloverState() {
        if (this.rolloverState.isRollover()) {
            return this.rolloverState;
        }
        if (this.usageCounter < 1L) {
            this.rolloverState = this.determineRolloverReason();
            return this.rolloverState;
        }
        return RolloverState.SHOULD_NOT_ROLLOVER;
    }

    public synchronized void close() {
        this.closed = true;
        if (this.usageCounter < 1L) {
            try {
                this.writer.close();
            }
            catch (Exception e) {
                this.logger.warn("Failed to close {}", (Object)this.writer, (Object)e);
            }
        }
    }

    public String toString() {
        return super.toString() + "[" + String.valueOf(this.writer.getFile()) + "]";
    }
}

