/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance.store;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.apache.lucene.util.NamedThreadFactory;
import org.apache.nifi.events.EventReporter;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.RepositoryConfiguration;
import org.apache.nifi.provenance.authorization.EventAuthorizer;
import org.apache.nifi.provenance.authorization.EventTransformer;
import org.apache.nifi.provenance.store.EventStore;
import org.apache.nifi.provenance.store.EventStorePartition;
import org.apache.nifi.provenance.store.StorageResult;
import org.apache.nifi.provenance.store.iterator.AuthorizingEventIterator;
import org.apache.nifi.provenance.store.iterator.EventIterator;
import org.apache.nifi.provenance.util.DirectoryUtils;
import org.apache.nifi.reporting.Severity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PartitionedEventStore
implements EventStore {
    private static final Logger logger = LoggerFactory.getLogger(PartitionedEventStore.class);
    private static final String EVENT_CATEGORY = "Provenance Repository";
    private final AtomicLong partitionIndex = new AtomicLong(0L);
    private final RepositoryConfiguration repoConfig;
    private final EventReporter eventReporter;
    private ScheduledExecutorService maintenanceExecutor;

    public PartitionedEventStore(RepositoryConfiguration config, EventReporter eventReporter) {
        this.repoConfig = config;
        this.eventReporter = eventReporter;
    }

    @Override
    public void initialize() throws IOException {
        this.maintenanceExecutor = Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory("Provenance Repository Maintenance"));
        long maintenanceMillis = this.repoConfig.getMaintenanceFrequency(TimeUnit.MILLISECONDS);
        this.maintenanceExecutor.scheduleWithFixedDelay(this::performMaintenance, maintenanceMillis, maintenanceMillis, TimeUnit.MILLISECONDS);
        for (EventStorePartition eventStorePartition : this.getPartitions()) {
            eventStorePartition.initialize();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.maintenanceExecutor != null) {
            this.maintenanceExecutor.shutdownNow();
        }
        IOException thrown = null;
        for (EventStorePartition eventStorePartition : this.getPartitions()) {
            try {
                eventStorePartition.close();
            }
            catch (IOException ioe) {
                if (thrown == null) {
                    thrown = ioe;
                    continue;
                }
                thrown.addSuppressed(ioe);
            }
        }
        if (thrown != null) {
            throw thrown;
        }
    }

    @Override
    public StorageResult addEvents(Iterable<ProvenanceEventRecord> events) throws IOException {
        List<? extends EventStorePartition> partitions = this.getPartitions();
        int index = (int)(this.partitionIndex.getAndIncrement() % (long)partitions.size());
        EventStorePartition partition = partitions.get(index);
        return partition.addEvents(events);
    }

    @Override
    public long getSize() {
        long size = 0L;
        for (EventStorePartition eventStorePartition : this.getPartitions()) {
            size += eventStorePartition.getSize();
        }
        return size;
    }

    private long getRepoSize() {
        long total = 0L;
        for (File storageDir : this.repoConfig.getStorageDirectories().values()) {
            total += DirectoryUtils.getSize(storageDir);
        }
        return total;
    }

    @Override
    public long getMaxEventId() {
        return this.getPartitions().stream().mapToLong(EventStorePartition::getMaxEventId).max().orElse(-1L);
    }

    @Override
    public Optional<ProvenanceEventRecord> getEvent(long id) throws IOException {
        for (EventStorePartition eventStorePartition : this.getPartitions()) {
            Optional<ProvenanceEventRecord> option = eventStorePartition.getEvent(id);
            if (!option.isPresent()) continue;
            return option;
        }
        return Optional.empty();
    }

    @Override
    public List<ProvenanceEventRecord> getEvents(long firstRecordId, int maxRecords) throws IOException {
        return this.getEvents(firstRecordId, maxRecords, EventAuthorizer.GRANT_ALL, EventTransformer.EMPTY_TRANSFORMER);
    }

    @Override
    public List<ProvenanceEventRecord> getEvents(long firstRecordId, int maxRecords, EventAuthorizer authorizer, EventTransformer transformer) throws IOException {
        if (firstRecordId + (long)maxRecords < 1L || maxRecords < 1 || firstRecordId > this.getMaxEventId()) {
            return Collections.emptyList();
        }
        return this.getEvents(maxRecords, authorizer, (EventStorePartition part) -> part.createEventIterator(firstRecordId), transformer);
    }

    @Override
    public List<ProvenanceEventRecord> getEvents(List<Long> eventIds, EventAuthorizer authorizer, EventTransformer transformer) throws IOException {
        if (eventIds == null || eventIds.isEmpty()) {
            return Collections.emptyList();
        }
        return this.getEvents(eventIds.size(), authorizer, (EventStorePartition part) -> part.createEventIterator(eventIds), transformer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ProvenanceEventRecord> getEvents(int maxRecords, EventAuthorizer authorizer, Function<EventStorePartition, EventIterator> eventIteratorFactory, EventTransformer transformer) throws IOException {
        if (maxRecords < 1) {
            return Collections.emptyList();
        }
        ArrayList<ProvenanceEventRecord> selectedEvents = new ArrayList<ProvenanceEventRecord>();
        TreeMap<ProvenanceEventRecord, EventIterator> recordToIteratorMap = new TreeMap<ProvenanceEventRecord, EventIterator>((o1, o2) -> Long.compare(o1.getEventId(), o2.getEventId()));
        ArrayList<AuthorizingEventIterator> createdIterators = new ArrayList<AuthorizingEventIterator>();
        try {
            for (EventStorePartition arrayList : this.getPartitions()) {
                EventAuthorizer eventAuthorizer = authorizer == null ? EventAuthorizer.GRANT_ALL : authorizer;
                EventIterator partitionIterator = eventIteratorFactory.apply(arrayList);
                AuthorizingEventIterator iterator = new AuthorizingEventIterator(partitionIterator, eventAuthorizer, transformer);
                createdIterators.add(iterator);
                Optional<ProvenanceEventRecord> option = iterator.nextEvent();
                if (!option.isPresent()) continue;
                recordToIteratorMap.put(option.get(), iterator);
            }
            if (recordToIteratorMap.isEmpty()) {
                ArrayList<ProvenanceEventRecord> arrayList = selectedEvents;
                return arrayList;
            }
            ProvenanceEventRecord nextEvent = (ProvenanceEventRecord)recordToIteratorMap.firstKey();
            while (nextEvent != null && selectedEvents.size() < maxRecords) {
                selectedEvents.add(nextEvent);
                EventIterator eventIterator = (EventIterator)recordToIteratorMap.remove(nextEvent);
                Optional<ProvenanceEventRecord> optional = eventIterator.nextEvent();
                if (optional.isPresent()) {
                    recordToIteratorMap.put(optional.get(), eventIterator);
                }
                nextEvent = recordToIteratorMap.isEmpty() ? null : (ProvenanceEventRecord)recordToIteratorMap.firstKey();
            }
            ArrayList<ProvenanceEventRecord> arrayList = selectedEvents;
            return arrayList;
        }
        finally {
            for (EventIterator eventIterator : createdIterators) {
                try {
                    eventIterator.close();
                }
                catch (Exception e) {
                    if (logger.isDebugEnabled()) {
                        logger.warn("Failed to close Record Reader {}", (Object)eventIterator, (Object)e);
                        continue;
                    }
                    logger.warn("Failed to close Record Reader {}", (Object)eventIterator);
                }
            }
        }
    }

    void performMaintenance() {
        try {
            long currentSize;
            long maxFileLife = this.repoConfig.getMaxRecordLife(TimeUnit.MILLISECONDS);
            for (EventStorePartition eventStorePartition : this.getPartitions()) {
                try {
                    eventStorePartition.purgeOldEvents(maxFileLife, TimeUnit.MILLISECONDS);
                }
                catch (Exception e) {
                    logger.error("Failed to purge expired events from {}", (Object)eventStorePartition, (Object)e);
                    this.eventReporter.reportEvent(Severity.WARNING, EVENT_CATEGORY, "Failed to purge expired events from Provenance Repository. See logs for more information.");
                }
            }
            long maxStorageCapacity = this.repoConfig.getMaxStorageCapacity();
            try {
                currentSize = this.getRepoSize();
            }
            catch (Exception e) {
                logger.error("Could not determine size of Provenance Repository. Will not expire any data due to storage limits", (Throwable)e);
                this.eventReporter.reportEvent(Severity.WARNING, EVENT_CATEGORY, "Failed to determine size of Provenance Repository. No data will be expired due to storage limits at this time. See logs for more information.");
                return;
            }
            while (currentSize > maxStorageCapacity) {
                for (EventStorePartition eventStorePartition : this.getPartitions()) {
                    try {
                        long removed = eventStorePartition.purgeOldestEvents();
                        currentSize -= removed;
                    }
                    catch (Exception e) {
                        logger.error("Failed to purge oldest events from {}", (Object)eventStorePartition, (Object)e);
                        this.eventReporter.reportEvent(Severity.WARNING, EVENT_CATEGORY, "Failed to purge oldest events from Provenance Repository. See logs for more information.");
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("Failed to perform periodic maintenance", (Throwable)e);
            this.eventReporter.reportEvent(Severity.ERROR, EVENT_CATEGORY, "Failed to perform periodic maintenace for Provenance Repository. See logs for more information.");
        }
    }

    protected abstract List<? extends EventStorePartition> getPartitions();
}

