/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance.serialization;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collection;
import java.util.zip.GZIPInputStream;
import org.apache.nifi.provenance.ByteArraySchemaRecordReader;
import org.apache.nifi.provenance.EventIdFirstSchemaRecordReader;
import org.apache.nifi.provenance.lucene.LuceneUtil;
import org.apache.nifi.provenance.serialization.EmptyRecordReader;
import org.apache.nifi.provenance.serialization.RecordReader;
import org.apache.nifi.provenance.toc.StandardTocReader;
import org.apache.nifi.provenance.toc.TocUtil;

public class RecordReaders {
    public static RecordReader newRecordReader(File file, Collection<Path> provenanceLogFiles, int maxAttributeChars) throws IOException {
        File originalFile = file;
        InputStream fis = null;
        try {
            String serializationName;
            if (!file.exists() && provenanceLogFiles != null) {
                String baseName = LuceneUtil.substringBefore(file.getName(), ".") + ".";
                for (Path path : provenanceLogFiles) {
                    if (!path.toFile().getName().startsWith(baseName)) continue;
                    file = path.toFile();
                    break;
                }
            }
            if (file.exists()) {
                try {
                    fis = new FileInputStream(file);
                }
                catch (FileNotFoundException fnfe) {
                    fis = null;
                }
            }
            Object filename = file.getName();
            block19: while (fis == null) {
                File dir = file.getParentFile();
                String baseName = LuceneUtil.substringBefore(file.getName(), ".prov");
                for (String extension : new String[]{".prov.gz", ".prov"}) {
                    file = new File(dir, baseName + extension);
                    if (!file.exists()) continue;
                    try {
                        fis = new FileInputStream(file);
                        filename = baseName + extension;
                        break block19;
                    }
                    catch (FileNotFoundException fnfe) {
                        fis = null;
                        continue block19;
                    }
                }
            }
            if (fis == null) {
                throw new FileNotFoundException("Unable to locate file " + String.valueOf(originalFile));
            }
            File tocFile = TocUtil.getTocFile(file);
            BufferedInputStream bufferedInStream = new BufferedInputStream(fis);
            try {
                ((InputStream)bufferedInStream).mark(4096);
                FilterInputStream in = ((String)filename).endsWith(".gz") ? new GZIPInputStream(bufferedInStream) : bufferedInStream;
                DataInputStream dis = new DataInputStream(in);
                serializationName = dis.readUTF();
                ((InputStream)bufferedInStream).reset();
            }
            catch (EOFException eof) {
                fis.close();
                return new EmptyRecordReader();
            }
            switch (serializationName) {
                case "ByteArraySchemaRecordWriter": {
                    StandardTocReader tocReader;
                    if (tocFile.exists()) {
                        tocReader = new StandardTocReader(tocFile);
                        return new ByteArraySchemaRecordReader(bufferedInStream, (String)filename, tocReader, maxAttributeChars);
                    }
                    return new ByteArraySchemaRecordReader(bufferedInStream, (String)filename, maxAttributeChars);
                }
                case "EventIdFirstSchemaRecordWriter": {
                    if (!tocFile.exists()) {
                        throw new FileNotFoundException("Cannot create TOC Reader because the file " + String.valueOf(tocFile) + " does not exist");
                    }
                    StandardTocReader tocReader = new StandardTocReader(tocFile);
                    return new EventIdFirstSchemaRecordReader(bufferedInStream, (String)filename, tocReader, maxAttributeChars);
                }
            }
            throw new IOException("Unable to read data from file " + String.valueOf(file) + " because the file was written using an unknown Serializer: " + serializationName);
        }
        catch (IOException ioe) {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException inner) {
                    ioe.addSuppressed(inner);
                }
            }
            throw ioe;
        }
    }
}

