/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance.index.lucene;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.provenance.index.EventIndexSearcher;
import org.apache.nifi.provenance.lucene.IndexManager;
import org.apache.nifi.provenance.util.DirectoryUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneCacheWarmer
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(LuceneCacheWarmer.class);
    private final File storageDir;
    private final IndexManager indexManager;

    public LuceneCacheWarmer(File storageDir, IndexManager indexManager) {
        this.storageDir = storageDir;
        this.indexManager = indexManager;
    }

    @Override
    public void run() {
        try {
            File[] indexDirs = this.storageDir.listFiles(DirectoryUtils.INDEX_FILE_FILTER);
            if (indexDirs == null) {
                logger.info("Cannot warm Lucene Index Cache for {} because the directory could not be read", (Object)this.storageDir);
                return;
            }
            logger.info("Beginning warming of Lucene Index Cache for {}", (Object)this.storageDir);
            long startNanos = System.nanoTime();
            for (File indexDir : indexDirs) {
                EventIndexSearcher eventSearcher;
                long indexStartNanos = System.nanoTime();
                try {
                    eventSearcher = this.indexManager.borrowIndexSearcher(indexDir);
                }
                catch (FileNotFoundException fnfe) {
                    logger.debug("Cannot warm Lucene Index directory {} because the directory no longer exists", (Object)indexDir);
                    continue;
                }
                this.indexManager.returnIndexSearcher(eventSearcher);
                long indexWarmMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - indexStartNanos);
                logger.debug("Took {} ms to warm Lucene Index {}", (Object)indexWarmMillis, (Object)indexDir);
            }
            long warmSecs = TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - startNanos);
            logger.info("Finished warming all Lucene Indexes for {} in {} seconds", (Object)this.storageDir, (Object)warmSecs);
        }
        catch (Exception e) {
            logger.error("Failed to warm Lucene Index Cache for {}", (Object)this.storageDir, (Object)e);
        }
    }
}

