/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.graph;

import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SslContext;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.nifi.annotation.behavior.RequiresInstanceClassLoading;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.components.resource.ResourceCardinality;
import org.apache.nifi.components.resource.ResourceType;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.graph.GraphClientService;
import org.apache.nifi.graph.GraphQueryResultCallback;
import org.apache.nifi.graph.gremlin.SimpleEntry;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.ssl.SSLContextProvider;
import org.apache.nifi.util.StringUtils;
import org.apache.nifi.util.file.classloader.ClassLoaderUtils;
import org.apache.tinkerpop.gremlin.driver.Client;
import org.apache.tinkerpop.gremlin.driver.Cluster;
import org.apache.tinkerpop.gremlin.driver.Result;
import org.apache.tinkerpop.gremlin.driver.remote.DriverRemoteConnection;
import org.apache.tinkerpop.gremlin.process.remote.RemoteConnection;
import org.apache.tinkerpop.gremlin.process.traversal.AnonymousTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;

@Tags(value={"graph", "gremlin"})
@CapabilityDescription(value="This service interacts with a tinkerpop-compliant graph service, providing both script submission and bytecode submission capabilities. Script submission is the default, with the script command being sent to the gremlin server as text. This should only be used for simple interactions with a tinkerpop-compliant server such as counts or other operations that do not require the injection of custom classed. Bytecode submission allows much more flexibility. When providing a jar, custom serializers can be used and pre-compiled graph logic can be utilized by groovy scriptsprovided by processors such as the ExecuteGraphQueryRecord.")
@RequiresInstanceClassLoading
public class TinkerpopClientService
extends AbstractControllerService
implements GraphClientService {
    public static final String NOT_SUPPORTED = "NOT_SUPPORTED";
    private static final AllowableValue BYTECODE_SUBMISSION = new AllowableValue("bytecode-submission", "ByteCode Submission", "Groovy scripts are compiled within NiFi, with the GraphTraversalSource injected as a variable 'g'. Effectively allowing your logic to directly manipulates the graph without string serialization overheard.");
    private static final AllowableValue SCRIPT_SUBMISSION = new AllowableValue("script-submission", "Script Submission", "Script is sent to the gremlin server as a submission. Similar to a rest request. ");
    private static final AllowableValue YAML_SETTINGS = new AllowableValue("yaml-settings", "Yaml Settings", "Connection to the gremlin server will be specified via a YAML file (very flexible)");
    private static final AllowableValue SERVICE_SETTINGS = new AllowableValue("service-settings", "Service-Defined Settings", "Connection to the gremlin server will be specified via values on this controller (simpler). Only recommended for testing and development with a simple grpah instance. ");
    public static final PropertyDescriptor SUBMISSION_TYPE = new PropertyDescriptor.Builder().name("Script Submission Type").description("A selection that toggles for between script submission or as bytecode submission").allowableValues(new DescribedValue[]{SCRIPT_SUBMISSION, BYTECODE_SUBMISSION}).defaultValue("script-submission").required(true).build();
    public static final PropertyDescriptor CONNECTION_SETTINGS = new PropertyDescriptor.Builder().name("Settings Specification").description("Selecting \"Service-Defined Settings\" connects using the setting on this service. Selecting \"Yaml Settings\" uses the specified YAML file for connection settings. ").allowableValues(new DescribedValue[]{SERVICE_SETTINGS, YAML_SETTINGS}).defaultValue("service-settings").required(true).build();
    public static final PropertyDescriptor CONTACT_POINTS = new PropertyDescriptor.Builder().name("Contact Points").description("A comma-separated list of hostnames or IP addresses where an Gremlin-enabled server can be found.").required(true).addValidator(StandardValidators.NON_EMPTY_EL_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).dependsOn(CONNECTION_SETTINGS, new AllowableValue[]{SERVICE_SETTINGS}).build();
    public static final PropertyDescriptor PORT = new PropertyDescriptor.Builder().name("Port").description("The port where Gremlin Server is running on each host listed as a contact point.").required(true).defaultValue("8182").addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).dependsOn(CONNECTION_SETTINGS, new AllowableValue[]{SERVICE_SETTINGS}).build();
    public static final PropertyDescriptor PATH = new PropertyDescriptor.Builder().name("Path").description("The URL path where Gremlin Server is running on each host listed as a contact point.").required(true).defaultValue("/gremlin").addValidator(Validator.VALID).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).dependsOn(CONNECTION_SETTINGS, new AllowableValue[]{SERVICE_SETTINGS}).build();
    public static final PropertyDescriptor TRAVERSAL_SOURCE_NAME = new PropertyDescriptor.Builder().name("Traversal Source Name").description("An optional property that lets you set the name of the remote traversal instance. This can be really important when working with databases like JanusGraph that support multiple backend traversal configurations simultaneously.").expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).addValidator(Validator.VALID).build();
    public static final PropertyDescriptor REMOTE_OBJECTS_FILE = new PropertyDescriptor.Builder().name("Remote Objects File").description("The remote-objects file YAML used for connecting to the gremlin server.").required(true).addValidator(StandardValidators.FILE_EXISTS_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).dependsOn(CONNECTION_SETTINGS, new AllowableValue[]{YAML_SETTINGS}).build();
    public static final PropertyDescriptor USERNAME = new PropertyDescriptor.Builder().name("Username").description("The username used to authenticate with the gremlin server. Note: when using a remote.yaml file, this username value (if set) will overload any username set in the YAML file.").required(false).addValidator(Validator.VALID).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    public static final PropertyDescriptor PASSWORD = new PropertyDescriptor.Builder().name("Password").description("The password used to authenticate with the gremlin server. Note: when using a remote.yaml file, this password setting (if set) will override any password set in the YAML file").required(false).sensitive(true).addValidator(Validator.VALID).build();
    public static final PropertyDescriptor EXTRA_RESOURCE = new PropertyDescriptor.Builder().name("Extension Libraries").description("A comma-separated list of Java JAR files to be loaded. This should contain any Serializers or other classes specified in the YAML file. Additionally, any custom classes required for the groovy script to work in the bytecode submission setting should also be contained in these JAR files.").dependsOn(CONNECTION_SETTINGS, new AllowableValue[]{YAML_SETTINGS}).identifiesExternalResource(ResourceCardinality.MULTIPLE, ResourceType.FILE, new ResourceType[]{ResourceType.DIRECTORY, ResourceType.URL}).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).dynamicallyModifiesClasspath(true).build();
    public static final PropertyDescriptor EXTENSION_CLASSES = new PropertyDescriptor.Builder().name("Extension Classes").addValidator(Validator.VALID).description("A comma-separated list of fully qualified Java class names that correspond to classes to implement. This is useful for services such as JanusGraph that need specific serialization classes. This configuration property has no effect unless a value for the Extension JAR field is also provided.").dependsOn(EXTRA_RESOURCE, new AllowableValue[0]).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).dependsOn(CONNECTION_SETTINGS, new AllowableValue[]{YAML_SETTINGS}).required(false).build();
    public static final PropertyDescriptor SSL_CONTEXT_SERVICE = new PropertyDescriptor.Builder().name("SSL Context Service").description("The SSL Context Service used to provide client certificate information for TLS connections.").required(false).identifiesControllerService(SSLContextProvider.class).build();
    public static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(SUBMISSION_TYPE, CONNECTION_SETTINGS, REMOTE_OBJECTS_FILE, EXTRA_RESOURCE, EXTENSION_CLASSES, CONTACT_POINTS, PORT, PATH, TRAVERSAL_SOURCE_NAME, USERNAME, PASSWORD, SSL_CONTEXT_SERVICE);
    private GroovyShell groovyShell;
    private Map<String, Script> compiledCode;
    protected Cluster cluster;
    private String traversalSourceName;
    private GraphTraversalSource traversalSource;
    private boolean scriptSubmission = true;
    boolean usesSSL;
    protected String transitUrl;

    public void migrateProperties(PropertyConfiguration propertyConfiguration) {
        propertyConfiguration.renameProperty("submission-type", SUBMISSION_TYPE.getName());
        propertyConfiguration.renameProperty("connection-settings", CONNECTION_SETTINGS.getName());
        propertyConfiguration.renameProperty("remote-objects-file", REMOTE_OBJECTS_FILE.getName());
        propertyConfiguration.renameProperty("extension", EXTRA_RESOURCE.getName());
        propertyConfiguration.renameProperty("extension-classes", EXTENSION_CLASSES.getName());
        propertyConfiguration.renameProperty("tinkerpop-contact-points", CONTACT_POINTS.getName());
        propertyConfiguration.renameProperty("tinkerpop-port", PORT.getName());
        propertyConfiguration.renameProperty("tinkerpop-path", PATH.getName());
        propertyConfiguration.renameProperty("gremlin-traversal-source-name", TRAVERSAL_SOURCE_NAME.getName());
        propertyConfiguration.renameProperty("user-name", USERNAME.getName());
        propertyConfiguration.renameProperty("password", PASSWORD.getName());
        propertyConfiguration.renameProperty("ssl-context-service", SSL_CONTEXT_SERVICE.getName());
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) throws InitializationException {
        this.loadClasses(context);
        GroovyClassLoader loader = new GroovyClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        this.groovyShell = new GroovyShell((ClassLoader)loader);
        this.compiledCode = new ConcurrentHashMap<String, Script>();
        if (context.getProperty(TRAVERSAL_SOURCE_NAME).isSet()) {
            this.traversalSourceName = context.getProperty(TRAVERSAL_SOURCE_NAME).evaluateAttributeExpressions().getValue();
        }
        this.scriptSubmission = context.getProperty(SUBMISSION_TYPE).getValue().equals(SCRIPT_SUBMISSION.getValue());
        this.cluster = this.buildCluster(context);
    }

    @OnDisabled
    public void shutdown() {
        try {
            this.compiledCode = null;
            if (this.traversalSource != null) {
                this.traversalSource.close();
            }
        }
        catch (Exception e) {
            throw new ProcessException((Throwable)e);
        }
        finally {
            if (this.cluster != null) {
                this.cluster.close();
            }
            this.cluster = null;
            this.traversalSource = null;
        }
    }

    public Map<String, String> executeQuery(String s, Map<String, Object> map, GraphQueryResultCallback graphQueryResultCallback) {
        try {
            if (this.scriptSubmission) {
                return this.scriptSubmission(s, map, graphQueryResultCallback);
            }
            return this.bytecodeSubmission(s, map, graphQueryResultCallback);
        }
        catch (Exception ex) {
            throw new ProcessException((Throwable)ex);
        }
    }

    public String getTransitUrl() {
        return this.transitUrl;
    }

    public List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public Collection<ValidationResult> customValidate(ValidationContext context) {
        boolean clzIsSet;
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        boolean jarsIsSet = !StringUtils.isEmpty((String)context.getProperty(EXTRA_RESOURCE).getValue());
        boolean bl = clzIsSet = !StringUtils.isEmpty((String)context.getProperty(EXTENSION_CLASSES).getValue());
        if (jarsIsSet && clzIsSet) {
            try {
                String[] classes;
                ClassLoader loader = ClassLoaderUtils.getCustomClassLoader((String)context.getProperty(EXTRA_RESOURCE).getValue(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), null);
                for (String clz : classes = context.getProperty(EXTENSION_CLASSES).evaluateAttributeExpressions().getValue().split(",[\\s]*")) {
                    Class.forName(clz, true, loader);
                }
            }
            catch (Exception ex) {
                results.add(new ValidationResult.Builder().subject(EXTENSION_CLASSES.getDisplayName()).valid(false).explanation(ex.toString()).build());
            }
        }
        if (context.getProperty(USERNAME).isSet() && !context.getProperty(PASSWORD).isSet()) {
            results.add(new ValidationResult.Builder().explanation("When specifying a username, the password must also be set").valid(false).build());
        }
        if (context.getProperty(PASSWORD).isSet() && !context.getProperty(USERNAME).isSet()) {
            results.add(new ValidationResult.Builder().explanation("When specifying a password, the password must also be set").valid(false).build());
        }
        return results;
    }

    protected Cluster.Builder setupSSL(ConfigurationContext context, Cluster.Builder builder) {
        if (context.getProperty(SSL_CONTEXT_SERVICE).isSet()) {
            SSLContextProvider sslContextProvider = (SSLContextProvider)context.getProperty(SSL_CONTEXT_SERVICE).asControllerService(SSLContextProvider.class);
            ApplicationProtocolConfig applicationProtocolConfig = new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.NONE, ApplicationProtocolConfig.SelectorFailureBehavior.FATAL_ALERT, ApplicationProtocolConfig.SelectedListenerFailureBehavior.FATAL_ALERT, new String[0]);
            JdkSslContext jdkSslContext = new JdkSslContext(sslContextProvider.createContext(), true, null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE, applicationProtocolConfig, ClientAuth.NONE, null, false);
            builder.enableSsl(true).sslContext((SslContext)jdkSslContext);
            this.usesSSL = true;
        }
        return builder;
    }

    public void loadClasses(ConfigurationContext context) {
        String path = context.getProperty(EXTRA_RESOURCE).getValue();
        String classList = context.getProperty(EXTENSION_CLASSES).getValue();
        if (path != null && classList != null && !path.isEmpty() && !classList.isEmpty()) {
            try {
                String[] classes;
                ClassLoader loader = ClassLoaderUtils.getCustomClassLoader((String)path, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), null);
                for (String cls : classes = context.getProperty(EXTENSION_CLASSES).evaluateAttributeExpressions().getValue().split(",[\\s]*")) {
                    Class<?> clz = Class.forName(cls.trim(), true, loader);
                    if (!this.getLogger().isDebugEnabled()) continue;
                    this.getLogger().debug(clz.getName());
                }
            }
            catch (Exception e) {
                throw new ProcessException((Throwable)e);
            }
        }
    }

    protected Cluster buildCluster(ConfigurationContext context) {
        Cluster.Builder builder = Cluster.build();
        ArrayList<String> hosts = new ArrayList<String>();
        if (!context.getProperty(REMOTE_OBJECTS_FILE).isSet()) {
            String[] contactPoints;
            String contactProp = context.getProperty(CONTACT_POINTS).evaluateAttributeExpressions().getValue();
            int port = context.getProperty(PORT).evaluateAttributeExpressions().asInteger();
            String path = context.getProperty(PATH).evaluateAttributeExpressions().getValue();
            for (String contactPoint : contactPoints = contactProp.split(",[\\s]*")) {
                builder.addContactPoint(contactPoint.trim());
                hosts.add(contactPoint.trim());
            }
            builder.port(port);
            if (path != null && !path.isEmpty()) {
                builder.path(path);
            }
        } else {
            File yamlFile = new File(context.getProperty(REMOTE_OBJECTS_FILE).evaluateAttributeExpressions().getValue());
            try {
                builder = Cluster.build((File)yamlFile);
            }
            catch (Exception ex) {
                throw new ProcessException((Throwable)ex);
            }
        }
        builder = this.setupSSL(context, builder);
        if (context.getProperty(USERNAME).isSet() && context.getProperty(PASSWORD).isSet()) {
            String username = context.getProperty(USERNAME).evaluateAttributeExpressions().getValue();
            String password = context.getProperty(PASSWORD).getValue();
            builder.credentials(username, password);
        }
        Cluster cluster = builder.create();
        this.transitUrl = String.format("gremlin%s://%s:%s%s", this.usesSSL ? "+ssl" : "", String.join((CharSequence)",", hosts), cluster.getPort(), cluster.getPath());
        return cluster;
    }

    protected Map<String, String> scriptSubmission(String query, Map<String, Object> parameters, GraphQueryResultCallback handler) {
        try {
            Client client = this.cluster.connect();
            Iterator iterator = client.submit(query, parameters).iterator();
            long count = 0L;
            while (iterator.hasNext()) {
                Result result = (Result)iterator.next();
                final Object obj = result.getObject();
                if (obj instanceof Map) {
                    handler.process((Map)obj, iterator.hasNext());
                } else {
                    handler.process((Map)new HashMap<String, Object>(){
                        {
                            this.put("result", obj);
                        }
                    }, iterator.hasNext());
                }
                ++count;
            }
            HashMap<String, String> resultAttributes = new HashMap<String, String>();
            resultAttributes.put("graph.nodes.created", NOT_SUPPORTED);
            resultAttributes.put("graph.relations.created", NOT_SUPPORTED);
            resultAttributes.put("graph.labels.added", NOT_SUPPORTED);
            resultAttributes.put("graph.nodes.deleted", NOT_SUPPORTED);
            resultAttributes.put("graph.relations.deleted", NOT_SUPPORTED);
            resultAttributes.put("graph.properties.set", NOT_SUPPORTED);
            resultAttributes.put("graph.rows.returned", String.valueOf(count));
            return resultAttributes;
        }
        catch (Exception ex) {
            throw new ProcessException((Throwable)ex);
        }
    }

    protected Map<String, String> bytecodeSubmission(String s, Map<String, Object> map, GraphQueryResultCallback graphQueryResultCallback) {
        Script compiled;
        String hash = DigestUtils.sha256Hex((String)s);
        if (this.traversalSource == null) {
            this.traversalSource = this.createTraversal();
        }
        int rowsReturned = 0;
        if (this.compiledCode.containsKey(hash)) {
            compiled = this.compiledCode.get(hash);
        } else {
            compiled = this.groovyShell.parse(s);
            this.compiledCode.put(s, compiled);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("{}", new Object[]{map});
        }
        Binding bindings = new Binding();
        map.forEach((arg_0, arg_1) -> ((Binding)bindings).setProperty(arg_0, arg_1));
        bindings.setProperty("g", (Object)this.traversalSource);
        bindings.setProperty("log", (Object)this.getLogger());
        try {
            Map resultMap;
            compiled.setBinding(bindings);
            Object result = compiled.run();
            if (result instanceof Map && !(resultMap = (Map)result).isEmpty()) {
                for (Map.Entry innerResultSet : resultMap.entrySet()) {
                    if (innerResultSet.getValue() instanceof Map) {
                        Iterator resultSet = ((Map)innerResultSet.getValue()).entrySet().iterator();
                        while (resultSet.hasNext()) {
                            Map.Entry tempResult = resultSet.next();
                            HashMap tempRetObject = new HashMap();
                            tempRetObject.put((String)tempResult.getKey(), tempResult.getValue());
                            SimpleEntry returnObject = new SimpleEntry((String)tempResult.getKey(), tempRetObject);
                            HashMap resultReturnMap = new HashMap();
                            resultReturnMap.put((String)innerResultSet.getKey(), returnObject);
                            if (this.getLogger().isDebugEnabled()) {
                                this.getLogger().debug("{}", new Object[]{resultReturnMap});
                            }
                            graphQueryResultCallback.process(resultReturnMap, resultSet.hasNext());
                        }
                    } else {
                        HashMap resultReturnMap = new HashMap();
                        resultReturnMap.put((String)innerResultSet.getKey(), innerResultSet.getValue());
                        graphQueryResultCallback.process(resultReturnMap, false);
                    }
                    ++rowsReturned;
                }
            }
        }
        catch (Exception e) {
            throw new ProcessException((Throwable)e);
        }
        HashMap<String, String> resultAttributes = new HashMap<String, String>();
        resultAttributes.put("graph.rows.returned", String.valueOf(rowsReturned));
        return resultAttributes;
    }

    protected GraphTraversalSource createTraversal() {
        GraphTraversalSource traversal;
        try {
            traversal = StringUtils.isEmpty((String)this.traversalSourceName) ? (GraphTraversalSource)AnonymousTraversalSource.traversal().withRemote((RemoteConnection)DriverRemoteConnection.using((Cluster)this.cluster)) : (GraphTraversalSource)AnonymousTraversalSource.traversal().withRemote((RemoteConnection)DriverRemoteConnection.using((Cluster)this.cluster, (String)this.traversalSourceName));
        }
        catch (Exception e) {
            throw new ProcessException((Throwable)e);
        }
        return traversal;
    }
}

