/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.oauth2;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.ECDSASigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.net.ssl.X509ExtendedKeyManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.DynamicProperties;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.SupportsSensitiveDynamicProperties;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.ConfigVerificationResult;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.VerifiableControllerService;
import org.apache.nifi.expression.AttributeExpression;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.key.service.api.PrivateKeyService;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.oauth2.AccessToken;
import org.apache.nifi.oauth2.OAuth2AccessTokenProvider;
import org.apache.nifi.oauth2.key.Ed25519Signer;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.ssl.SSLContextProvider;
import org.apache.nifi.web.client.api.HttpRequestHeadersSpec;
import org.apache.nifi.web.client.api.HttpResponseEntity;
import org.apache.nifi.web.client.api.WebClientService;
import org.apache.nifi.web.client.provider.api.WebClientServiceProvider;

@SupportsSensitiveDynamicProperties
@Tags(value={"oauth2", "provider", "authorization", "access token", "hjwt"})
@CapabilityDescription(value="Provides OAuth 2.0 access tokens that can be used as Bearer authorization header in HTTP requests. This controller service is for implementing the OAuth 2.0 JWT Bearer Flow.")
@DynamicProperties(value={@DynamicProperty(name="CLAIM.JWT claim name", value="JWT claim value", expressionLanguageScope=ExpressionLanguageScope.ENVIRONMENT, description="Custom claims that should be added to the JWT."), @DynamicProperty(name="FORM.Request parameter name", value="Request parameter value", expressionLanguageScope=ExpressionLanguageScope.ENVIRONMENT, description="Custom parameters that should be added to the body of the request against the token endpoint.")})
public class JWTBearerOAuth2AccessTokenProvider
extends AbstractControllerService
implements OAuth2AccessTokenProvider,
VerifiableControllerService {
    public static final PropertyDescriptor TOKEN_ENDPOINT = new PropertyDescriptor.Builder().name("Token Endpoint URL").description("The URL of the OAuth2 token endpoint.").required(true).addValidator(StandardValidators.URL_VALIDATOR).build();
    public static final PropertyDescriptor WEB_CLIENT_SERVICE = new PropertyDescriptor.Builder().name("Web Client Service").description("The Web Client Service to use for calling the token endpoint.").identifiesControllerService(WebClientServiceProvider.class).required(true).build();
    public static final PropertyDescriptor PRIVATE_KEY_SERVICE = new PropertyDescriptor.Builder().name("Private Key Service").description("The private key service to use for signing JWTs.").identifiesControllerService(PrivateKeyService.class).required(true).build();
    public static final PropertyDescriptor SIGNING_ALGORITHM = new PropertyDescriptor.Builder().name("Signing Algorithm").description("The algorithm to use for signing the JWT.").allowableValues(new String[]{JWSAlgorithm.RS256.getName(), JWSAlgorithm.RS384.getName(), JWSAlgorithm.RS512.getName(), JWSAlgorithm.PS256.getName(), JWSAlgorithm.PS384.getName(), JWSAlgorithm.PS512.getName(), JWSAlgorithm.ES256.getName(), JWSAlgorithm.ES384.getName(), JWSAlgorithm.ES512.getName(), JWSAlgorithm.Ed25519.getName()}).defaultValue(JWSAlgorithm.PS256.getName()).required(true).addValidator(Validator.VALID).build();
    public static final PropertyDescriptor ISSUER = new PropertyDescriptor.Builder().name("Issuer").description("The issuer claim (iss) for the JWT.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    public static final PropertyDescriptor SUBJECT = new PropertyDescriptor.Builder().name("Subject").description("The subject claim (sub) for the JWT.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    public static final PropertyDescriptor AUDIENCE = new PropertyDescriptor.Builder().name("Audience").description("The audience claim (aud) for the JWT. Space-separated list of audiences if multiple are expected.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    public static final PropertyDescriptor SCOPE = new PropertyDescriptor.Builder().name("Scope").description("The scope claim (scope) for the JWT.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    public static final PropertyDescriptor GRANT_TYPE = new PropertyDescriptor.Builder().name("Grant Type").description("Value to set for the grant_type parameter in the request to the token endpoint.").required(true).defaultValue("urn:ietf:params:oauth:grant-type:jwt-bearer").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    public static final PropertyDescriptor ASSERTION = new PropertyDescriptor.Builder().name("Assertion Parameter Name").description("Name of the parameter to use for the JWT assertion in the request to the token endpoint.").required(true).defaultValue("assertion").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    public static final PropertyDescriptor HEADER_X5T = new PropertyDescriptor.Builder().name("Set JWT Header X.509 Cert Thumbprint").description("If true, will set the JWT header x5t field with the base64url-encoded SHA-256 thumbprint of the X.509 certificate's DER encoding.\nIf set to true, an instance of SSLContextProvider must be configured with a certificate using RSA algorithm.\n").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("false").addValidator(Validator.VALID).build();
    static final PropertyDescriptor SSL_CONTEXT_PROVIDER = new PropertyDescriptor.Builder().name("SSL Context Service").description("An instance of SSLContextProvider configured with a certificate that will be used to set the x5t header. Must be using RSA algorithm.").required(true).dependsOn(HEADER_X5T, "true", new String[0]).identifiesControllerService(SSLContextProvider.class).build();
    public static final PropertyDescriptor JTI = new PropertyDescriptor.Builder().name("JWT ID").description("The \"jti\" (JWT ID) claim provides a unique identifier for the JWT. The identifier value must be assigned in a\nmanner that ensures that there's a negligible probability that the same value will be accidentally assigned to a\ndifferent data object; if the application uses multiple issuers, collisions MUST be prevented among values produced\nby different issuers as well. The \"jti\" value is a case-sensitive string. If set, it is recommended to set this\nvalue to ${UUID()}.\n").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    public static final PropertyDescriptor KID = new PropertyDescriptor.Builder().name("Key ID").description("The ID of the public key used to sign the JWT. It'll be used as the kid header in the JWT.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    static final PropertyDescriptor REFRESH_WINDOW = new PropertyDescriptor.Builder().name("Refresh Window").description("The service will attempt to refresh tokens expiring within the refresh window, subtracting the configured duration from the token expiration.").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).defaultValue("5 minutes").required(true).build();
    static final PropertyDescriptor JWT_VALIDITY = new PropertyDescriptor.Builder().name("JWT Expiration Time").description("Expiration time used to set the corresponding claim of the JWT. In case the returned access token does not include\nan expiration time, this will be used with the refresh window to re-acquire a new access token.\n").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).defaultValue("1 hour").required(true).build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(TOKEN_ENDPOINT, WEB_CLIENT_SERVICE, PRIVATE_KEY_SERVICE, SIGNING_ALGORITHM, ISSUER, SUBJECT, AUDIENCE, SCOPE, JTI, HEADER_X5T, SSL_CONTEXT_PROVIDER, KID, GRANT_TYPE, ASSERTION, REFRESH_WINDOW, JWT_VALIDITY);
    private static final ObjectMapper ACCESS_DETAILS_MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).addMixIn(AccessToken.class, AccessTokenAdditionalParameters.class).setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE);
    private volatile AccessToken accessDetails;
    private volatile JWSSigner signer;
    private volatile WebClientService webClientService;
    private volatile PrivateKey privateKey;
    private volatile X509ExtendedKeyManager keyManager;
    private volatile String tokenEndpoint;
    private volatile Duration refreshWindow;
    private volatile Duration jwtValidity;
    private volatile String issuer;
    private volatile String subject;
    private volatile String audience;
    private volatile String algorithmName;
    private volatile String scope;
    private volatile Supplier<String> jti;
    private volatile String kid;
    private volatile String grantType;
    private volatile String assertion;
    private volatile boolean headerX5T;
    private volatile Map<String, String> customClaims;
    private volatile Map<String, String> formParams;
    static final String CLAIM_PREFIX = "CLAIM.";
    static final String FORM_PREFIX = "FORM.";
    private static final String APPLICATION_JSON = "application/json";
    private static final String APPLICATION_URLENCODED = "application/x-www-form-urlencoded";

    public List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        this.initProperties(context);
        this.initJWTSigner();
    }

    @OnDisabled
    public void onDisabled() {
        this.accessDetails = null;
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        if (propertyDescriptorName.startsWith(CLAIM_PREFIX)) {
            return new PropertyDescriptor.Builder().required(false).name(propertyDescriptorName).description("The value of the claim to add to the JWT.").addValidator(StandardValidators.createAttributeExpressionLanguageValidator((AttributeExpression.ResultType)AttributeExpression.ResultType.STRING, (boolean)true)).dynamic(true).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
        }
        if (propertyDescriptorName.startsWith(FORM_PREFIX)) {
            return new PropertyDescriptor.Builder().required(false).name(propertyDescriptorName).description("The value of the form parameter to add to the request body.").addValidator(StandardValidators.createAttributeExpressionLanguageValidator((AttributeExpression.ResultType)AttributeExpression.ResultType.STRING, (boolean)true)).dynamic(true).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
        }
        return null;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>(super.customValidate(validationContext));
        PrivateKeyService keyService = (PrivateKeyService)validationContext.getProperty(PRIVATE_KEY_SERVICE).asControllerService(PrivateKeyService.class);
        String algorithmName = validationContext.getProperty(SIGNING_ALGORITHM).getValue();
        PrivateKey privateKey = keyService.getPrivateKey();
        JWSAlgorithm algorithm = JWSAlgorithm.parse((String)algorithmName);
        if (validationContext.getProperty(HEADER_X5T).asBoolean().booleanValue() && !(privateKey instanceof RSAPrivateKey)) {
            validationResults.add(new ValidationResult.Builder().subject(HEADER_X5T.getDisplayName()).valid(false).explanation("The private key must be an RSA key to set the x5t header.").build());
        }
        if (privateKey instanceof RSAPrivateKey) {
            if (!algorithmName.startsWith("RS") && !algorithmName.startsWith("PS")) {
                validationResults.add(new ValidationResult.Builder().subject(SIGNING_ALGORITHM.getDisplayName()).valid(false).explanation("The private key is of RSA type, the signing algorithm must be either RS256 or PS256.").build());
            }
        } else if (privateKey instanceof ECPrivateKey) {
            if (!(algorithm.equals((Object)JWSAlgorithm.ES256) || algorithm.equals((Object)JWSAlgorithm.ES384) || algorithm.equals((Object)JWSAlgorithm.ES512))) {
                validationResults.add(new ValidationResult.Builder().subject(SIGNING_ALGORITHM.getDisplayName()).valid(false).explanation("The private key is of EC type, the signing algorithm must be either ES256, ES384 or ES512.").build());
            }
        } else if (!algorithm.equals((Object)JWSAlgorithm.Ed25519)) {
            validationResults.add(new ValidationResult.Builder().subject(SIGNING_ALGORITHM.getDisplayName()).valid(false).explanation(String.format("The provided key (algorithm = %s) is not supported for signing algorithm %s", privateKey.getAlgorithm(), algorithmName)).build());
        }
        return validationResults;
    }

    public List<ConfigVerificationResult> verify(ConfigurationContext context, ComponentLog verificationLogger, Map<String, String> variables) {
        this.initProperties(context);
        this.initJWTSigner();
        ConfigVerificationResult.Builder builder = new ConfigVerificationResult.Builder().verificationStepName("Acquire token");
        try {
            this.getAccessDetails();
            builder.outcome(ConfigVerificationResult.Outcome.SUCCESSFUL);
        }
        catch (Exception ex) {
            Object explanation = ex.getMessage();
            if (ex.getCause() != null) {
                explanation = (String)explanation + " (" + ex.getCause().getMessage() + ")";
            }
            builder.outcome(ConfigVerificationResult.Outcome.FAILED).explanation((String)explanation);
        }
        return Arrays.asList(builder.build());
    }

    public AccessToken getAccessDetails() {
        if (this.accessDetails == null || this.isRefreshRequired()) {
            try {
                this.acquireAccessDetails();
            }
            catch (Exception e) {
                throw new AccessTokenRetrievalException("Failed to acquire Access Token", e);
            }
        }
        return this.accessDetails;
    }

    private boolean isRefreshRequired() {
        if (this.accessDetails.getExpiresIn() > 0L) {
            Instant expirationRefreshTime = this.accessDetails.getFetchTime().plusSeconds(this.accessDetails.getExpiresIn()).minus(this.refreshWindow);
            return Instant.now().isAfter(expirationRefreshTime);
        }
        Instant expirationRefreshTime = this.accessDetails.getFetchTime().plusSeconds(this.jwtValidity.getSeconds()).minus(this.refreshWindow);
        return Instant.now().isAfter(expirationRefreshTime);
    }

    private void acquireAccessDetails() throws URISyntaxException, JOSEException {
        this.getLogger().debug("New Access Token request started [{}]", new Object[]{this.tokenEndpoint});
        Instant now = Instant.now();
        Date nowDate = Date.from(now);
        Date expirationTime = Date.from(now.plus(this.jwtValidity));
        JWTClaimsSet.Builder claimsSetBuilder = new JWTClaimsSet.Builder().expirationTime(expirationTime).issueTime(nowDate).notBeforeTime(nowDate);
        if (this.issuer != null) {
            claimsSetBuilder.issuer(this.issuer);
        }
        if (this.subject != null) {
            claimsSetBuilder.subject(this.subject);
        }
        if (this.audience != null) {
            claimsSetBuilder.audience(Arrays.asList(this.audience.split(" ")));
        }
        if (this.scope != null) {
            claimsSetBuilder.claim("scope", (Object)this.scope);
        }
        if (this.jti != null) {
            claimsSetBuilder.jwtID(this.jti.get());
        }
        this.customClaims.forEach((arg_0, arg_1) -> ((JWTClaimsSet.Builder)claimsSetBuilder).claim(arg_0, arg_1));
        JWSHeader.Builder headerBuilder = new JWSHeader.Builder(JWSAlgorithm.parse((String)this.algorithmName));
        headerBuilder.type(JOSEObjectType.JWT);
        if (this.kid != null) {
            headerBuilder.keyID(this.kid);
        }
        if (this.headerX5T) {
            try {
                String url = this.getBase64EncodedSHA256Digest();
                headerBuilder.x509CertSHA256Thumbprint(new Base64URL(url));
            }
            catch (AccessTokenRetrievalException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AccessTokenRetrievalException("Failed to set x5t header", e);
            }
        }
        HashMap<String, String> formParams = new HashMap<String, String>();
        formParams.put("grant_type", this.grantType);
        formParams.put(this.assertion, this.getAssertion(headerBuilder.build(), claimsSetBuilder.build()));
        formParams.putAll(this.formParams);
        this.requestTokenEndpoint(formParams);
    }

    private String getBase64EncodedSHA256Digest() throws NoSuchAlgorithmException, CertificateEncodingException {
        String alias = this.keyManager.chooseClientAlias(new String[]{"RSA"}, null, null);
        if (alias == null) {
            throw new AccessTokenRetrievalException("Cannot set x5t header because no key alias found");
        }
        PrivateKey privateKey = this.keyManager.getPrivateKey(alias);
        if (privateKey == null) {
            throw new AccessTokenRetrievalException(String.format("Cannot set x5t header because no private key found for alias %s", alias));
        }
        X509Certificate[] certificates = this.keyManager.getCertificateChain(alias);
        if (certificates == null || certificates.length == 0) {
            throw new AccessTokenRetrievalException(String.format("Cannot set x5t header because no certificate chain found for alias %s", alias));
        }
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        byte[] bytes = messageDigest.digest(certificates[0].getEncoded());
        return Base64.getEncoder().encodeToString(bytes);
    }

    protected void requestTokenEndpoint(Map<String, String> formParams) throws URISyntaxException {
        HttpRequestHeadersSpec request = this.webClientService.post().uri(new URI(this.tokenEndpoint)).header("Accept", APPLICATION_JSON).header("Content-Type", APPLICATION_URLENCODED).body(formParams.entrySet().stream().map(param -> (String)param.getKey() + "=" + (String)param.getValue()).collect(Collectors.joining("&")));
        try (HttpResponseEntity response = request.retrieve();){
            if (response.statusCode() != 200) {
                Object body;
                try (InputStream is = response.body();){
                    body = new String(is.readAllBytes(), StandardCharsets.UTF_8);
                }
                catch (IOException e) {
                    body = "[failed to read response: " + e.getMessage() + "]";
                }
                String message = "Failed to retrieve Access Token from [%s]: HTTP %s with Response [%s]".formatted(this.tokenEndpoint, response.statusCode(), body);
                throw new AccessTokenRetrievalException(message);
            }
            try (InputStream body = response.body();){
                this.accessDetails = (AccessToken)ACCESS_DETAILS_MAPPER.readValue(body, AccessToken.class);
            }
        }
        catch (IOException e) {
            throw new AccessTokenRetrievalException("Failed to retrieve or process access token details", e);
        }
    }

    protected String getAssertion(JWSHeader jwsHeader, JWTClaimsSet jwtClaimsSet) throws JOSEException {
        SignedJWT signedJWT = new SignedJWT(jwsHeader, jwtClaimsSet);
        signedJWT.sign(this.signer);
        return signedJWT.serialize();
    }

    private void initProperties(ConfigurationContext context) {
        this.privateKey = ((PrivateKeyService)context.getProperty(PRIVATE_KEY_SERVICE).asControllerService(PrivateKeyService.class)).getPrivateKey();
        this.tokenEndpoint = context.getProperty(TOKEN_ENDPOINT).getValue();
        this.webClientService = ((WebClientServiceProvider)context.getProperty(WEB_CLIENT_SERVICE).asControllerService(WebClientServiceProvider.class)).getWebClientService();
        this.refreshWindow = context.getProperty(REFRESH_WINDOW).asDuration();
        this.jwtValidity = context.getProperty(JWT_VALIDITY).asDuration();
        this.tokenEndpoint = context.getProperty(TOKEN_ENDPOINT).getValue();
        this.algorithmName = context.getProperty(SIGNING_ALGORITHM).getValue();
        this.headerX5T = context.getProperty(HEADER_X5T).asBoolean();
        this.grantType = context.getProperty(GRANT_TYPE).evaluateAttributeExpressions().getValue();
        this.assertion = context.getProperty(ASSERTION).evaluateAttributeExpressions().getValue();
        this.issuer = context.getProperty(ISSUER).isSet() ? context.getProperty(ISSUER).evaluateAttributeExpressions().getValue() : null;
        this.subject = context.getProperty(SUBJECT).isSet() ? context.getProperty(SUBJECT).evaluateAttributeExpressions().getValue() : null;
        this.audience = context.getProperty(AUDIENCE).isSet() ? context.getProperty(AUDIENCE).evaluateAttributeExpressions().getValue() : null;
        this.scope = context.getProperty(SCOPE).isSet() ? context.getProperty(SCOPE).evaluateAttributeExpressions().getValue() : null;
        this.jti = context.getProperty(JTI).isSet() ? () -> context.getProperty(JTI).evaluateAttributeExpressions().getValue() : null;
        this.kid = context.getProperty(KID).isSet() ? context.getProperty(KID).evaluateAttributeExpressions().getValue() : null;
        if (context.getProperty(SSL_CONTEXT_PROVIDER).isSet()) {
            SSLContextProvider sslContextProvider = (SSLContextProvider)context.getProperty(SSL_CONTEXT_PROVIDER).asControllerService(SSLContextProvider.class);
            this.keyManager = (X509ExtendedKeyManager)sslContextProvider.createKeyManager().orElseThrow(() -> new IllegalStateException("KeyManager not available"));
        }
        this.customClaims = new HashMap<String, String>();
        this.formParams = new HashMap<String, String>();
        for (PropertyDescriptor descriptor : context.getProperties().keySet()) {
            if (!descriptor.isDynamic()) continue;
            if (descriptor.getName().startsWith(CLAIM_PREFIX)) {
                this.customClaims.put(StringUtils.substringAfter((String)descriptor.getName(), (String)CLAIM_PREFIX), context.getProperty(descriptor).evaluateAttributeExpressions().getValue());
                continue;
            }
            if (!descriptor.getName().startsWith(FORM_PREFIX)) continue;
            this.formParams.put(StringUtils.substringAfter((String)descriptor.getName(), (String)FORM_PREFIX), URLEncoder.encode(context.getProperty(descriptor).evaluateAttributeExpressions().getValue(), StandardCharsets.UTF_8));
        }
    }

    private void initJWTSigner() {
        JWSAlgorithm algorithm = JWSAlgorithm.parse((String)this.algorithmName);
        PrivateKey privateKey = this.privateKey;
        if (privateKey instanceof RSAPrivateKey) {
            RSAPrivateKey rsaPrivateKey = (RSAPrivateKey)privateKey;
            this.signer = new RSASSASigner((PrivateKey)rsaPrivateKey);
        } else {
            privateKey = this.privateKey;
            if (privateKey instanceof ECPrivateKey) {
                ECPrivateKey ecPrivateKey = (ECPrivateKey)privateKey;
                try {
                    this.signer = new ECDSASigner(ecPrivateKey);
                }
                catch (JOSEException e) {
                    throw new IllegalArgumentException("Failed to create ECDSA signer", e);
                }
            } else if (algorithm.equals((Object)JWSAlgorithm.Ed25519)) {
                this.signer = new Ed25519Signer(this.privateKey);
            } else {
                throw new IllegalArgumentException(String.format("The provided key (algorithm = %s) is not supported for signing algorithm %s", this.privateKey.getAlgorithm(), this.algorithmName));
            }
        }
    }

    private final class AccessTokenRetrievalException
    extends RuntimeException {
        public AccessTokenRetrievalException(String message) {
            super(message);
        }

        public AccessTokenRetrievalException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    static interface AccessTokenAdditionalParameters {
        @JsonAnySetter
        public void setAdditionalParameter(String var1, Object var2);
    }
}

